/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.townto;

/**
 * Cette interface, une fois réalisée, permet à une classe de recevoir des
 * évènements si elle s'enregistre auprès d'un EventHandler.<br>
 *
 * @author Samuel GESCHE
 * @version 3.0
 * @since 3.0.0
 */

public interface EventListener {

    /**
     * Signale un évènement à cet écouteur.
     * @param eventCode int le code de l'évènement (EventHandler.XXX)
     * @param eventContent String un message associé à cet évènement.
     * @since 3.0.0
     */
    public void notifyEvent(int eventCode, String eventContent);
}
