/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.townto;
import java.util.Vector;

/**
 * Cette classe est le gestionnaire d'évènements personnalisés de l'application.
 * Il les renvoie aux EventListener qui se sont enregistrés.<br>
 * Pour l'instant, tout évènement est renvoyé à tout écouteur.<br>
 *
 * @author Samuel GESCHE
 * @version 3.5.1
 * @since 3.0.0
 */
public class EventHandler {
    private static Vector listeners = new Vector();

    /**
     * L'évènement "un terme a été choisi dans un graphe."
     */
    public final static int TERM_CHOSEN = 1000;

    /**
     * L'évènement "un synonyme ou un homonyme a été rajouté à la confrontation."
     */
    public final static int NEW_SYNONYM_OR_HOMONYM = 5000;

    /**
     * L'évènement "une image a été capturée."
     */
    public final static int NEW_CAPTURE = 5001;


    /**
     * Enregistre cet EventListener, afin qu'il soit informé de tous les
     * évènements qui arrivent ici.
     * @param listener EventListener l'EventListener en question.
     * @since 3.0.0
     */
    public static void register(EventListener listener) {
        listeners.add(listener);
    }

    /**
     * Envoie un évènement à tous les écouteurs enregistrés.
     * @param eventCode int le code de l'évènement (EventHandler.XXX)
     * @param eventContent String un message associé à cet évènement.
     * @since 3.0.0
     */
    public static void notifyEvent(int eventCode, String eventContent) {
        for (int i = 0; i < listeners.size(); i++) {
            ((EventListener) (listeners.elementAt(i))).notifyEvent(eventCode,
                    eventContent);
        }
    }
}
