/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm;

import data.Confrontation;
import data.TexteCommun;
import data.ListeSynonymes;
import ihm.townto.EventHandler;
import ihm.townto.EventListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.Dictionary;
import java.util.Hashtable;


/**
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class PanelSynonymes extends JTabbedPane implements EventListener{
    private Legende legende;
    private ListeSynonymes[] suggestionsN;
    private ListeSynonymes[] suggestionsT;
    private ListeSynonymes[] suggestionsP;
    private FenetrePrincipale container;
    private Confrontation confrontation;

    private PanelSynonymes parent;

    private JSplitPane pNoeuds;
    private JSplitPane pTypesLiens;
    private JSplitPane pProprietes;

    private JSlider nbN;
    private JSlider nbT;
    private JSlider nbP;

    private JButton bSuggN;
    private JButton bSuggT;
    private JButton bSuggP;

    private int[] reponses = {10, 20, 50, 100, Integer.MAX_VALUE};
    private final static int DELAI_RECH_RAPIDE = 500;


    public PanelSynonymes(FenetrePrincipale container, Confrontation confrontation) {
        super(JTabbedPane.TOP, JTabbedPane.WRAP_TAB_LAYOUT);
        EventHandler.register(this);
        Charte.formate(this);
        parent = this;
        legende = new Legende(confrontation.getAllNomsGraphes());
        suggestionsN = new ListeSynonymes[0];
        suggestionsT = new ListeSynonymes[0];
        suggestionsP = new ListeSynonymes[0];

        this.container = container;
        this.confrontation = confrontation;

        calculePanelNoeuds();
        calculePanelTypesLiens();
        calculePanelProprietes();

        add(Charte.getMessage("PanelSyno_TabT"), pNoeuds);
        add(Charte.getMessage("PanelSyno_TabTR"), pTypesLiens);
        add(Charte.getMessage("PanelSyno_TabP"), pProprietes);
        add(Charte.getMessage("PanelSyno_TabMV"), new PanelMotsVides(confrontation));
        for (int i = 0; i < getTabCount(); i++) {
            setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        setOpaque(false);

        pNoeuds.setDividerSize(5);
        pNoeuds.setDividerLocation(0.50);
        pTypesLiens.setDividerSize(5);
        pTypesLiens.setDividerLocation(0.50);
        pProprietes.setDividerSize(5);
        pProprietes.setDividerLocation(0.50);
    }

    private boolean helpPNoeuds = false;
    private void calculePanelNoeuds() {
        pNoeuds = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pNoeuds);
        pNoeuds.setContinuousLayout(true);

        JSplitPane pSynonymes2 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.50);

        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(JButton.LEFT);
        labTermes.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPNoeuds){
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    helpPNoeuds = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrT"));
                    helpPNoeuds = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());

        jspNTermes = new JScrollPane();
        Charte.formate(jspNTermes);
        Charte.formate(jspNTermes.getViewport());
        Charte.formate(jspNTermes.getHorizontalScrollBar());
        Charte.formate(jspNTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add(labTermes, BorderLayout.NORTH);
        pTermes.add(jspNTermes, BorderLayout.CENTER);
        pSynonymes2.setTopComponent(pTermes);

        bSuggN = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(bSuggN);
        bSuggN.setBackground(Color.WHITE);
        bSuggN.setBorder(Charte.getBorder());
        JButton bSuggRN = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRN);
        bSuggRN.setBackground(Color.WHITE);
        bSuggRN.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(JSlider.HORIZONTAL, 1, 100, 50);
        Charte.formate(sSeuil);
        Dictionary termesSeuil = new Hashtable(5);
        termesSeuil.put(new Integer(1), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_1"), JLabel.CENTER)));
        termesSeuil.put(new Integer(25), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_25"))));
        termesSeuil.put(new Integer(50), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_50"))));
        termesSeuil.put(new Integer(75), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_75"))));
        termesSeuil.put(new Integer(100), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_100"), JLabel.CENTER)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add(lSeuil, BorderLayout.WEST);
        pSeuil.add(sSeuil, BorderLayout.CENTER);
        nbN = new JSlider(JSlider.HORIZONTAL, 0, 4, 0);
        Charte.formate(nbN);
        Dictionary termesnbN = new Hashtable(5);
        termesnbN.put(new Integer(0), Charte.format(new JLabel(""+reponses[0], JLabel.CENTER)));
        termesnbN.put(new Integer(1), Charte.format(new JLabel(""+reponses[1])));
        termesnbN.put(new Integer(2), Charte.format(new JLabel(""+reponses[2])));
        termesnbN.put(new Integer(3), Charte.format(new JLabel(""+reponses[3])));
        termesnbN.put(new Integer(4), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Rep_Toutes"), JLabel.CENTER)));
        nbN.setLabelTable(termesnbN);
        nbN.setPaintLabels(true);
        nbN.setPaintTicks(true);
        nbN.setMajorTickSpacing(1);
        nbN.setMinorTickSpacing(1);
        nbN.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add(lNRep, BorderLayout.WEST);
        pNRep.add(nbN, BorderLayout.EAST);
        JPanel pGeneSugg = new JPanel(new BorderLayout(50,0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add(bSuggN, BorderLayout.WEST);
        JPanel pSlid = new JPanel(new BorderLayout(50,0));
        Charte.formate(pSlid);
        pSlid.add(pSeuil, BorderLayout.CENTER);
        pSlid.add(pNRep, BorderLayout.EAST);
        pGeneSugg.add(pSlid, BorderLayout.CENTER);
        pGeneSugg.add(bSuggRN, BorderLayout.EAST);
        Charte.formate(pGeneSugg);
        bSuggN.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteNoeuds(sSeuil.getValue());
            }
        });
        bSuggRN.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteRapideNoeuds(sSeuil.getValue());
            }
        });
        jspNSugg = new JScrollPane();
        Charte.formate(jspNSugg);
        Charte.formate(jspNSugg.getViewport());
        Charte.formate(jspNSugg.getHorizontalScrollBar());
        Charte.formate(jspNSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add(pGeneSugg, BorderLayout.NORTH);
        pSugg.add(jspNSugg, BorderLayout.CENTER);
        pSynonymes2.setBottomComponent(pSugg);
        pNoeuds.setTopComponent(pSynonymes2);

        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"),
                                    JLabel.CENTER);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add(labSyno, BorderLayout.CENTER);
        Charte.formate(pSyno);

        jspNSynos = new JScrollPane();
        Charte.formate(jspNSynos);
        Charte.formate(jspNSynos.getViewport());
        Charte.formate(jspNSynos.getHorizontalScrollBar());
        Charte.formate(jspNSynos.getVerticalScrollBar());

        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add(pSyno, BorderLayout.NORTH);
        pSynos.add(jspNSynos, BorderLayout.CENTER);
        pNoeuds.setBottomComponent(pSynos);

        refaisListesN();
    }

    private void confronteNoeuds(int pre){
        confrontation.setSeuilNoeuds(0.01 * pre);
        int choix = JOptionPane.showConfirmDialog(this,
                                                  Charte.getMessage("PanelSyno_WarnTime"),
                                                  Charte.getMessage("PanelSyno_WarnTimeT"),
                                                  JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, Charte.getSmiley(Charte.CLIN_D_OEIL));
        if(choix == JOptionPane.YES_OPTION){
            new Thread() {
                public void run() {
                    processusSuggestionSynosN();
                }
            }.start();
            bSuggN.setText(Charte.getMessage("PanelSyno_Sugg2"));
            bSuggN.setEnabled(false);
            //container.getIndicateurAttente().setVisible(true);
        }
    }

    private boolean helpPTypesLiens = false;
    private void calculePanelTypesLiens() {
        pTypesLiens = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pTypesLiens);
        pTypesLiens.setContinuousLayout(true);

        JSplitPane pSynonymes2 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.50);
        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(JButton.LEFT);
        labTermes.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPTypesLiens){
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    helpPTypesLiens = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrTR"));
                    helpPTypesLiens = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());

        jspTTermes = new JScrollPane();
        Charte.formate(jspTTermes);
        Charte.formate(jspTTermes.getViewport());
        Charte.formate(jspTTermes.getHorizontalScrollBar());
        Charte.formate(jspTTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add(labTermes, BorderLayout.NORTH);
        pTermes.add(jspTTermes, BorderLayout.CENTER);
        pSynonymes2.setTopComponent(pTermes);

        bSuggT = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(bSuggT);
        bSuggT.setBackground(Color.WHITE);
        bSuggT.setBorder(Charte.getBorder());
        JButton bSuggRT = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRT);
        bSuggRT.setBackground(Color.WHITE);
        bSuggRT.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(JSlider.HORIZONTAL, 1, 100, 50);
        Charte.formate(sSeuil);
        Dictionary termesSeuil = new Hashtable(5);
        termesSeuil.put(new Integer(1), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_1"), JLabel.CENTER)));
        termesSeuil.put(new Integer(25), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_25"))));
        termesSeuil.put(new Integer(50), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_50"))));
        termesSeuil.put(new Integer(75), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_75"))));
        termesSeuil.put(new Integer(100), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_100"), JLabel.CENTER)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add(lSeuil, BorderLayout.WEST);
        pSeuil.add(sSeuil, BorderLayout.CENTER);
        nbT = new JSlider(JSlider.HORIZONTAL, 0, 4, 0);
        Charte.formate(nbT);
        Dictionary termesnbT = new Hashtable(5);
        termesnbT.put(new Integer(0), Charte.format(new JLabel(""+reponses[0], JLabel.CENTER)));
        termesnbT.put(new Integer(1), Charte.format(new JLabel(""+reponses[1])));
        termesnbT.put(new Integer(2), Charte.format(new JLabel(""+reponses[2])));
        termesnbT.put(new Integer(3), Charte.format(new JLabel(""+reponses[3])));
        termesnbT.put(new Integer(4), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Rep_Toutes"), JLabel.CENTER)));
        nbT.setLabelTable(termesnbT);
        nbT.setPaintLabels(true);
        nbT.setPaintTicks(true);
        nbT.setMajorTickSpacing(1);
        nbT.setMinorTickSpacing(1);
        nbT.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add(lNRep, BorderLayout.WEST);
        pNRep.add(nbT, BorderLayout.EAST);
        JPanel pGeneSugg = new JPanel(new BorderLayout(50,0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add(bSuggT, BorderLayout.WEST);
        JPanel pSlid = new JPanel(new BorderLayout(50,0));
        Charte.formate(pSlid);
        pSlid.add(pSeuil, BorderLayout.CENTER);
        pSlid.add(pNRep, BorderLayout.EAST);
        pGeneSugg.add(pSlid, BorderLayout.CENTER);
        pGeneSugg.add(bSuggRT, BorderLayout.EAST);
        Charte.formate(pGeneSugg);
        bSuggT.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteTypesLiens(sSeuil.getValue());
            }
        });
        bSuggRT.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteRapideTypesLiens(sSeuil.getValue());
            }
        });
        jspTSugg = new JScrollPane();
        Charte.formate(jspTSugg);
        Charte.formate(jspTSugg.getViewport());
        Charte.formate(jspTSugg.getHorizontalScrollBar());
        Charte.formate(jspTSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add(pGeneSugg, BorderLayout.NORTH);
        pSugg.add(jspTSugg, BorderLayout.CENTER);
        pSynonymes2.setBottomComponent(pSugg);
        pTypesLiens.setTopComponent(pSynonymes2);

        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"),
                                    JLabel.CENTER);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add(labSyno, BorderLayout.CENTER);
        Charte.formate(pSyno);

        jspTSynos = new JScrollPane();
        Charte.formate(jspTSynos);
        Charte.formate(jspTSynos.getViewport());
        Charte.formate(jspTSynos.getHorizontalScrollBar());
        Charte.formate(jspTSynos.getVerticalScrollBar());

        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add(pSyno, BorderLayout.NORTH);
        pSynos.add(jspTSynos, BorderLayout.CENTER);
        pTypesLiens.setBottomComponent(pSynos);

        refaisListesT();
    }

    private void confronteTypesLiens(int pre){
        confrontation.setSeuilNoeuds(0.01 * pre);
        int choix = JOptionPane.showConfirmDialog(this,
                                                  Charte.getMessage("PanelSyno_WarnTime"),
                                                  Charte.getMessage("PanelSyno_WarnTimeT"),
                                                  JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, Charte.getSmiley(Charte.CLIN_D_OEIL));
        if(choix == JOptionPane.YES_OPTION){
            new Thread() {
                public void run() {
                    processusSuggestionSynosT();
                }
            }.start();
            bSuggT.setText(Charte.getMessage("PanelSyno_Sugg2"));
            bSuggT.setEnabled(false);
            //container.getIndicateurAttente().setVisible(true);
        }
    }

    private boolean helpPProprietes = false;
    private void calculePanelProprietes() {
        pProprietes = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pProprietes);
        pProprietes.setContinuousLayout(true);


        JSplitPane pSynonymes2 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.50);
        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(JButton.LEFT);
        labTermes.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPProprietes){
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    helpPProprietes = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrP"));
                    helpPProprietes = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());

        jspPTermes = new JScrollPane();
        Charte.formate(jspPTermes);
        Charte.formate(jspPTermes.getViewport());
        Charte.formate(jspPTermes.getHorizontalScrollBar());
        Charte.formate(jspPTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add(labTermes, BorderLayout.NORTH);
        pTermes.add(jspPTermes, BorderLayout.CENTER);
        pSynonymes2.setTopComponent(pTermes);

        bSuggP = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(bSuggP);
        bSuggP.setBackground(Color.WHITE);
        bSuggP.setBorder(Charte.getBorder());
        JButton bSuggRP = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRP);
        bSuggRP.setBackground(Color.WHITE);
        bSuggRP.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(JSlider.HORIZONTAL, 1, 100, 50);
        Charte.formate(sSeuil);
        Dictionary termesSeuil = new Hashtable(5);
        termesSeuil.put(new Integer(1), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_1"), JLabel.CENTER)));
        termesSeuil.put(new Integer(25), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_25"))));
        termesSeuil.put(new Integer(50), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_50"))));
        termesSeuil.put(new Integer(75), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_75"))));
        termesSeuil.put(new Integer(100), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Sug_100"), JLabel.CENTER)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add(lSeuil, BorderLayout.WEST);
        pSeuil.add(sSeuil, BorderLayout.CENTER);
        nbP = new JSlider(JSlider.HORIZONTAL, 0, 4, 0);
        Charte.formate(nbP);
        Dictionary termesnbP = new Hashtable(5);
        termesnbP.put(new Integer(0), Charte.format(new JLabel(""+reponses[0], JLabel.CENTER)));
        termesnbP.put(new Integer(1), Charte.format(new JLabel(""+reponses[1])));
        termesnbP.put(new Integer(2), Charte.format(new JLabel(""+reponses[2])));
        termesnbP.put(new Integer(3), Charte.format(new JLabel(""+reponses[3])));
        termesnbP.put(new Integer(4), Charte.format(new JLabel(
            Charte.getMessage("PanelSyno_Rep_Toutes"), JLabel.CENTER)));
        nbP.setLabelTable(termesnbP);
        nbP.setPaintLabels(true);
        nbP.setPaintTicks(true);
        nbP.setMajorTickSpacing(1);
        nbP.setMinorTickSpacing(1);
        nbP.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add(lNRep, BorderLayout.WEST);
        pNRep.add(nbP, BorderLayout.EAST);
        JPanel pGeneSugg = new JPanel(new BorderLayout(50,0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add(bSuggP, BorderLayout.WEST);
        JPanel pSlid = new JPanel(new BorderLayout(50,0));
        Charte.formate(pSlid);
        pSlid.add(pSeuil, BorderLayout.CENTER);
        pSlid.add(pNRep, BorderLayout.EAST);
        pGeneSugg.add(pSlid, BorderLayout.CENTER);
        pGeneSugg.add(bSuggRP, BorderLayout.EAST);
        Charte.formate(pGeneSugg);
        bSuggP.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteProprietes(sSeuil.getValue());
            }
        });
        bSuggRP.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                confronteRapideProprietes(sSeuil.getValue());
            }
        });
        jspPSugg = new JScrollPane();
        Charte.formate(jspPSugg);
        Charte.formate(jspPSugg.getViewport());
        Charte.formate(jspPSugg.getHorizontalScrollBar());
        Charte.formate(jspPSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add(pGeneSugg, BorderLayout.NORTH);
        pSugg.add(jspPSugg, BorderLayout.CENTER);
        pSynonymes2.setBottomComponent(pSugg);
        pProprietes.setTopComponent(pSynonymes2);

        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"),
                                    JLabel.CENTER);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add(labSyno, BorderLayout.CENTER);
        Charte.formate(pSyno);

        jspPSynos = new JScrollPane();
        Charte.formate(jspPSynos);
        Charte.formate(jspPSynos.getViewport());
        Charte.formate(jspPSynos.getHorizontalScrollBar());
        Charte.formate(jspPSynos.getVerticalScrollBar());

        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add(pSyno, BorderLayout.NORTH);
        pSynos.add(jspPSynos, BorderLayout.CENTER);
        pProprietes.setBottomComponent(pSynos);

        refaisListesP();
    }

    private void confronteProprietes(int pre){
        confrontation.setSeuilNoeuds(0.01 * pre);
        int choix = JOptionPane.showConfirmDialog(this,
                                                  Charte.getMessage("PanelSyno_WarnTime"),
                                                  Charte.getMessage("PanelSyno_WarnTimeT"),
                                                  JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, Charte.getSmiley(Charte.CLIN_D_OEIL));
        if(choix == JOptionPane.YES_OPTION){
            new Thread() {
                public void run() {
                    processusSuggestionSynosP();
                }
            }.start();
            bSuggP.setText(Charte.getMessage("PanelSyno_Sugg2"));
            bSuggP.setEnabled(false);
            //container.getIndicateurAttente().setVisible(true);
        }
    }


    private JList lNTermes = new JList();
    private JList lNSugg = new JList();
    private JList lNSynos = new JList();
    private JScrollPane jspNTermes;
    private JScrollPane jspNSugg;
    private JScrollPane jspNSynos;
    private DropTarget dtN;
    private DropTarget dtN2;

    private void refaisListesN() {
        int sel = lNTermes.getSelectedIndex();
        lNTermes = new JList(confrontation.getAllTermesNoeuds());
        Charte.formate(lNTermes);
        lNTermes.setDragEnabled(true);
        lNTermes.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspNTermes.setViewportView(lNTermes);
        lNTermes.ensureIndexIsVisible(sel);

        sel = lNSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[
                              Math.min(suggestionsN.length,
                                       reponses[nbN.getValue()])];
        for(int i=0; i<l0.length; i++){
            l0[i] = suggestionsN[i];
        }
        lNSugg = new JList(l0);
        Charte.formate(lNSugg);
        lNSugg.setDragEnabled(true);
        lNSugg.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                //JLabel res4 = new JLabel("{"+l.getLien()+"}");
                //Charte.formate(res4);
                //res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        jspNSugg.setViewportView(lNSugg);
        lNSugg.ensureIndexIsVisible(sel);

        sel = lNSynos.getSelectedIndex();
        lNSynos = new JList(confrontation.getListesSynonymesNoeuds());
        Charte.formate(lNSynos);
        lNSynos.setDragEnabled(true);
        lNSynos.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if(i<l.getListe().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        res.add(lab3);
                    }
                }
                JLabel res4 = new JLabel("{"+l.getLien()+"}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>"+l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        jspNSynos.setViewportView(lNSynos);
        lNSynos.ensureIndexIsVisible(sel);

        dtN = new DropTarget(lNSynos, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    /*System.out.println(((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))));
*/
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if((res.length > 1 || res[0].indexOf(";")>-1) && res[0].indexOf("{")==-1){
                        if(res[0].indexOf(";")>-1){
                            for(int i=0; i<res.length; i++){
                                System.out.println(res[i]);
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        res[i],
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesNoeuds(res[i],
                                            d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; i++) {
                                s += res[i];
                                if (i < res.length - 1) {
                                    s += ";";
                                }
                            }
                            DialogueAnnotation d = new DialogueAnnotation(
                                    parent,
                                    Charte.getMessage("PanelSyno_Justification") +
                                    s,
                                    confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                confrontation.addSynonymesNoeuds(s,
                                        d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                        }
                        refaisListesN();
                    } else if(res.length == 1 && res[0].indexOf(";")==-1){
                        JOptionPane.showMessageDialog(container,
                                Charte.getMessage("PanelSyno_WarnSingle"),
                                Charte.getMessage("PanelSyno_WarnSingleT"),
                                JOptionPane.ERROR_MESSAGE, Charte.getSmiley(Charte.MITIGE));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{")+1, res[0].indexOf("}"));
                        if(rais.startsWith("Sûr à")){
                            for (int i = 0; i < res.length; i++) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        synos,
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesNoeuds(synos,
                                            d.getChoix(), d.getCommentaires());
                                }
                            }
                            EventHandler.notifyEvent(EventHandler.
                                    NEW_SYNONYM_OR_HOMONYM, "");
                            refaisListesN();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtN2 = new DropTarget(lNTermes, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    for(int i=0; i<res.length; i++){
                        confrontation.removeSynonymesNoeuds(res[i].split("\\{")[0].
                                trim());
                    }
                    EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private JList lTTermes = new JList();
    private JList lTSugg = new JList();
    private JList lTSynos = new JList();
    private JScrollPane jspTTermes;
    private JScrollPane jspTSugg;
    private JScrollPane jspTSynos;
    private DropTarget dtT;
    private DropTarget dtT2;

    private void refaisListesT() {
        int sel = lTTermes.getSelectedIndex();
        lTTermes = new JList(confrontation.getAllTermesTypesLiens());
        Charte.formate(lTTermes);
        lTTermes.setDragEnabled(true);
        lTTermes.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspTTermes.setViewportView(lTTermes);
        lTTermes.ensureIndexIsVisible(sel);

        sel = lTSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[
                              Math.min(suggestionsT.length,
                                       reponses[nbT.getValue()])];
        for(int i=0; i<l0.length; i++){
            l0[i] = suggestionsT[i];
        }
        lTSugg = new JList(l0);
        Charte.formate(lTSugg);
        lTSugg.setDragEnabled(true);
        lTSugg.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                //JLabel res4 = new JLabel("{"+l.getLien()+"}");
                //Charte.formate(res4);
                ///res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        jspTSugg.setViewportView(lTSugg);
        lTSugg.ensureIndexIsVisible(sel);

        sel = lTSynos.getSelectedIndex();
        lTSynos = new JList(confrontation.getListesSynonymesTypesLiens());
        Charte.formate(lTSynos);
        lTSynos.setDragEnabled(true);
        lTSynos.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if(i<l.getListe().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        res.add(lab3);
                    }
                }
                JLabel res4 = new JLabel("{"+l.getLien()+"}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>"+l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        jspTSynos.setViewportView(lTSynos);
        lTSynos.ensureIndexIsVisible(sel);

        dtT = new DropTarget(lTSynos, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if((res.length > 1 || res[0].indexOf(";")>-1) && res[0].indexOf("{")==-1){
                        if(res[0].indexOf(";")>-1){
                            for(int i=0; i<res.length; i++){
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        res[i],
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesTypesLiens(res[i],
                                            d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; i++) {
                                s += res[i];
                                if (i < res.length - 1) {
                                    s += ";";
                                }
                            }
                            DialogueAnnotation d = new DialogueAnnotation(
                                    parent,
                                    Charte.getMessage("PanelSyno_Justification") +
                                    s,
                                    confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                confrontation.addSynonymesTypesLiens(s,
                                        d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                        }
                        refaisListesT();
                    } else if(res.length == 1 && res[0].indexOf(";")==-1){
                        JOptionPane.showMessageDialog(container,
                                Charte.getMessage("PanelSyno_WarnSingle"),
                                Charte.getMessage("PanelSyno_WarnSingleT"),
                                JOptionPane.ERROR_MESSAGE, Charte.getSmiley(Charte.MITIGE));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{")+1, res[0].indexOf("}"));
                        if(rais.startsWith("Sûr à")){
                            for (int i = 0; i < res.length; i++) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        synos,
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesTypesLiens(synos,
                                            d.getChoix(), d.getCommentaires());
                                }
                            }
                            EventHandler.notifyEvent(EventHandler.
                                    NEW_SYNONYM_OR_HOMONYM, "");
                            refaisListesT();
                        }

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtT2 = new DropTarget(lTTermes, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");

                    for(int i=0; i<res.length; i++){
                        confrontation.removeSynonymesTypesLiens(res[i].split("\\{")[0]);
                    }
                    EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private JList lPTermes = new JList();
    private JList lPSugg = new JList();
    private JList lPSynos = new JList();
    private JScrollPane jspPTermes;
    private JScrollPane jspPSugg;
    private JScrollPane jspPSynos;
    private DropTarget dtP;
    private DropTarget dtP2;

    private void refaisListesP() {
        int sel = lPTermes.getSelectedIndex();
        lPTermes = new JList(confrontation.getAllTermesProprietes());
        Charte.formate(lPTermes);
        lPTermes.setDragEnabled(true);
        lPTermes.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspPTermes.setViewportView(lPTermes);
        lPTermes.ensureIndexIsVisible(sel);

        sel = lPSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[
                              Math.min(suggestionsP.length,
                                       reponses[nbP.getValue()])];
        for(int i=0; i<l0.length; i++){
            l0[i] = suggestionsP[i];
        }
        lPSugg = new JList(l0);
        Charte.formate(lPSugg);
        lPSugg.setDragEnabled(true);
        lPSugg.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                //JLabel res4 = new JLabel("{"+l.getLien()+"}");
                //Charte.formate(res4);
                //res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        jspPSugg.setViewportView(lPSugg);
        lPSugg.ensureIndexIsVisible(sel);

        sel = lPSynos.getSelectedIndex();
        lPSynos = new JList(confrontation.getListesSynonymesProprietes());
        Charte.formate(lPSynos);
        lPSynos.setDragEnabled(true);
        lPSynos.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(FlowLayout.LEFT));
                ListeSynonymes l = (ListeSynonymes)value;
                for(int i=0; i<l.getListe().length; i++){
                    JLabel lab = legende.getClasseur(
                            l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if(i<l.getListe().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        res.add(lab3);
                    }
                }
                JLabel res4 = new JLabel("{"+l.getLien()+"}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>"+l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        jspPSynos.setViewportView(lPSynos);
        lPSynos.ensureIndexIsVisible(sel);


        dtP = new DropTarget(lPSynos, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if((res.length > 1 || res[0].indexOf(";")>-1) && res[0].indexOf("{")==-1){
                        if(res[0].indexOf(";")>-1){
                            for(int i=0; i<res.length; i++){
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        res[i],
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesProprietes(res[i],
                                            d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; i++) {
                                s += res[i];
                                if (i < res.length - 1) {
                                    s += ";";
                                }
                            }
                            DialogueAnnotation d = new DialogueAnnotation(
                                    parent,
                                    Charte.getMessage("PanelSyno_Justification") +
                                    s,
                                    confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                confrontation.addSynonymesProprietes(s,
                                        d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                        }
                        refaisListesP();
                    } else if (res.length == 1 && res[0].indexOf(";") == -1) {
                        JOptionPane.showMessageDialog(container,
                                Charte.getMessage("PanelSyno_WarnSingle"),
                                Charte.getMessage("PanelSyno_WarnSingleT"),
                                JOptionPane.ERROR_MESSAGE, Charte.getSmiley(Charte.MITIGE));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{")+1, res[0].indexOf("}"));
                        if(rais.startsWith("Sûr à")){
                            for (int i = 0; i < res.length; i++) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        Charte.getMessage("PanelSyno_Justification") +
                                        synos,
                                        confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    confrontation.addSynonymesProprietes(synos,
                                            d.getChoix(), d.getCommentaires());
                                }
                            }
                            EventHandler.notifyEvent(EventHandler.
                                    NEW_SYNONYM_OR_HOMONYM, "");
                            refaisListesP();
                        }

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtP2 = new DropTarget(lPTermes, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");

                    for(int i=0; i<res.length; i++){
                        confrontation.removeSynonymesProprietes(res[i].split("\\{")[0]);
                    }
                    EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void processusSuggestionSynosN(){
        suggestionsN = confrontation.suggereNoeudsSynonymes();
        refaisListesN();
        bSuggN.setEnabled(true);
        bSuggN.setText(Charte.getMessage("PanelSyno_Sugg"));
        //container.getIndicateurAttente().setVisible(false);
    }

    private void confronteRapideNoeuds(int pre){
        confrontation.setSeuilNoeuds(0.01 * pre);
        suggestionsN = confrontation.suggereNoeudsSynonymes(DELAI_RECH_RAPIDE);
        refaisListesN();
    }

    private void processusSuggestionSynosT(){
        suggestionsT = confrontation.suggereTypesLiensSynonymes();
        refaisListesT();
        bSuggT.setEnabled(true);
        bSuggT.setText(Charte.getMessage("PanelSyno_Sugg"));
        //container.getIndicateurAttente().setVisible(false);
    }

    private void confronteRapideTypesLiens(int pre){
        confrontation.setSeuilTypesLiens(0.01 * pre);
        suggestionsT = confrontation.suggereTypesLiensSynonymes(DELAI_RECH_RAPIDE);
        refaisListesT();
    }

    private void processusSuggestionSynosP(){
        suggestionsP = confrontation.suggereProprietesSynonymes();
        refaisListesP();
        bSuggP.setEnabled(true);
        bSuggP.setText(Charte.getMessage("PanelSyno_Sugg"));
        //container.getIndicateurAttente().setVisible(false);
    }

    private void confronteRapideProprietes(int pre){
        confrontation.setSeuilProprietes(0.01 * pre);
        suggestionsP = confrontation.suggereProprietesSynonymes(DELAI_RECH_RAPIDE);
        refaisListesP();
    }

    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode == EventHandler.NEW_SYNONYM_OR_HOMONYM) {
            refaisListesN();
            refaisListesT();
            refaisListesP();
        }
    }

}
