/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm;

import ihm.townto.EventHandler;
import ihm.townto.EventListener;

import data.Confrontation;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;

import java.io.File;
import java.io.FileFilter;

/**
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class PanelNotes extends JTabbedPane implements EventListener {
    private Confrontation confrontation;
    private FenetrePrincipale fenetre;

    private JPanel pCaptures;

    public PanelNotes(Confrontation confrontation, FenetrePrincipale fenetre){
        Charte.formate(this);
        this.confrontation = confrontation;
        this.fenetre = fenetre;

        EventHandler.register(this);

        pCaptures = new ListeImages();
        Charte.formate(pCaptures);
        pCaptures.setLayout(new BoxLayout(pCaptures, BoxLayout.Y_AXIS));
        JScrollPane spCaptures = new JScrollPane(pCaptures);
        Charte.formate(spCaptures);
        Charte.formate(spCaptures.getViewport());
        Charte.formate(spCaptures.getHorizontalScrollBar());
        Charte.formate(spCaptures.getVerticalScrollBar());
        calculePCaptures();
        add(Charte.getMessage("PanelNotes_TabC"), spCaptures);

    }

    private void calculePCaptures() {
        pCaptures.removeAll();
        FileFilter filtre = new FileFilter() {
            public boolean accept(File f) {
                return (f.getName().endsWith("png"));
            }
        };
        File f0 = fenetre.getDossier();
        if (f0 != null) {
            if (f0.exists() && f0.isDirectory()) {
                File[] f = f0.listFiles(filtre);
                ImageIcon[] img = new ImageIcon[f.length];
                for (int i = 0; i < img.length; i++) {
                    img[i] = new ImageIcon(f[i].getPath());
                    JLabel l = new JLabel(img[i]);
                    l.setHorizontalAlignment(JLabel.CENTER);
                    Charte.formate(l);
                    l.setBorder(Charte.getBorder());
                    l.setToolTipText(f[i].getName());
                    /*if(i%2==0){
                        l.setBackground(new Color(0, 0, 0, 64));
                    }*/
                    JPanel pp = new JPanel(new GridLayout(1,1));
                    Charte.formate(pp);
                    pp.add(l);
                    pCaptures.add(pp);
                }
            }
        }
    }

    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode == EventHandler.NEW_CAPTURE) {
            calculePCaptures();
        }
    }

    private class ListeImages extends JPanel implements Scrollable {
        public Dimension getPreferredScrollableViewportSize(){
            return getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect,
                                              int orientation,
                                              int direction) {
            return 20;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect,
                                              int orientation,
                                              int direction) {
            return 100;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

    }

}
