/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm;

import data.Confrontation;
import data.TexteCommun;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Même remarque que pour PanelVisualisation.
 * <br>
 * On a maintenant une classe toute propre (quoique mais bon...) pour s'occuper
 * des mots vides.
 * <br>
 * Au programme : lister les mots contenus dans les noeuds, en indiquant les
 * points de vue auxquels ces mots appartiennent (le marquage se fait par
 * couleur).
 * <br>
 * Ici, seuls les noeuds sont pris en compte. En effet, seuls les noeuds sont
 * habituellement en assez grand nombre pour qu'il soit nécessaire d'assister
 * la recherche de synonymes à ce point.
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class PanelMotsVides extends JPanel {
    private JButton bChangeTri;
    private boolean alpha = false;

    private JList lVide;
    private JList lVides;
    private JScrollPane jspVide0;
    private JScrollPane jspVides;
    private DropTarget dt;
    private DropTarget dt2;
    private Legende legende;

    private boolean help = false;
    public PanelMotsVides(final Confrontation confrontation) {
        super(new GridLayout(2, 1));
        Charte.formate(this);

        legende = new Legende(confrontation.getAllNomsGraphes());

        final JButton labVides = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labVides);
        labVides.setHorizontalAlignment(JButton.LEFT);
        labVides.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(help){
                    labVides.setText(Charte.getMessage("Panel_InstrB"));
                    help = false;
                } else {
                    labVides.setText(Charte.getMessage("PanelMV_Instr"));
                    help = true;
                }
            }
        });
        labVides.setBorder(Charte.getBorder());

        jspVides = new JScrollPane();
        Charte.formate(jspVides);
        Charte.formate(jspVides.getViewport());
        Charte.formate(jspVides.getHorizontalScrollBar());
        Charte.formate(jspVides.getVerticalScrollBar());
        JPanel pVide = new JPanel(new BorderLayout());
        Charte.formate(pVide);
        pVide.setBorder(Charte.getBorder());
        pVide.add(labVides, BorderLayout.NORTH);
        pVide.add(jspVides, BorderLayout.CENTER);
        add(pVide);

        JLabel labVide = new JLabel(Charte.getMessage("PanelMV_TxtList"), JLabel.CENTER);
        Charte.formate(labVide);
        labVide.setBorder(Charte.getBorder());
        bChangeTri = new JButton(Charte.getMessage("PanelMV_TriNbL"));
        Charte.formate(bChangeTri);
        bChangeTri.setBorder(Charte.getBorder());
        JPanel pVide1 = new JPanel(new BorderLayout());
        pVide1.add(labVide, BorderLayout.CENTER);
        pVide1.add(bChangeTri, BorderLayout.EAST);
        Charte.formate(pVide1);

        jspVide0 = new JScrollPane();
        Charte.formate(jspVide0);
        Charte.formate(jspVide0.getViewport());
        Charte.formate(jspVide0.getHorizontalScrollBar());
        Charte.formate(jspVide0.getVerticalScrollBar());
        JPanel pVide0 = new JPanel(new BorderLayout());
        Charte.formate(pVide0);
        bChangeTri.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                alpha = !alpha;
                bChangeTri.setText(alpha ? Charte.getMessage("PanelMV_TriAlpha") :
                                   Charte.getMessage("PanelMV_TriNbL"));
                refaisListes(confrontation);
            }
        });
        pVide0.setBorder(Charte.getBorder());
        pVide0.add(pVide1, BorderLayout.NORTH);
        pVide0.add(jspVide0, BorderLayout.CENTER);
        add(pVide0);
        refaisListes(confrontation);
    }

    private void refaisListes(final Confrontation confrontation){
        lVide = new JList(confrontation.getListeMotsVides(
            alpha ? confrontation.getComparateurAlphabetique() :
            confrontation.getComparateurParNbLettres()));
        Charte.formate(lVide);
        lVide.setDragEnabled(true);
        lVide.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 32));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 32));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspVide0.setViewportView(lVide);
        lVides = new JList(confrontation.getListeMotsNonVides(
            alpha ? confrontation.getComparateurAlphabetique() :
            confrontation.getComparateurParNbLettres()));
        Charte.formate(lVides);
        lVides.setDragEnabled(true);
        lVides.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value,
                    int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 32));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 32));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspVides.setViewportView(lVides);
        dt = new DropTarget(lVide, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; i++) {
                            confrontation.addMotVide(res[i]);
                        }
                        refaisListes(confrontation);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dt2 = new DropTarget(lVides, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; i++) {
                            confrontation.removeMotVide(res[i]);
                        }
                        refaisListes(confrontation);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }
}
