/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm;

import data.Confrontation;
import data.TexteCommun;
import data.ListeSynonymes;
import data.MotHomonyme;

import ihm.townto.EventHandler;

import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.JOptionPane;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Color;
import java.awt.Component;

import java.awt.datatransfer.DataFlavor;

import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTarget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


/**
 * Même remarque que pour PanelVisualisation.
 * <br>
 * C'est au tour des homonymes de recevoir leur classe à eux.
 * <br>
 * Le rôle de cette partie de l'interface est de permettre la désambiguation. En
 * effet, on peut avoir des termes identiques dans deux graphes qui ont des sens
 * complètement différents (par exemple, un noeud "divers" regroupant ce qui
 * n'est pas ailleurs ne devra pas être mis en relation avec son homologue du
 * graphe voisin).
 * <br>
 *
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class PanelHomonymes extends JTabbedPane {
    private Legende legende;
    private Confrontation confrontation;

    private PanelHomonymes parent;

    private JSplitPane pNoeuds;
    private JSplitPane pTypesLiens;
    private JSplitPane pProprietes;

    public PanelHomonymes(Confrontation confrontation) {
        super(JTabbedPane.TOP, JTabbedPane.WRAP_TAB_LAYOUT);
        Charte.formate(this);
        parent = this;
        this.confrontation = confrontation;

        legende = new Legende(confrontation.getAllNomsGraphes());

        calculePNoeuds();
        calculePTypesLiens();
        calculePProprietes();

        add(Charte.getMessage("PanelHomo_TabT"), pNoeuds);
        add(Charte.getMessage("PanelHomo_TabTR"), pTypesLiens);
        add(Charte.getMessage("PanelHomo_TabP"), pProprietes);
        for (int i = 0; i < getTabCount(); i++) {
            setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        setOpaque(false);

        pNoeuds.setDividerSize(5);
        pNoeuds.setDividerLocation(0.50);
        pTypesLiens.setDividerSize(5);
        pTypesLiens.setDividerLocation(0.50);
        pProprietes.setDividerSize(5);
        pProprietes.setDividerLocation(0.50);
    }

    private boolean helpPNoeuds = false;
    private void calculePNoeuds() {
        pNoeuds = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pNoeuds);
        pNoeuds.setContinuousLayout(true);
        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(JButton.LEFT);
        labTermes2.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPNoeuds){
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    helpPNoeuds = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrT"));
                    helpPNoeuds = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());

        jspNTermes2 = new JScrollPane();
        Charte.formate(jspNTermes2);
        Charte.formate(jspNTermes2.getViewport());
        Charte.formate(jspNTermes2.getHorizontalScrollBar());
        Charte.formate(jspNTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add(labTermes2, BorderLayout.NORTH);
        pTermes2.add(jspNTermes2, BorderLayout.CENTER);
        pNoeuds.setTopComponent(pTermes2);

        JLabel labPoly = new JLabel(
                Charte.getMessage("PanelHomo_TxtList"),
                JLabel.CENTER);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add(labPoly, BorderLayout.CENTER);
        Charte.formate(pPoly);

        jspNPolys = new JScrollPane();
        Charte.formate(jspNPolys);
        Charte.formate(jspNPolys.getViewport());
        Charte.formate(jspNPolys.getHorizontalScrollBar());
        Charte.formate(jspNPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add(pPoly, BorderLayout.NORTH);
        pPolys.add(jspNPolys, BorderLayout.CENTER);
        pNoeuds.setBottomComponent(pPolys);

        refaisListesN();
    }

    private boolean helpPTypesLiens = false;
    private void calculePTypesLiens() {
        pTypesLiens = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pTypesLiens);
        pTypesLiens.setContinuousLayout(true);

        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(JButton.LEFT);
        labTermes2.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPTypesLiens){
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    helpPTypesLiens = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrTR"));
                    helpPTypesLiens = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());
        jspTTermes2 = new JScrollPane();
        Charte.formate(jspTTermes2);
        Charte.formate(jspTTermes2.getViewport());
        Charte.formate(jspTTermes2.getHorizontalScrollBar());
        Charte.formate(jspTTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add(labTermes2, BorderLayout.NORTH);
        pTermes2.add(jspTTermes2, BorderLayout.CENTER);
        pTypesLiens.setTopComponent(pTermes2);

        JLabel labPoly = new JLabel(
                Charte.getMessage("PanelHomo_TxtList"),
                JLabel.CENTER);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add(labPoly, BorderLayout.CENTER);
        Charte.formate(pPoly);

        jspTPolys = new JScrollPane();
        Charte.formate(jspTPolys);
        Charte.formate(jspTPolys.getViewport());
        Charte.formate(jspTPolys.getHorizontalScrollBar());
        Charte.formate(jspTPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add(pPoly, BorderLayout.NORTH);
        pPolys.add(jspTPolys, BorderLayout.CENTER);
        pTypesLiens.setBottomComponent(pPolys);

        refaisListesT();
    }

    private boolean helpPProprietes = false;
    private void calculePProprietes() {
        pProprietes = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        Charte.formate(pProprietes);
        pProprietes.setContinuousLayout(true);

        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"),
                                               Charte.getSmiley(Charte.ETUDE));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(JButton.LEFT);
        labTermes2.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                if(helpPProprietes){
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    helpPProprietes = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrP"));
                    helpPProprietes = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());
        jspPTermes2 = new JScrollPane();
        Charte.formate(jspPTermes2);
        Charte.formate(jspPTermes2.getViewport());
        Charte.formate(jspPTermes2.getHorizontalScrollBar());
        Charte.formate(jspPTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add(labTermes2, BorderLayout.NORTH);
        pTermes2.add(jspPTermes2, BorderLayout.CENTER);
        pProprietes.setTopComponent(pTermes2);

        JLabel labPoly = new JLabel(
                Charte.getMessage("PanelHomo_TxtList"),
                JLabel.CENTER);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add(labPoly, BorderLayout.CENTER);
        Charte.formate(pPoly);

        jspPPolys = new JScrollPane();
        Charte.formate(jspPPolys);
        Charte.formate(jspPPolys.getViewport());
        Charte.formate(jspPPolys.getHorizontalScrollBar());
        Charte.formate(jspPPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add(pPoly, BorderLayout.NORTH);
        pPolys.add(jspPPolys, BorderLayout.CENTER);
        pProprietes.setBottomComponent(pPolys);

        refaisListesP();
    }


    private JList lNPolys;
    private JList lNTermes2;
    private JScrollPane jspNPolys;
    private JScrollPane jspNTermes2;
    private DropTarget dtN;
    private DropTarget dtN2;

    private void refaisListesN() {
        lNPolys = new JList(confrontation.getListeMotsPolysemiques(
                confrontation.getComparateurHomonymes()));
        Charte.formate(lNPolys);
        lNPolys.setDragEnabled(true);
        lNPolys.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(FlowLayout.LEFT));
                Charte.formate(r);
                for(int i=0; i<m.getMots().length; i++){
                    JLabel res = legende.getClasseur(m.getMots()[i].
                            getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if(i<m.getMots().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        r.add(lab3);
                    }
                }
                JLabel l = new JLabel("{"+m.getLien()+"}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>"+m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        lNTermes2 = new JList(confrontation.getListeMotsNonPolysemiques(
                confrontation.getComparateurAlphabetique()));
        Charte.formate(lNTermes2);
        lNTermes2.setDragEnabled(true);
        lNTermes2.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspNPolys.setViewportView(lNPolys);
        jspNTermes2.setViewportView(lNTermes2);
        dtN = new DropTarget(lNPolys, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; i++) {
                            ListeSynonymes[] l =
                                    confrontation.getListesSynonymesNoeuds(
                                            confrontation.trouveTermeNoeud(res[
                                    i]));
                            boolean faire = false;
                            MotHomonyme h = confrontation.
                                            trouveMotPolysemique(
                                    res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(parent,
                                        Charte.getMessage("PanelHomo_DejaFait"),
                                        Charte.getMessage("PanelHomo_DejaFaitT"),
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.MITIGE));
                            } else {
                                faire = true;
                            }
                            if (faire) {
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        confrontation.trouveTermeNoeud(res[i]),
                                        Charte.getMessage("PanelHomo_Justification") +
                                        " \"" +
                                        res[i] + "\" : ",
                                        confrontation.getRaisonsEloigner());
                                d.setVisible(true);
                                if (!d.isAnnule() && d.getRepartition().length > 1) {
                                    TexteCommun t = confrontation.
                                                    trouveTermeNoeud(res[i]);
                                    confrontation.addMotPolysemique(d.
                                        getRepartition(),
                                        d.getChoix(), d.getCommentaires());
                                    if (l.length > 0) {
                                        for (int j = 0; j < l.length; j++) {
                                            MotHomonyme mh = confrontation.trouveMotPolysemique(d.getRepartition()[0].getTexte());
                                            DialogueAnnotation d2 = new
                                                    DialogueAnnotation(
                                                    parent, l[j],
                                                    mh.getMots(),
                                                    Charte.getMessage("PanelHomo_Repercut") +
                                                    " ");
                                            d2.setVisible(true);
                                            l[j].replace(t, d2.getTexteCommunChoisi());
                                        }
                                    }
                                }
                            }
                        }
                        EventHandler.notifyEvent(EventHandler.
                                                 NEW_SYNONYM_OR_HOMONYM, "");
                        refaisListesN();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtN2 = new DropTarget(lNTermes2, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if(res.length>0){
                        for(int i=0; i<res.length; i++){
                            int l = confrontation.getListesSynonymesNoeuds(
                                    confrontation.trouveMotPolysemique(res[i].
                                    split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(
                                        parent,
                                        Charte.getMessage("PanelHomo_Retouche"),
                                        Charte.getMessage("PanelHomo_RetoucheT"),
                                        JOptionPane.YES_NO_OPTION,
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.CLIN_D_OEIL));
                                if (choix == JOptionPane.YES_OPTION) {
                                    faire = true;
                                } else {
                                    JOptionPane.showConfirmDialog(parent,
                                            Charte.getMessage("PanelHomo_Annuler"),
                                            Charte.getMessage("PanelHomo_AnnulerT"),
                                            JOptionPane.DEFAULT_OPTION,
                                            JOptionPane.INFORMATION_MESSAGE,
                                            Charte.getSmiley(Charte.MITIGE));
                                    faire = false;
                                }
                            } else if(l == 0 && !demande) {
                                faire = true;
                            }
                        }
                        for(int i=0; i<res.length; i++){
                            if (faire) {
                                String mot = res[i].split("\\-")[0].trim();
                                confrontation.removeMotPolysemique(mot);
                            }
                        }
                        EventHandler.notifyEvent(EventHandler.
                                                 NEW_SYNONYM_OR_HOMONYM, "");
                        refaisListesN();
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private JList lTPolys;
    private JList lTTermes2;
    private JScrollPane jspTPolys;
    private JScrollPane jspTTermes2;
    private DropTarget dtT;
    private DropTarget dtT2;

    private void refaisListesT() {
        lTPolys = new JList(confrontation.getListeTypesLiensPolysemiques(
                confrontation.getComparateurHomonymes()));
        Charte.formate(lTPolys);
        lTPolys.setDragEnabled(true);
        lTPolys.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(FlowLayout.LEFT));
                Charte.formate(r);
                for(int i=0; i<m.getMots().length; i++){
                    JLabel res = legende.getClasseur(m.getMots()[i].
                            getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if(i<m.getMots().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        r.add(lab3);
                    }
                }
                JLabel l = new JLabel("{"+m.getLien()+"}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>"+m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        lTTermes2 = new JList(confrontation.getListeTypesLiensNonPolysemiques(
                confrontation.getComparateurAlphabetique()));
        Charte.formate(lTTermes2);
        lTTermes2.setDragEnabled(true);
        lTTermes2.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspTPolys.setViewportView(lTPolys);
        jspTTermes2.setViewportView(lTTermes2);
        dtT = new DropTarget(lTPolys, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; i++) {
                            ListeSynonymes[] l =
                                    confrontation.getListesSynonymesTypesLiens(
                                            confrontation.trouveTermeTypeLien(res[
                                    i]));
                            boolean faire = false;
                            MotHomonyme h = confrontation.
                                            trouveTypeLienPolysemique(
                                    res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(parent,
                                        Charte.getMessage("PanelHomo_DejaFait"),
                                        Charte.getMessage("PanelHomo_DejaFaitT"),
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.MITIGE));
                            } else {
                                faire = true;
                            }
                            if (faire) {
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        confrontation.trouveTermeTypeLien(res[i]),
                                        Charte.getMessage("PanelHomo_Justification") +
                                        " \"" + res[i] + "\" : ",
                                        confrontation.getRaisonsEloigner());
                                d.setVisible(true);
                                if (!d.isAnnule() && d.getRepartition().length > 1) {
                                    TexteCommun t = confrontation.
                                                    trouveTermeTypeLien(res[i]);
                                    confrontation.addTypeLienPolysemique(d.
                                        getRepartition(),
                                        d.getChoix(), d.getCommentaires());
                                    if (l.length > 0) {
                                        for (int j = 0; j < l.length; j++) {
                                            MotHomonyme mh = confrontation.trouveTypeLienPolysemique(d.getRepartition()[0].getTexte());
                                            DialogueAnnotation d2 = new
                                                    DialogueAnnotation(
                                                    parent, l[j],
                                                    mh.getMots(),
                                                    Charte.getMessage("PanelHomo_Repercut") +
                                                    " ");
                                            d2.setVisible(true);
                                            l[j].replace(t, d2.getTexteCommunChoisi());
                                        }
                                    }
                                }
                            }
                        }
                        EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                        refaisListesT();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtT2 = new DropTarget(lTTermes2, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if(res.length>0){
                        for(int i=0; i<res.length; i++){
                            int l = confrontation.getListesSynonymesTypesLiens(
                                    confrontation.trouveTypeLienPolysemique(res[i].
                                    split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(
                                        parent,
                                        Charte.getMessage("PanelHomo_Retouche"),
                                        Charte.getMessage("PanelHomo_RetoucheT"),
                                        JOptionPane.YES_NO_OPTION,
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.CLIN_D_OEIL));
                                if (choix == JOptionPane.YES_OPTION) {
                                    faire = true;
                                } else {
                                    JOptionPane.showConfirmDialog(parent,
                                            Charte.getMessage("PanelHomo_Annuler"),
                                            Charte.getMessage("PanelHomo_AnnulerT"),
                                            JOptionPane.DEFAULT_OPTION,
                                            JOptionPane.INFORMATION_MESSAGE,
                                            Charte.getSmiley(Charte.MITIGE));
                                    faire = false;
                                }
                            } else if(l == 0 && !demande) {
                                faire = true;
                            }
                        }
                        for(int i=0; i<res.length; i++){
                            if (faire) {
                                String mot = res[i].split("\\-")[0].trim();
                                confrontation.removeTypeLienPolysemique(mot);
                                EventHandler.notifyEvent(EventHandler.
                                        NEW_SYNONYM_OR_HOMONYM, "");
                                refaisListesT();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private JList lPPolys;
    private JList lPTermes2;
    private JScrollPane jspPPolys;
    private JScrollPane jspPTermes2;
    private DropTarget dtP;
    private DropTarget dtP2;

    private void refaisListesP(){
        lPPolys = new JList(confrontation.getListeProprietesPolysemiques(
            confrontation.getComparateurHomonymes()));
        Charte.formate(lPPolys);
        lPPolys.setDragEnabled(true);
        lPPolys.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(FlowLayout.LEFT));
                Charte.formate(r);
                for(int i=0; i<m.getMots().length; i++){
                    JLabel res = legende.getClasseur(m.getMots()[i].
                            getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if(i<m.getMots().length-1){
                        JLabel lab3 = new JLabel(";");
                        Charte.formate(lab3);
                        r.add(lab3);
                    }
                }
                JLabel l = new JLabel("{"+m.getLien()+"}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>"+m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        lPTermes2 = new JList(confrontation.getListeProprietesNonPolysemiques(
            confrontation.getComparateurAlphabetique()));
        Charte.formate(lPTermes2);
        lPTermes2.setDragEnabled(true);
        lPTermes2.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                    Object value, int index, boolean isSelected,
                    boolean cellHasFocus) {
                JLabel res = legende.getClasseur(((TexteCommun) value).
                                                 getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun) value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add(res, BorderLayout.WEST);
                p.add(res2, BorderLayout.CENTER);
                p.setOpaque(false);
                return p;
            }
        });
        jspPPolys.setViewportView(lPPolys);
        jspPTermes2.setViewportView(lPTermes2);
        dtP = new DropTarget(lPPolys, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; i++) {
                            ListeSynonymes[] l =
                                    confrontation.getListesSynonymesProprietes(
                                            confrontation.trouveTermePropriete(res[
                                    i]));
                            boolean faire = false;
                            MotHomonyme h = confrontation.
                                            trouveProprietePolysemique(
                                    res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(parent,
                                        Charte.getMessage("PanelHomo_DejaFait"),
                                        Charte.getMessage("PanelHomo_DejaFaitT"),
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.MITIGE));
                            } else {
                                faire = true;
                            }
                            if (faire) {
                                DialogueAnnotation d = new DialogueAnnotation(
                                        parent,
                                        confrontation.trouveTermePropriete(res[i]),
                                        Charte.getMessage("PanelHomo_Justification") +
                                        " \"" + res[i] + "\" : ",
                                        confrontation.getRaisonsEloigner());
                                d.setVisible(true);
                                if (!d.isAnnule() && d.getRepartition().length > 1) {
                                    TexteCommun t = confrontation.
                                                    trouveTermePropriete(res[i]);
                                    confrontation.addProprietePolysemique(d.
                                        getRepartition(),
                                        d.getChoix(), d.getCommentaires());
                                    if (l.length > 0) {
                                        for (int j = 0; j < l.length; j++) {
                                            MotHomonyme mh = confrontation.trouveProprietePolysemique(d.getRepartition()[0].getTexte());
                                            DialogueAnnotation d2 = new
                                                    DialogueAnnotation(
                                                    parent, l[j],
                                                    mh.getMots(),
                                                    Charte.getMessage("PanelHomo_Repercut") +
                                                    " ");
                                            d2.setVisible(true);
                                            l[j].replace(t, d2.getTexteCommunChoisi());
                                        }
                                    }
                                }
                            }
                        }
                        EventHandler.notifyEvent(EventHandler.NEW_SYNONYM_OR_HOMONYM, "");
                        refaisListesP();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dtP2 = new DropTarget(lPTermes2, new DropTargetAdapter() {
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String) (
                            dtde.getTransferable().getTransferData(
                                    new DataFlavor(
                                            String.class, null)))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if(res.length>0){
                        for(int i=0; i<res.length; i++){
                            int l = confrontation.getListesSynonymesProprietes(
                                    confrontation.trouveProprietePolysemique(res[i].
                                    split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(
                                        parent,
                                        Charte.getMessage("PanelHomo_Retouche"),
                                        Charte.getMessage("PanelHomo_RetoucheT"),
                                        JOptionPane.YES_NO_OPTION,
                                        JOptionPane.INFORMATION_MESSAGE,
                                        Charte.getSmiley(Charte.CLIN_D_OEIL));
                                if (choix == JOptionPane.YES_OPTION) {
                                    faire = true;
                                } else {
                                    JOptionPane.showConfirmDialog(parent,
                                            Charte.getMessage("PanelHomo_Annuler"),
                                            Charte.getMessage("PanelHomo_AnnulerT"),
                                            JOptionPane.DEFAULT_OPTION,
                                            JOptionPane.INFORMATION_MESSAGE,
                                            Charte.getSmiley(Charte.MITIGE));
                                    faire = false;
                                }
                            } else if(l == 0 && !demande) {
                                faire = true;
                            }
                        }
                        for(int i=0; i<res.length; i++){
                            if (faire) {
                                String mot = res[i].split("\\-")[0].trim();
                                confrontation.removeProprietePolysemique(mot);
                                EventHandler.notifyEvent(EventHandler.
                                        NEW_SYNONYM_OR_HOMONYM, "");
                                refaisListesP();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }
}
