/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.HashMap;
import java.util.Map;

/**
 * Ceci est la fenêtre d'initialisation de l'application.
 *
 * @author Samuel GESCHE
 * @version 3.5.1
 * @since 3.5.1
 */
public class FenetreInit extends JFrame {

    private int choisi;
    private JDialog dialogue;

    private int w = Toolkit.getDefaultToolkit().getScreenSize().width;
    private int h = Toolkit.getDefaultToolkit().getScreenSize().height;


    /**
     * Crée la fenêtre d'initialisation de l'application.
     * @since 3.5.1
     */
    public FenetreInit() {
        JLabel lFond = new JLabel();
        setSize(w, h - 1);
        setTitle("ArcEnCiel v"+Charte.getVersion()+" ");
        setUndecorated(true);
        getContentPane().setLayout(null);
        lFond = new JLabel(Charte.getImage());
        lFond.setBackground(Color.WHITE);
        lFond.setSize(w, h - 1);
        getContentPane().add(lFond);
        setIconImage(new ImageIcon("").getImage());
    }

    /**
     * Lance le dialogue Homme-Machine initial.
     * @since 3.5.1
     */
    public void run(){
        setVisible(true);
        Map choix = Charte.getMessagesIncomprehension();
        Map inv = new HashMap();
        String[] cles = new String[choix.keySet().size()];
        choix.keySet().toArray(cles);
        for(int i=0; i<cles.length; i++){
            inv.put(choix.get(cles[i]), cles[i]);
        }
        String[] options0 = new String[choix.values().size()];
        choix.values().toArray(options0);
        String[] options = new String[options0.length];
        int offset = 1;
        for(int i=0; i<options0.length; i++){
            if(inv.get(options0[i]).toString().equals(Charte.getLangue())){
                options[0] = options0[i];
                offset = 0;
            } else {
                options[i+offset] = options0[i];
            }
        }
        choisi = 0;
        dialogue = new JDialog(this, true);
        dialogue.getContentPane().setLayout(new BorderLayout(20, 20));
        JLabel l0 = new JLabel(Charte.getMessage("InitLng_Hello"), JLabel.CENTER);
        dialogue.getContentPane().add(l0, BorderLayout.CENTER);
        JLabel lM = new JLabel(Charte.getSmiley(Charte.CONTENT));
        dialogue.getContentPane().add(lM, BorderLayout.WEST);
        JPanel p = new JPanel(new GridLayout(options.length, 1));
        for(int i=0; i<options.length; i++){
            JButton b = new JButton(options[i]);
            final int j = i;
            b.addActionListener(new ActionListener(){
                public void actionPerformed(ActionEvent ae){
                    choix(j);
                }
            });
            p.add(b);
        }
        dialogue.getContentPane().add(p, BorderLayout.SOUTH);
        dialogue.pack();
        dialogue.setLocation(w / 2 - dialogue.getSize().width / 2,
                             h / 2 - dialogue.getSize().height / 2);
        dialogue.setVisible(true);

        String langueVoulue = inv.get(options[choisi]).toString();
        if (!(langueVoulue.equals(Charte.getLangue()))) {
            Charte.setLangue(langueVoulue);
            JOptionPane.showMessageDialog(this, Charte.getMessage("InitLng_End"),
                                          "", 0, Charte.getSmiley(
                                                  Charte.CLIN_D_OEIL));
        }
    }

    private void choix(int x){
        choisi = x;
        dialogue.setVisible(false);
    }
}
