/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.xml;

import ihm.Charte;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.IOException;
/**
 * This class offers methods for parsing an XML file into a hierarchical tree.
 * See org.w3c.dom.Document for further information about the obtained tree.
 *
 * @author Samuel Gesche
 * @version 1.4
 */

public class XMLReader{

  /**
   * Parses the given file into a tree.
   * @param file the XML file to parse.
   * @return a Document describing the XML file.
   * @throws towntology.DOMCreationFailureException if someting goes wrong.
   */
  public static Document getDOM(File file) throws DOMCreationFailureException{
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    dbf.setIgnoringComments(true);
    dbf.setCoalescing(false);
    dbf.setIgnoringElementContentWhitespace(true);
    DocumentBuilder db = null;
    try{
      db = dbf.newDocumentBuilder();
    }
    catch (ParserConfigurationException pce){
      throw new DOMCreationFailureException(Charte.getMessage("Error_Parser_Conf")+
                                            " (" +file.getName()+" : "+
                                            pce.getMessage() + ")", pce);
    }
    Document result = null;
    try{
      result = db.parse(file);
    }
    catch (SAXException se){
      throw new DOMCreationFailureException(Charte.getMessage("Error_Text_Parsing")+
                                            " (" +file.getName()+" : "+
                                            se.getMessage() + ")", se);
    }
    catch (IOException ioe){
      throw new DOMCreationFailureException(Charte.getMessage("Error_Text_Parsing")+
                                            " (" +file.getName()+" : "+
                                            ioe.getMessage() + ")", ioe);
    }
    return result;
  }

}
