/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.xml;
/**
 * Cette exception est renvoyée lors d'un échec à la lecture d'un document XML.
 * <br>
 *
 * @author Samuel Gesche
 * @version 3.0
 * @since 3.0.0
 */
public class DOMCreationFailureException extends Exception {

    /**
     * Crée une exception sans message ni cause.
     * @since 3.0.0
     */
    public DOMCreationFailureException() {
    }

    /**
     * Crée une exception avec un message en détaillant les raisons.
     * @param message String le message en question.
     * @since 3.0.0
     */
    public DOMCreationFailureException(String message) {
        super(message);
    }

    /**
     * Crée une exception avec un message en détaillant les raisons et une cause.
     * @param message String le message en question.
     * @param cause Throwable la cause en question.
     * @since 3.0.0
     */
    public DOMCreationFailureException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Crée une exception avec une cause.
     * @param cause Throwable la cause en question.
     * @since 3.0.0
     */
    public DOMCreationFailureException(Throwable cause) {
        super(cause);
    }
}
