/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Un type de noeud, comme défini dans Leucippe.
 *
 * Notes :
 *  - Deux types de noeuds sont considérés égaux si et seulement s'ils ont le
 * même nom (sans compter la casse).
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class TypeNoeud {
    private String nom;

    public TypeNoeud(String nom){
        this.nom = nom;
    }

    public String getNom(){
        return nom;
    }

    private String description = "";
    public void setDescription(String desc){
        description = desc;
    }

    public String getDescription(){
        return description;
    }

    public boolean equals(Object o){
        boolean res = false;
        if(o instanceof TypeNoeud){
            if(((TypeNoeud)o).nom.equalsIgnoreCase(nom)){
                res = true;
            }
        }
        return res;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return nom;
    }


}
