/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;

import java.util.Set;
import java.util.HashSet;
/**
 * Un type de lien, comme défini dans Leucippe.
 *
 * Notes :
 *  - Deux types de liens sont considérés égaux si et seulement s'ils ont le
 * même nom (sans compter la casse). Les propriétés n'entrent pas en compte ici,
 * attention si l'on veut comparer les types de liens de plusieurs modèles.
 *  - Un même type de lien ne peut pas avoir deux instances égales de Propriete.
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class TypeLien {
    private String nom;
    private Set proprietes;
    private int marqueurHomonymie;

    public TypeLien(String nom){
        this.nom = nom;
        this.proprietes = new HashSet();
        this.marqueurHomonymie = 0;
    }

    public TypeLien(String nom, Propriete[] proprietes){
        this(nom);
        for(int i=0; i<proprietes.length; i++){
            this.proprietes.add(proprietes[i]);
        }
    }

    public void addPropriete(Propriete p){
        proprietes.add(p);
    }

    private String description = "";
    public void setDescription(String desc){
        description = desc;
    }

    public String getDescription(){
        return description;
    }

    public String getNomBase(){
        return nom;
    }


    public String getNom(){
        return nom + ((marqueurHomonymie==0) ? "" : " - "+marqueurHomonymie);
    }


    public void setHomonyme(int numero){
        marqueurHomonymie = numero;
    }

    public Propriete[] getProprietes(){
        Propriete[] res = new Propriete[proprietes.size()];
        proprietes.toArray(res);
        return res;
    }

    public boolean equals(Object o){
        boolean res = false;
        if(o instanceof TypeLien){
            if(((TypeLien)o).nom.equalsIgnoreCase(nom)){
                res = true;
            }
        }
        return res;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return nom+" ("+proprietes+")";
    }


}
