/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Représente une chaîne de caractères concernant plusieurs points de vue.
 * De fait, la représentation consiste à relier la chaîne avec un tableau de
 * booléens indiquant, pour chacun des points de vue, si oui ou non elle le
 * concerne.
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class TexteCommun {
    private String texte = "";
    private boolean[] concerne;

    public TexteCommun(String texte, int nbPdV){
        this.texte = texte;
        this.concerne = new boolean[nbPdV];
        for(int i=0; i<concerne.length; i++){
            concerne[i] = false;
        }
    }

    public TexteCommun(String texte, boolean[] concerne){
        this.texte = texte;
        this.concerne = concerne;
    }

    public TexteCommun(String sauvegarde){
        String[] s = sauvegarde.split("\\$");
        this.texte = s[0];//.split(" - ")[0]; // On ne garde pas la marque d'ambiguité
        this.concerne = new boolean[s[1].length()];
        for(int i=0; i<s[1].length(); i++){
            if(s[1].charAt(i) == '1'){
                concerne[i] = true;
            } else {
                concerne[i] = false;
            }
        }
    }

    public String getSauvegarde(){
        String con = "";
        for(int i=0; i<concerne.length; i++){
            if(concerne[i]){
                con += "1";
            } else {
                con += "0";
            }
        }
        return texte+"$"+con;
    }

    public void addConcerne(int index, boolean oui){
        concerne[index] = oui;
    }

    public String getTexte(){
        return texte;
    }

    public String toString(){
        return texte;
    }

    public boolean equals(Object o){
        return texte.equalsIgnoreCase(((TexteCommun)o).texte);
    }

    public boolean hasPVCommun(TexteCommun t){
        boolean result = false;
        for(int i=0; i<concerne.length; i++){
            // On suppose qu'il y a le même nombre de points de vue de part et
            // d'autres, hein ?
            if(concerne[i] == true && t.concerne[i] == true){
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean[] getConcernes(){
        return concerne;
    }

}
