/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Une propriété de type de lien, comme définie en Leucippe.
 *
 * Notes :
 *  - La valeur de la propriété, quelle qu'elle soit en entrée, ne sera
 * retournée que sous la forme de VRAI, FAUX ou CONTINGENT.
 *  - Deux propriétés sont considérées égales si et seulement si leurs noms
 * (sans compter la casse) sont égaux.
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class Propriete {
    private String nom;
    private int valeur;
    private int marqueurHomonymie;

    public final static int VRAI = 1;
    public final static int FAUX = 0;
    public final static int CONTINGENT = -1;

    public final static String SYMETRIE = "Symétrie";
    public final static String TRANSITIVITE = "Transitivité";
    public final static String REFLEXIVITE = "Réflexivité";

    public Propriete(String nom, int valeur){
        this.nom = nom;
        this.marqueurHomonymie = 0;
        if(valeur==VRAI || valeur==FAUX){
            this.valeur = valeur;
        } else {
            this.valeur = CONTINGENT;
        }
    }

    public int getValeur(){
        return valeur;
    }

    public String getNomBase(){
        return nom;
    }

    public String getNom(){
        return nom + ((marqueurHomonymie==0) ? "" : " - "+marqueurHomonymie);
    }

    public void setHomonyme(int numero){
        marqueurHomonymie = numero;
    }

    private String description = "";
    public void setDescription(String desc){
        description = desc;
    }

    public String getDescription(){
        return description;
    }

    public boolean equals(Object o){
        boolean res = false;
        if(o instanceof Propriete){
            res = ((Propriete)o).getNom().equalsIgnoreCase(nom);
        }
        return res;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return nom+" ("+valeur+")";
    }

}
