/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Un noeud, comme défini en Leucippe.
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class Noeud {
    private String label;
    private String description = "";
    private TypeNoeud type;
    private int desambiguateur;
    private int marqueurHomonymie;

    private static int nbImages = 0;

    public Noeud(String label, TypeNoeud type){
        this.label = label;
        this.type = type;
        this.desambiguateur = 1;
        this.marqueurHomonymie = 0;
    }

    public void setDescription(String desc){
        description = desc;
    }

    public String getDescription(){
        return description;
    }

    public String getLabelBase(){
        return label;
    }

    public String getLabel(){
        return label + ((desambiguateur==1) ? "" : " ("+desambiguateur+")") +
                ((marqueurHomonymie==0) ? "" : " - "+marqueurHomonymie);
    }

    public TypeNoeud getType(){
        return type;
    }

    public void declareAmbigu(){
        desambiguateur ++;
    }

    public void setHomonyme(int numero){
        marqueurHomonymie = numero;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return label+" ("+type+")";
    }

}
