/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;

import java.util.Vector;
/**
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class MotHomonyme {
    private TexteCommun[] mots;
    private String lien = "";
    private String comm = "";

    public MotHomonyme(TexteCommun[] mots, String lien, String commentaire) {
        this.mots = mots;
        this.lien = lien;
        this.comm = commentaire;
    }

    public MotHomonyme(String sauvegarde){
        String[] s = sauvegarde.split("::");
        this.lien = s[0];
        this.comm = s[1];
        Vector v = new Vector();
        for(int i=2; i<s.length; i++){
            TexteCommun t = new TexteCommun(s[i]);
            v.add(t);
        }
        this.mots = new TexteCommun[v.size()];
        v.toArray(mots);
    }

    public String getSauvegarde(){
        String s = "";
        s += lien+"::"+comm+"::";
        for(int i=0; i<mots.length; i++){
            s += mots[i].getSauvegarde().split("\\$")[0].split(" - ")[0]+"$"
                    +mots[i].getSauvegarde().split("\\$")[1]; // On ne garde pas la marque d'ambiguité
            if(i<mots.length-1){
                s += "::";
            }
        }
        return s;
    }

    public TexteCommun[] getMots() {
        return mots;
    }

    public String getLien(){
        return lien;
    }

    public String getCommentaire(){
        return comm;
    }

    public boolean equals(Object o){
        boolean res = false;
        if(o instanceof ListeSynonymes){
            MotHomonyme l = (MotHomonyme)o;
            return l.getMots().equals(getMots());
        }
        return res;
    }

    public String toString(){
        String res = mots[0].getTexte();
        if(!(lien.equals(""))){
            res += " {"+lien+"}";
        }
        return res;
    }
}
