/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;

import java.util.HashSet;
import java.util.Vector;
import ihm.Charte;
/**
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class ListeSynonymes {
    private HashSet synos;
    private String lien = "";
    private String comm = "";

    /*public ListeSynonymes() {
        synos = new HashSet();
    }*/

    public ListeSynonymes(String lien, String comm) {
        synos = new HashSet();
        this.lien = lien;
        this.comm = comm;
    }


    public ListeSynonymes(TexteCommun[] liste) {
        synos = new HashSet();
        for (int i = 0; i < liste.length; i++) {
            synos.add(liste[i]);
        }
    }

    public ListeSynonymes(String sauvegarde){
        String[] s = sauvegarde.split("::");
        this.lien = s[0];
        this.comm = s[1];
        synos = new HashSet();
        for(int i=2; i<s.length; i++){
            TexteCommun t = new TexteCommun(s[i]);
            synos.add(t);
        }
    }

    public String getSauvegarde(){
        TexteCommun[] syn = new TexteCommun[synos.size()];
        synos.toArray(syn);
        String s = "";
        s += lien+"::"+comm+"::";
        for(int i=0; i<syn.length; i++){
            s += syn[i].getSauvegarde();
            if(i<syn.length-1){
                s += "::";
            }
        }
        return s;
    }

    public void add(TexteCommun syno) {
        synos.add(syno);
    }

    public void remove(TexteCommun syno) {
        synos.remove(syno);
    }

    public void replace(TexteCommun orig, TexteCommun repl){
        remove(orig);
        add(repl);
    }

    public boolean contains(TexteCommun syno){
        boolean res = false;
        Vector v = new Vector(synos);
        for(int i=0; i<v.size(); i++){
            if(((TexteCommun)(v.elementAt(i))).equals(syno)){
                res = true;
                break;
            }
        }
        return res;
    }

    public void termeFusionne(TexteCommun ini, TexteCommun nouv){
        Vector v = new Vector(synos);
        for(int i=0; i<synos.size(); i++){
            TexteCommun t = (TexteCommun)(v.elementAt(i));
            if(t.getTexte().equalsIgnoreCase(ini.getTexte())){
                synos.remove(t);
                synos.add(nouv);
            }
        }
    }

    public boolean intersects(ListeSynonymes liste) {
        // Hasardeux depuis l'introduction des raisons. L'intersection n'est donc
        // vraie que si une des listes est inclue dans l'autre et que les deux
        // ont la même raison d'être.
        HashSet test = (HashSet) (synos.clone());
        test.removeAll(liste.synos);
        HashSet test2 = (HashSet) (liste.synos.clone());
        test2.removeAll(synos);
        return (test.size() == 0 || test2.size()==0) &&
                lien.equals(liste.lien);
        /*HashSet test = (HashSet) (synos.clone());
        test.retainAll(liste.synos);
        return test.size() > 0;*/
    }

    public boolean intersects(boolean[] b){
        boolean res = false;
        for(int i=0; i<getListe().length; i++){
            if(getListe()[i].hasPVCommun(new TexteCommun("", b))){
                res = true;
            }
        }
        return res;
    }

    public void mergeWith(ListeSynonymes liste) {
        synos.addAll(liste.synos);
        if(!(liste.getLien().equals(lien))){
            lien = Charte.getMessage("ListeSyno_Justification");
        }
    }

    public TexteCommun[] getListe() {
        TexteCommun[] res = new TexteCommun[synos.size()];
        synos.toArray(res);
        return res;
    }

    public String getLien(){
        return lien;
    }

    public String getCommentaire(){
        return comm;
    }

    private boolean listeEgale(ListeSynonymes l){
        Vector v = new Vector(synos);
        Vector v2 = new Vector(l.synos);
        return (v.containsAll(v2) && v2.containsAll(v));
    }

    public boolean equals(Object o){
        boolean res = false;
        if(o instanceof ListeSynonymes){
            ListeSynonymes l = (ListeSynonymes)o;
            return (listeEgale(l) && (lien.equals(l.getLien()) || lien.equals("") || l.getLien().equals("")));
        }
        return res;
    }

    public String toString(){
        String res = "";
        for(int i=0; i<getListe().length; i++){
            res += getListe()[i].toString();
            if(i<getListe().length-1){
                res += ";";
            }
        }
        if(!(lien.equals(""))){
            res += "{"+lien+"}";
        }
        return res;
    }
}
