/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Un lien, comme défini en Leucippe.
 * Cette classe ne contient que la description du lien lui-même (nom, type).
 * La relation entre liens et noeuds se fait dans un objet "Association".
 *
 * @author Samuel GESCHE
 * @version 3.0
 */
public class Lien {
    private String label;
    private TypeLien type;

    public Lien(String label, TypeLien type){
        this.label = label;
        this.type = type;
    }

    public String getLabel(){
        return label;
    }

    public TypeLien getType(){
        return type;
    }

    private String description = "";
    public void setDescription(String desc){
        description = desc;
    }

    public String getDescription(){
        return description;
    }

    public boolean estUneArete(){
        Propriete[] ps = type.getProprietes();
        boolean res = false;
        for(int i=0; i<ps.length; i++){
            if(ps[i].getNom().equals(Propriete.SYMETRIE) &&
               ps[i].getValeur() == Propriete.VRAI){
                res = true;
                break;
            }
        }
        return res;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return label+" ("+type+")";
    }

}
