/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package data;
/**
 * Une association est faite entre un Lien, un Noeud origine et un Noeud
 * destination. <br>
 * En Leucippe, les Noeuds et le Liens sont des Entités au même titre. Cela
 * implique que dans un graphe Leucippe, on a des noeuds "Noeud" et des noeuds
 * "Lien". Cela permet de les étudier au même titre lors de la confrontation.
 * L'association permet de les relier comme le lien relie les noeuds dans le
 * graphe représenté.<br>
 *
 * @author Samuel GESCHE
 * @version 3.0
 * @since 3.0
 */
public class Association {
    private Lien lien;
    private Noeud origine;
    private Noeud destination;

    /**
     * Construit une association entre le Lien et les deux Noeuds donnés.
     * @param lien Lien le lien entre les noeuds
     * @param orig Noeud le noeud origine du lien
     * @param dest Noeud le noeud destination du lien
     * @since 3.0
     */
    public Association(Lien lien, Noeud orig, Noeud dest) {
        this.lien = lien;
        destination = dest;
        origine = orig;
    }

    /**
     * Renvoie le Lien.
     * @return Lien le lien
     * @since 3.0
     */
    public Lien getLien() {
        return lien;
    }

    /**
     * Renvoie le Noeud origine.
     * @return Noeud le noeud origine
     * @since 3.0
     */
    public Noeud getOrigine() {
        return origine;
    }

    /**
     * Renvoie le Noeud destination.
     * @return Noeud le noeud destination
     * @since 3.0
     */
    public Noeud getDestination() {
        return destination;
    }

    /**
     * Renvoie les deux Noeuds.
     * @return Noeud[] les noeuds de cette association
     * @since 3.0
     */
    public Noeud[] getExtremites() {
        Noeud[] n = {origine, destination};
        return n;
    }

    /**
     * Renvoie une description textuelle de l'objet.
     * @return String une description textuelle de l'objet
     * @since 4.0.1
     */
    public String toString(){
        return "Association : "+origine+" ==="+lien+"==>"+destination;
    }

}
