/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

import ihm.Charte;
import ihm.FenetreInit;
import ihm.FenetrePrincipale;

import java.io.File;

/**
 * Lancement de l'application
 * 
 * @author Samuel GESCHE
 * @version 3.5.1
 * @since 3.0
 */
public class Starter {
    public static void main(String[] args){
        System.out.println("Lancement de Hippodamos v"+Charte.getVersion()+"...");
        File d = new File("dat/usr");
        d.mkdir();
        d = new File("dat/pdv");
        d.mkdir();
        d = new File("dat/img");
        d.mkdir();
        d = new File("dat/lng");
        d.mkdir();
        Charte.initUI();
        System.out.println("Lancement terminé.");

        FenetreInit f = new FenetreInit();
        f.run();
        new FenetrePrincipale(f);
    }
}
