/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.Charte;
import ihm.townto.FixedStyledEditorKit;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;

public class StyledTextPanel
extends JTextPane {
    private int maxResources = 0;
    public static final String STYLE_TEXT = "text";
    protected Style text;
    public static final String STYLE_TITLE = "title";
    protected Style title;
    public static final String STYLE_DOMAIN = "domain";
    protected Style domain;
    public static final String STYLE_SOURCE = "source";
    protected Style source;
    public static final String STYLE_TEXT2 = "text2";
    protected Style text2;
    public static final String STYLE_LEGEND = "legend";
    protected Style legend;
    public static final String STYLE_GRAPH = "graph";
    protected Style graph;
    private StyledDocument doc;

    public StyledTextPanel() {
        this.setEditable(false);
        this.setDoubleBuffered(true);
        this.setEditorKit(new FixedStyledEditorKit());
        this.setOpaque(false);
        this.doc = (StyledDocument)this.getDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setForeground(def, this.getForeground());
        StyleConstants.setAlignment(def, 3);
        this.text = this.doc.addStyle(STYLE_TEXT, def);
        StyleConstants.setFontFamily(def, Charte.getFont().getFamily());
        StyleConstants.setFontSize(this.text, 14);
        StyleConstants.setAlignment(this.text, 3);
        this.title = this.doc.addStyle(STYLE_TITLE, this.text);
        StyleConstants.setUnderline(this.title, true);
        StyleConstants.setAlignment(this.title, 1);
        this.domain = this.doc.addStyle(STYLE_DOMAIN, this.text);
        StyleConstants.setItalic(this.domain, true);
        this.source = this.doc.addStyle(STYLE_SOURCE, this.domain);
        StyleConstants.setFontSize(this.source, 12);
        StyleConstants.setAlignment(this.source, 2);
        this.text2 = this.doc.addStyle(STYLE_TEXT2, this.text);
        this.legend = this.doc.addStyle(STYLE_LEGEND, this.text2);
        StyleConstants.setAlignment(this.legend, 1);
        this.graph = this.doc.addStyle(STYLE_GRAPH, this.text);
        StyleConstants.setAlignment(this.graph, 1);
        StyleConstants.setFontSize(this.graph, 10);
    }

    public int getLineCount() {
        int rowCount = 0;
        int len = this.doc.getLength();
        int offset = 0;
        try {
            int end;
            while (offset < len && (end = Utilities.getRowEnd(this, offset)) >= 0) {
                ++rowCount;
                offset = end = Math.min(end + 1, len);
            }
        }
        catch (BadLocationException e) {
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            // empty catch block
        }
        return rowCount == 0 ? 2 : rowCount;
    }

    public void clear() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void write(String text, String style) {
        if (text == null) {
            return;
        }
        try {
            int o = this.doc.getLength();
            int l = text.length();
            this.doc.insertString(this.doc.getLength(), text, this.doc.getStyle(style));
            this.doc.setParagraphAttributes(o, l, this.doc.getStyle(style), true);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void addImage(Image image, String description) {
        ++this.maxResources;
        Style s = this.doc.addStyle("" + this.maxResources, this.text);
        StyleConstants.setAlignment(s, 1);
        StyleConstants.setIcon(s, new ImageIcon(image));
        this.write("\n", "" + this.maxResources);
        this.write("" + description, STYLE_LEGEND);
    }

    public void addSound(URL soundURL, String description) {
        ++this.maxResources;
        Style s = this.doc.addStyle("" + this.maxResources, this.text);
        ImageIcon icon = new ImageIcon("sound.png");
        JButton button = new JButton(icon);
        URL soundURL0 = soundURL;
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        StyleConstants.setAlignment(s, 1);
        StyleConstants.setComponent(s, button);
        this.write("\n", "" + this.maxResources);
        this.write("" + description, STYLE_LEGEND);
    }

    public void addMusic(URL musicURL, String description) {
        ++this.maxResources;
        Style s = this.doc.addStyle("" + this.maxResources, this.text);
        ImageIcon icon = new ImageIcon("music.png");
        JButton button = new JButton(icon);
        URL musicURL0 = musicURL;
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        StyleConstants.setAlignment(s, 1);
        StyleConstants.setComponent(s, button);
        this.write("\n", "" + this.maxResources);
        this.write("" + description, STYLE_LEGEND);
    }
}

