/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.Charte;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.Popup;

public class LinkFactory {
    protected static final GeneralPath GENERAL_ARROW = new GeneralPath();
    protected static final GeneralPath SYMMETRIC_ARROW = new GeneralPath();

    public static GeneralPath createArrow(int xFrom, int yFrom, int xTo, int yTo) {
        double dx = 1.0 * (double)xTo - (double)xFrom;
        double dy = 1.0 * (double)yTo - (double)yFrom;
        double alpha = Math.atan2(dy, dx);
        double pi = Math.PI;
        GeneralPath result = new GeneralPath(GENERAL_ARROW);
        AffineTransform transform = AffineTransform.getRotateInstance(alpha, 5.0, 5.0);
        result.transform(transform);
        return result;
    }

    public static GeneralPath createSymmetricArrow(int xFrom, int yFrom, int xTo, int yTo) {
        double dx = 1.0 * (double)xTo - (double)xFrom;
        double dy = 1.0 * (double)yTo - (double)yFrom;
        double alpha = Math.atan2(dy, dx);
        double pi = Math.PI;
        GeneralPath result = new GeneralPath(SYMMETRIC_ARROW);
        AffineTransform transform = AffineTransform.getRotateInstance(alpha, 5.0, 5.0);
        result.transform(transform);
        return result;
    }

    public ArrowComponent createArrowComponent(String text, GeneralPath arrow, Color color, Component parent) {
        ArrowComponent comp = new ArrowComponent(text, arrow, color, parent);
        return comp;
    }

    static {
        GENERAL_ARROW.moveTo(10.0f, 5.0f);
        GENERAL_ARROW.lineTo(0.0f, 2.0f);
        GENERAL_ARROW.lineTo(3.0f, 5.0f);
        GENERAL_ARROW.lineTo(0.0f, 8.0f);
        GENERAL_ARROW.lineTo(10.0f, 5.0f);
        SYMMETRIC_ARROW.moveTo(10.0f, 5.0f);
        SYMMETRIC_ARROW.lineTo(5.0f, 3.0f);
        SYMMETRIC_ARROW.lineTo(0.0f, 5.0f);
        SYMMETRIC_ARROW.lineTo(5.0f, 7.0f);
        SYMMETRIC_ARROW.lineTo(10.0f, 5.0f);
    }

    class ArrowComponent
    extends JComponent {
        private GeneralPath arrow;
        private Color color;
        private JLabel txt;
        private Popup popup;
        private Component parent;

        public ArrowComponent(String text, GeneralPath arrow, Color color, Component parent) {
            this.arrow = arrow;
            this.color = color;
            this.parent = parent;
            this.setOpaque(false);
            this.setLocation(0, 0);
            this.setToolTipText(text);
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip();
            return toolTip;
        }

        public void setArrow(GeneralPath arrow) {
            this.arrow = arrow;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D gra = (Graphics2D)g;
            gra.setColor(Charte.getMiscellaneous());
            gra.fill(this.arrow);
        }
    }
}

