/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.Charte;
import ihm.townto.EventHandler;
import ihm.townto.Graph;
import ihm.townto.GraphLayout;
import ihm.townto.LinkFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.Timer;

public class GraphPanel
extends JPanel
implements Scrollable {
    protected Node activeNode;
    protected Node[] crown1;
    protected Node[] crown2;
    protected NumberNode[] numbers;
    protected Link[] links;
    protected LinkFactory.ArrowComponent[] arrows;
    protected NumberLink[] nLinks;
    protected GraphLayout layout = new GraphLayout();
    protected boolean processing = false;
    protected int idG = 0;
    protected ActionListener alMover = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            GraphPanel.this.doLayout();
        }
    };
    protected Timer mover = new Timer(100, this.alMover);
    private Node[] allNodesSorted = null;

    public GraphPanel(Graph gd, int id) {
        this.setLayout(this.layout);
        this.setDoubleBuffered(false);
        this.idG = id;
        this.setOpaque(false);
        this.setSize(this.getPreferredSize());
        this.setGraph(gd);
        this.mover.start();
    }

    public void setGraph(Graph gd) {
        this.createStuff(gd);
        this.layout.invalidate();
        for (int i = 0; i < 100 / gd.getNumberOfNodes(); ++i) {
            this.doLayout();
        }
    }

    Node[] getAllNodesSorted() {
        if (this.allNodesSorted == null) {
            int i;
            Vector<Node> res = new Vector<Node>();
            res.addElement(this.activeNode);
            for (i = 0; i < this.crown1.length; ++i) {
                res.add(this.crown1[i]);
            }
            for (i = 0; i < this.crown2.length; ++i) {
                res.add(this.crown2[i]);
            }
            this.allNodesSorted = new Node[res.size()];
            res.toArray(this.allNodesSorted);
            Arrays.sort(this.allNodesSorted, new ComparateurHashNoeuds());
        }
        return this.allNodesSorted;
    }

    Node[] getFirstCrown() {
        return this.crown1;
    }

    Node[] getSecondCrown() {
        return this.crown2;
    }

    NumberNode[] getNumberNodes() {
        return this.numbers;
    }

    Node getActiveNode() {
        return this.activeNode;
    }

    LinkFactory.ArrowComponent[] getArrows() {
        return this.arrows;
    }

    Node[] getSecondCrown(Node firstCrownNode) {
        int id = firstCrownNode.getId();
        Vector<Node> result = new Vector<Node>();
        for (int i = 0; i < this.links.length; ++i) {
            if (this.links[i].getNode1().getId() == id && this.links[i].getNode2().getId() != this.activeNode.getId()) {
                result.addElement(this.links[i].getNode2());
            }
            if (this.links[i].getNode2().getId() != id || this.links[i].getNode1().getId() == this.activeNode.getId()) continue;
            result.addElement(this.links[i].getNode1());
        }
        Node[] cmp = new Node[result.size()];
        result.toArray(cmp);
        return cmp;
    }

    protected boolean isActiveNode(Node n) {
        return n.getId() == this.getActiveNode().getId();
    }

    protected boolean isInFirstCrown(Node n) {
        Node[] liste = this.getFirstCrown();
        boolean res = false;
        for (int i = 0; i < liste.length; ++i) {
            if (liste[i].getId() != n.getId()) continue;
            res = true;
            break;
        }
        return res;
    }

    protected boolean isInSecondCrown(Node n) {
        Node[] liste = this.getSecondCrown();
        boolean res = false;
        for (int i = 0; i < liste.length; ++i) {
            if (liste[i].getId() != n.getId()) continue;
            res = true;
            break;
        }
        return res;
    }

    boolean isInCrownOf(Node firstNode, Node secondNode) {
        boolean yes = false;
        if (this.isActiveNode(firstNode) && this.isInFirstCrown(secondNode) || this.isActiveNode(firstNode) && this.isInSecondCrown(secondNode)) {
            yes = true;
        }
        if (!yes && this.isInFirstCrown(firstNode)) {
            Node[] liste = this.getSecondCrown(firstNode);
            for (int i = 0; i < liste.length; ++i) {
                if (liste[i].getId() != secondNode.getId()) continue;
                yes = true;
                break;
            }
        }
        return yes;
    }

    Node getFirstNode(int linkIndex) {
        return this.links[linkIndex].getNode1();
    }

    Node getSecondNode(int linkIndex) {
        return this.links[linkIndex].getNode2();
    }

    NumberNode getNumberNode(Node node) {
        NumberNode result = null;
        for (int i = 0; i < this.nLinks.length; ++i) {
            if (node.getId() != this.nLinks[i].getNode().getId()) continue;
            result = this.nLinks[i].getNumberNode();
        }
        return result;
    }

    protected void createStuff(Graph gd) {
        NumberLink link;
        NumberNode node;
        int i;
        this.processing = true;
        this.removeAll();
        this.activeNode = new Node(gd.getActive().getName(), gd.getActive().getDescription(), gd.getActive().getId(), this);
        this.activeNode.setBorder(Charte.getBorder());
        this.add(this.activeNode);
        Graph.GraphNode[] nodes1 = gd.getSortedFirstCrown();
        this.crown1 = new Node[nodes1.length];
        for (int i2 = 0; i2 < this.crown1.length; ++i2) {
            this.crown1[i2] = new Node(nodes1[i2].getName(), nodes1[i2].getDescription(), nodes1[i2].getId(), this);
            this.add(this.crown1[i2]);
        }
        Graph.GraphNode[] nodes2 = gd.getSortedSecondCrown();
        this.crown2 = new Node[nodes2.length];
        for (int i3 = 0; i3 < this.crown2.length; ++i3) {
            this.crown2[i3] = new Node(nodes2[i3].getName(), nodes2[i3].getDescription(), nodes2[i3].getId(), this);
            this.add(this.crown2[i3]);
        }
        Vector<NumberNode> num = new Vector<NumberNode>();
        Vector<NumberLink> lin = new Vector<NumberLink>();
        for (i = 0; i < nodes1.length; ++i) {
            if (nodes1[i].getRelationsCount() <= 0) continue;
            node = new NumberNode(nodes1[i].getId(), nodes1[i].getRelationsCount());
            link = new NumberLink(this.crown1[i], node);
            num.addElement(node);
            lin.addElement(link);
            this.add(node);
            this.add(link);
        }
        for (i = 0; i < nodes2.length; ++i) {
            if (nodes2[i].getRelationsCount() <= 0) continue;
            node = new NumberNode(nodes2[i].getId(), nodes2[i].getRelationsCount());
            link = new NumberLink(this.crown2[i], node);
            num.addElement(node);
            lin.addElement(link);
            this.add(node);
            this.add(link);
        }
        this.numbers = new NumberNode[num.size()];
        num.toArray(this.numbers);
        this.nLinks = new NumberLink[lin.size()];
        lin.toArray(this.nLinks);
        Graph.GraphLink[] llinks = gd.getLinks();
        this.links = new Link[llinks.length];
        boolean it = false;
        for (int i4 = 0; i4 < this.links.length; ++i4) {
            int j;
            this.links[i4] = new Link(new Node("", "", 0, this), new Node("", "", 0, this), "", Charte.getMiscellaneous());
            Node node1 = null;
            Node node2 = null;
            int from = llinks[i4].getIdConcept1();
            int to = llinks[i4].getIdConcept2();
            if (from >= 0 && from <= 9) {
                node1 = this.activeNode;
            }
            if (to >= 0 && to <= 9) {
                node2 = this.activeNode;
            }
            if (from >= 10 && from <= 999) {
                for (j = 0; j < this.crown1.length; ++j) {
                    if (this.crown1[j].getId() != from) continue;
                    node1 = this.crown1[j];
                }
            }
            if (to >= 10 && to <= 999) {
                for (j = 0; j < this.crown1.length; ++j) {
                    if (this.crown1[j].getId() != to) continue;
                    node2 = this.crown1[j];
                }
            }
            if (from >= 1000 && from <= 99999) {
                for (j = 0; j < this.crown2.length; ++j) {
                    if (this.crown2[j].getId() != from) continue;
                    node1 = this.crown2[j];
                }
            }
            if (to >= 1000 && to <= 99999) {
                for (j = 0; j < this.crown2.length; ++j) {
                    if (this.crown2[j].getId() != to) continue;
                    node2 = this.crown2[j];
                }
            }
            if (node1 != null && node2 != null) {
                this.links[i4] = new Link(node1, node2, llinks[i4].getText(), llinks[i4].getColor());
                this.add(this.links[i4]);
            }
            this.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        }
        this.arrows = new LinkFactory.ArrowComponent[this.links.length];
        LinkFactory factory = new LinkFactory();
        for (int i5 = 0; i5 < this.arrows.length; ++i5) {
            int x1 = this.links[i5].getNode1().getLocation().x;
            int y1 = this.links[i5].getNode1().getLocation().y;
            int x2 = this.links[i5].getNode2().getLocation().x;
            int y2 = this.links[i5].getNode2().getLocation().y;
            String text = " " + this.links[i5].getText() + " ";
            this.arrows[i5] = factory.createArrowComponent(text, LinkFactory.createArrow(x1, y1, x2, y2), this.links[i5].getColor(), this);
            this.add(this.arrows[i5]);
        }
        this.processing = false;
    }

    protected void choose(String name) {
    }

    protected void getInfos(String name) {
    }

    boolean isLinked(Node n1, Node n2) {
        boolean linked = false;
        for (int i = 0; i < this.links.length; ++i) {
            if ((!this.links[i].getNode1().equals(n1) || !this.links[i].getNode2().equals(n2)) && (!this.links[i].getNode2().equals(n1) || !this.links[i].getNode1().equals(n2))) continue;
            linked = true;
            break;
        }
        return linked;
    }

    @Override
    public void doLayout() {
        if (this.processing) {
            return;
        }
        super.doLayout();
    }

    void resizeLinks() {
        int i;
        for (i = 0; i < this.links.length; ++i) {
            this.links[i].resize();
        }
        for (i = 0; i < this.nLinks.length; ++i) {
            this.nLinks[i].resize();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.layout.preferredLayoutSize(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.layout.minimumLayoutSize(this);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle view, int ori, int dir) {
        return 100;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle view, int ori, int dir) {
        return 1000;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class ComparateurHashNoeuds
    implements Comparator {
        private ComparateurHashNoeuds() {
        }

        public int compare(Object o1, Object o2) {
            return o1.hashCode() - o2.hashCode();
        }
    }

    protected class NumberLink
    extends JLabel {
        private Node node1;
        private NumberNode node2;

        public NumberLink(Node node1, NumberNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        public Node getNode() {
            return this.node1;
        }

        public NumberNode getNumberNode() {
            return this.node2;
        }

        public void resize() {
            this.setBounds(this.node1.getBounds().union(this.node2.getBounds()));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Charte.getMiscellaneous());
            Area a = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            Rectangle r1 = this.node1.getBounds();
            r1.translate(0 - this.getX(), 0 - this.getY());
            a.subtract(new Area(r1));
            Ellipse2D.Double e = new Ellipse2D.Double(this.node2.getX() - this.getX(), this.node2.getY() - this.getY(), this.node2.getSize().width, this.node2.getSize().height);
            a.subtract(new Area(e));
            ((Graphics2D)g).clip(a);
            float[] dash = new float[]{2.0f, 2.0f};
            ((Graphics2D)g).setStroke(new BasicStroke(0.5f, 0, 2, 10.0f, dash, 0.0f));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).drawLine(this.node1.getLocation().x + this.node1.getSize().width / 2 - this.getX(), this.node1.getLocation().y + this.node1.getSize().height / 2 - this.getY(), this.node2.getLocation().x + this.node2.getSize().width / 2 - this.getX(), this.node2.getLocation().y + this.node2.getSize().height / 2 - this.getY());
        }
    }

    protected class Link
    extends JLabel {
        private Node node1;
        private Node node2;
        private String linkText;
        private Color color;

        public Link(Node node1, Node node2, String text, Color color) {
            this.node1 = node1;
            this.node2 = node2;
            this.linkText = text;
            this.color = color;
        }

        public Node getNode1() {
            return this.node1;
        }

        public Node getNode2() {
            return this.node2;
        }

        @Override
        public String getText() {
            return this.linkText;
        }

        public Color getColor() {
            return this.color;
        }

        public void resize() {
            this.setBounds(this.node1.getBounds().union(this.node2.getBounds()));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Charte.getMiscellaneous());
            Area a = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            Rectangle r1 = this.node1.getBounds();
            Rectangle r2 = this.node2.getBounds();
            r1.translate(0 - this.getX(), 0 - this.getY());
            r2.translate(0 - this.getX(), 0 - this.getY());
            a.subtract(new Area(r1));
            a.subtract(new Area(r2));
            ((Graphics2D)g).clip(a);
            ((Graphics2D)g).setStroke(new BasicStroke(0.5f, 0, 2));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).drawLine(this.node1.getLocation().x + this.node1.getSize().width / 2 - this.getX(), this.node1.getLocation().y + this.node1.getSize().height / 2 - this.getY(), this.node2.getLocation().x + this.node2.getSize().width / 2 - this.getX(), this.node2.getLocation().y + this.node2.getSize().height / 2 - this.getY());
        }
    }

    class NumberNode
    extends JLabel {
        private int id;

        public NumberNode(int id, int number) {
            super("" + number, 0);
            this.setOpaque(false);
            this.id = id;
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }

        public int getId() {
            return this.id;
        }
    }

    class Node
    extends JPanel {
        private GraphPanel parent;
        private int id;
        private String name;
        private JLabel contenu;
        private Image image;
        private String son;

        public Node(String name, String description, int id, GraphPanel parent) {
            block24: {
                URI uri;
                this.son = "";
                this.contenu = new JLabel("", 0);
                this.id = id;
                this.parent = parent;
                this.name = name;
                this.setLayout(new FlowLayout());
                Charte.formate(this);
                if (name.endsWith("jpg") || name.endsWith("gif") || name.endsWith("png")) {
                    try {
                        uri = new URI(name).normalize();
                        if (uri.getScheme().startsWith("file")) {
                            this.image = new ImageIcon(new File(uri).getAbsolutePath()).getImage();
                            if (this.image.getWidth(this) > 100 || this.image.getHeight(this) > 50) {
                                this.image = this.image.getScaledInstance(100, 50, 4);
                            }
                            break block24;
                        }
                        if (uri.getScheme().startsWith("http")) {
                            this.image = new ImageIcon(uri.toURL()).getImage();
                            if (this.image.getWidth(this) > 100 || this.image.getHeight(this) > 50) {
                                this.image = this.image.getScaledInstance(100, 50, 4);
                            }
                            break block24;
                        }
                        this.image = null;
                    }
                    catch (NullPointerException npe) {
                        this.image = null;
                    }
                    catch (URISyntaxException use) {
                        this.image = null;
                    }
                    catch (MalformedURLException mue) {
                        this.image = null;
                    }
                } else if (name.endsWith("au") || name.endsWith("mid") || name.endsWith("wav")) {
                    try {
                        uri = new URI(name).normalize();
                        this.son = uri.getScheme().startsWith("file") ? new File(uri).getAbsolutePath() : (uri.getScheme().startsWith("http") ? uri.toURL().toString() : "");
                    }
                    catch (NullPointerException npe) {
                        this.son = "";
                    }
                    catch (URISyntaxException use) {
                        this.son = "";
                    }
                    catch (MalformedURLException mue) {
                        this.son = "";
                    }
                }
            }
            if (this.image != null) {
                this.contenu.setIcon(new ImageIcon(this.image));
                this.contenu.setToolTipText("<html><img src=" + name + "></img>");
            } else if (!this.son.equals("")) {
                this.contenu.setIcon(Charte.getIconeSon());
            } else {
                this.contenu.setText(name);
                String[] desc = description.split("\n");
                String ss = "<html>";
                for (int i = 0; i < desc.length; ++i) {
                    String s = "";
                    if (desc[i].length() > 100) {
                        String[] s2 = desc[i].split("\\s");
                        String s3 = "";
                        for (int j = 0; j < s2.length; ++j) {
                            if (s3.length() + s2[j].length() < 100) {
                                s3 = s3 + s2[j] + " ";
                                continue;
                            }
                            s = s + s3 + "<br>";
                            s3 = s2[j] + " ";
                        }
                        s = s + s3;
                    } else {
                        s = desc[i];
                    }
                    ss = ss + s + "<br>";
                }
                this.contenu.setToolTipText(ss);
            }
            this.contenu.setCursor(new Cursor(12));
            this.contenu.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    switch (me.getButton()) {
                        case 1: {
                            Node.this.chosen();
                            break;
                        }
                        default: {
                            Node.this.infos();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    GraphPanel.this.layout.setActive(false);
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    GraphPanel.this.layout.setActive(true);
                }
            });
            this.contenu.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    Node.this.translate(me.getX() - Node.this.getSize().width / 2, me.getY() - Node.this.getSize().height / 2);
                }
            });
            this.add(this.contenu);
        }

        public int getLineCount() {
            return 1;
        }

        protected void translate(int px, int py) {
            int i;
            int x1 = this.getLocation().x + px;
            int y1 = this.getLocation().y + py;
            this.setLocation(x1, y1);
            for (i = 0; i < GraphPanel.this.crown1.length; ++i) {
                if (!GraphPanel.this.isInCrownOf(this, GraphPanel.this.crown1[i])) continue;
                GraphPanel.this.crown1[i].translate2(px, py);
            }
            for (i = 0; i < GraphPanel.this.crown2.length; ++i) {
                if (!GraphPanel.this.isInCrownOf(this, GraphPanel.this.crown2[i])) continue;
                GraphPanel.this.crown2[i].translate2(px, py);
            }
        }

        protected void translate2(int px, int py) {
            int x1 = this.getLocation().x + px;
            int y1 = this.getLocation().y + py;
            this.setLocation(x1, y1);
        }

        public void setFontSize(int fontSize) {
            this.contenu.setFont(this.getFont().deriveFont((float)fontSize));
        }

        public void setBold() {
            this.contenu.setFont(this.getFont().deriveFont(1));
        }

        public int getId() {
            return this.id;
        }

        protected void chosen() {
            EventHandler.notifyEvent(1000 + GraphPanel.this.idG, this.name);
        }

        protected void infos() {
            this.parent.getInfos(this.contenu.getText());
        }
    }
}

