/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.townto.GraphPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class ForceDirectedLayout
implements LayoutManager {
    private boolean termine = false;
    private boolean commence = false;
    private static final int K = 1;
    private static final int Q = 200;
    private static final int S = 1;
    private static final int D0 = 50;

    public void invalidate() {
        this.termine = false;
    }

    public void setActive(boolean b) {
        this.termine = b;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int x = 0;
        int y = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            int nx = parent.getComponent(i).getX() + parent.getComponent(i).getWidth();
            int ny = parent.getComponent(i).getY() + parent.getComponent(i).getHeight();
            if (nx > x) {
                x = nx;
            }
            if (ny <= y) continue;
            y = ny;
        }
        return new Dimension(x, y);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!this.termine) {
            if (this.commence) {
                this.iteration((GraphPanel)parent);
            } else {
                this.demarrage((GraphPanel)parent);
            }
        }
    }

    private void demarrage(GraphPanel component) {
        GraphPanel.Node[] liste = component.getAllNodesSorted();
        for (int i = 0; i < liste.length; ++i) {
            liste[i].setLocation(1 / 2 + i, 2 / 2 + i);
        }
        this.commence = true;
    }

    private void iteration(GraphPanel component) {
        GraphPanel.Node[] liste = component.getAllNodesSorted();
        Dimension[] repulsion = new Dimension[liste.length];
        for (int i = 0; i < liste.length; ++i) {
            repulsion[i] = new Dimension(0, 0);
            for (int j = 0; j < liste.length; ++j) {
                Dimension rep = this.getRepulsion(liste[i], liste[j]);
                repulsion[i].setSize(repulsion[i].getWidth() + rep.getWidth(), repulsion[i].getHeight() + rep.getHeight());
            }
        }
        int energie = 0;
        for (int i = 0; i < repulsion.length; ++i) {
            energie = (int)((double)energie + Math.sqrt(repulsion[i].width * repulsion[i].width + repulsion[i].height * repulsion[i].height));
        }
        if (energie < 2 * liste.length) {
            this.termine = true;
        }
    }

    private Dimension getRepulsion(JComponent c1, JComponent c2) {
        double distanceX = c2.getX() - c1.getX();
        double distanceY = c2.getY() - c1.getY();
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        double force = 40000.0 / (distance * distance);
        int forceX = (int)(force * (distanceX / distance));
        int forceY = (int)(force * (distanceY / distance));
        return new Dimension(forceX, forceY);
    }

    private Dimension getAttraction(JComponent c1, JComponent c2) {
        double distanceX = c2.getX() - c1.getX();
        double distanceY = c2.getY() - c1.getY();
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        double force = -1.0 * (distance - 50.0);
        int forceX = (int)(force * (distanceX / distance));
        int forceY = (int)(force * (distanceY / distance));
        return new Dimension(forceX, forceY);
    }
}

