/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class FixedParagraphView
extends ParagraphView {
    public FixedParagraphView(Element elem) {
        super(elem);
        this.strategy = new FixedFlowStrategy();
    }

    @Override
    protected View createRow() {
        Element elem = this.getElement();
        return new FixedRow(elem);
    }

    protected static int getSpaceCount(String content) {
        int result = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            ++result;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    protected static int[] getSpaceIndexes(String content, int shift) {
        int cnt = FixedParagraphView.getSpaceCount(content);
        int[] result = new int[cnt];
        int counter = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            result[counter] = index + shift;
            ++counter;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    @Override
    public int getFlowSpan(int index) {
        int span = super.getFlowSpan(index);
        if (index == 0) {
            int firstLineIdent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
            span -= firstLineIdent;
        }
        return span;
    }

    @Override
    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
        int firstLineIdent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
        offsets[0] = offsets[0] + firstLineIdent;
    }

    protected static boolean isContainSpace(View v) {
        int startOffset = v.getStartOffset();
        int len = v.getEndOffset() - startOffset;
        try {
            String text = v.getDocument().getText(startOffset, len);
            return text.indexOf(32) >= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    class FixedRow
    extends BoxView {
        private int rowNumber;

        FixedRow(Element elem) {
            super(elem, 0);
            this.rowNumber = 0;
        }

        @Override
        protected void loadChildren(ViewFactory f) {
        }

        @Override
        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        @Override
        public float getAlignment(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                int justification = StyleConstants.getAlignment(attr);
                switch (justification) {
                    case 0: 
                    case 3: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                return super.modelToView(pos, a, b);
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            r = loc.getBounds();
            r.height = height;
            r.y = y;
            return r;
        }

        @Override
        public int getStartOffset() {
            int offs = Integer.MAX_VALUE;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.min(offs, v.getStartOffset());
            }
            return offs;
        }

        @Override
        public int getEndOffset() {
            int offs = 0;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.max(offs, v.getEndOffset());
            }
            return offs;
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        @Override
        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        @Override
        public short getTopInset() {
            return super.getTopInset();
        }

        @Override
        public short getLeftInset() {
            return super.getLeftInset();
        }

        @Override
        public short getRightInset() {
            return super.getRightInset();
        }

        @Override
        public void setInsets(short topInset, short leftInset, short bottomInset, short rightInset) {
            super.setInsets(topInset, leftInset, bottomInset, rightInset);
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            AttributeSet attr = this.getAttributes();
            if (StyleConstants.getAlignment(attr) != 3 && axis != 0) {
                return;
            }
            int cnt = offsets.length;
            int span = 0;
            for (int i = 0; i < cnt; ++i) {
                span += spans[i];
            }
            if (this.getRowNumber() == 0) {
                return;
            }
            int startOffset = this.getStartOffset();
            int len = this.getEndOffset() - startOffset;
            String context = "";
            try {
                context = this.getElement().getDocument().getText(startOffset, len);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int spaceCount = FixedParagraphView.getSpaceCount(context) - 1;
            int pixelsToAdd = targetSpan - span;
            if (this.getRowNumber() == 1) {
                int firstLineIndent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
                pixelsToAdd -= firstLineIndent;
            }
            int[] spaces = this.getSpaces(pixelsToAdd, spaceCount);
            int j = 0;
            int shift = 0;
            for (int i = 1; i < cnt; ++i) {
                LabelView v = (LabelView)this.getView(i);
                int n = i;
                offsets[n] = offsets[n] + shift;
                if (!FixedParagraphView.isContainSpace(v) || i == cnt - 1) continue;
                int n2 = i;
                offsets[n2] = offsets[n2] + spaces[j];
                int n3 = i - 1;
                spans[n3] = spans[n3] + spaces[j];
                shift += spaces[j];
                ++j;
            }
        }

        protected int[] getSpaces(int space, int cnt) {
            int[] result = new int[cnt];
            if (cnt == 0) {
                return result;
            }
            int base = space / cnt;
            int rst = space % cnt;
            for (int i = 0; i < cnt; ++i) {
                result[i] = base;
                if (rst <= 0) continue;
                int n = i;
                result[n] = result[n] + 1;
                --rst;
            }
            return result;
        }

        @Override
        public float getMinimumSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getMinimumSpan(axis);
                }
                return this.getParent().getMinimumSpan(axis);
            }
            return super.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getMaximumSpan(axis);
                }
                return this.getParent().getMaximumSpan(axis);
            }
            return super.getMaximumSpan(axis);
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getPreferredSpan(axis);
                }
                return this.getParent().getPreferredSpan(axis);
            }
            return super.getPreferredSpan(axis);
        }

        public void setRowNumber(int value) {
            this.rowNumber = value;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }
    }

    static class FixedFlowStrategy
    extends FlowView.FlowStrategy {
        FixedFlowStrategy() {
        }

        @Override
        public void layout(FlowView fv) {
            boolean justifiedAlignment;
            super.layout(fv);
            AttributeSet attr = fv.getElement().getAttributes();
            float lineSpacing = StyleConstants.getLineSpacing(attr);
            boolean bl = justifiedAlignment = StyleConstants.getAlignment(attr) == 3;
            if (!justifiedAlignment && !(lineSpacing > 1.0f)) {
                return;
            }
            int cnt = fv.getViewCount();
            for (int i = 0; i < cnt - 1; ++i) {
                float height;
                float addition;
                FixedRow row = (FixedRow)fv.getView(i);
                if (lineSpacing > 1.0f && (addition = (height = row.getMinimumSpan(1)) * lineSpacing - height) > 0.0f) {
                    row.setInsets(row.getTopInset(), row.getLeftInset(), (short)addition, row.getRightInset());
                }
                if (!justifiedAlignment) continue;
                this.restructureRow(row, i);
                row.setRowNumber(i + 1);
            }
        }

        protected void restructureRow(View row, int rowNum) {
            int rowStartOffset = row.getStartOffset();
            int rowEndOffset = row.getEndOffset();
            String rowContent = "";
            try {
                rowContent = row.getDocument().getText(rowStartOffset, rowEndOffset - rowStartOffset);
                if (rowNum == 0) {
                    boolean index = false;
                    while (rowContent.charAt(0) == ' ' && (rowContent = rowContent.substring(1)).length() != 0) {
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int rowSpaceCount = FixedParagraphView.getSpaceCount(rowContent);
            if (rowSpaceCount < 1) {
                return;
            }
            int[] rowSpaceIndexes = FixedParagraphView.getSpaceIndexes(rowContent, row.getStartOffset());
            int currentSpaceIndex = 0;
            for (int i = 0; i < row.getViewCount(); ++i) {
                View child = row.getView(i);
                if (child.getStartOffset() >= rowSpaceIndexes[currentSpaceIndex] || child.getEndOffset() <= rowSpaceIndexes[currentSpaceIndex]) continue;
                View first = child.createFragment(child.getStartOffset(), rowSpaceIndexes[currentSpaceIndex]);
                View second = child.createFragment(rowSpaceIndexes[currentSpaceIndex], child.getEndOffset());
                View[] repl = new View[]{first, second};
                row.replace(i, 1, repl);
                if (++currentSpaceIndex >= rowSpaceIndexes.length) break;
            }
            int childCnt = row.getViewCount();
        }
    }
}

