/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Confrontation;
import data.ListeSynonymes;
import data.TexteCommun;
import ihm.Charte;
import ihm.DialogueAnnotation;
import ihm.FenetrePrincipale;
import ihm.Legende;
import ihm.PanelMotsVides;
import ihm.townto.EventHandler;
import ihm.townto.EventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;

public class PanelSynonymes
extends JTabbedPane
implements EventListener {
    private Legende legende;
    private ListeSynonymes[] suggestionsN;
    private ListeSynonymes[] suggestionsT;
    private ListeSynonymes[] suggestionsP;
    private FenetrePrincipale container;
    private Confrontation confrontation;
    private PanelSynonymes parent;
    private JSplitPane pNoeuds;
    private JSplitPane pTypesLiens;
    private JSplitPane pProprietes;
    private JSlider nbN;
    private JSlider nbT;
    private JSlider nbP;
    private JButton bSuggN;
    private JButton bSuggT;
    private JButton bSuggP;
    private int[] reponses = new int[]{10, 20, 50, 100, Integer.MAX_VALUE};
    private static final int DELAI_RECH_RAPIDE = 500;
    private boolean helpPNoeuds = false;
    private boolean helpPTypesLiens = false;
    private boolean helpPProprietes = false;
    private JList lNTermes = new JList();
    private JList lNSugg = new JList();
    private JList lNSynos = new JList();
    private JScrollPane jspNTermes;
    private JScrollPane jspNSugg;
    private JScrollPane jspNSynos;
    private DropTarget dtN;
    private DropTarget dtN2;
    private JList lTTermes = new JList();
    private JList lTSugg = new JList();
    private JList lTSynos = new JList();
    private JScrollPane jspTTermes;
    private JScrollPane jspTSugg;
    private JScrollPane jspTSynos;
    private DropTarget dtT;
    private DropTarget dtT2;
    private JList lPTermes = new JList();
    private JList lPSugg = new JList();
    private JList lPSynos = new JList();
    private JScrollPane jspPTermes;
    private JScrollPane jspPSugg;
    private JScrollPane jspPSynos;
    private DropTarget dtP;
    private DropTarget dtP2;

    public PanelSynonymes(FenetrePrincipale container, Confrontation confrontation) {
        super(1, 0);
        EventHandler.register(this);
        Charte.formate(this);
        this.parent = this;
        this.legende = new Legende(confrontation.getAllNomsGraphes());
        this.suggestionsN = new ListeSynonymes[0];
        this.suggestionsT = new ListeSynonymes[0];
        this.suggestionsP = new ListeSynonymes[0];
        this.container = container;
        this.confrontation = confrontation;
        this.calculePanelNoeuds();
        this.calculePanelTypesLiens();
        this.calculePanelProprietes();
        this.add(Charte.getMessage("PanelSyno_TabT"), this.pNoeuds);
        this.add(Charte.getMessage("PanelSyno_TabTR"), this.pTypesLiens);
        this.add(Charte.getMessage("PanelSyno_TabP"), this.pProprietes);
        this.add(Charte.getMessage("PanelSyno_TabMV"), new PanelMotsVides(confrontation));
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        this.setOpaque(false);
        this.pNoeuds.setDividerSize(5);
        this.pNoeuds.setDividerLocation(0.5);
        this.pTypesLiens.setDividerSize(5);
        this.pTypesLiens.setDividerLocation(0.5);
        this.pProprietes.setDividerSize(5);
        this.pProprietes.setDividerLocation(0.5);
    }

    private void calculePanelNoeuds() {
        this.pNoeuds = new JSplitPane(0);
        Charte.formate(this.pNoeuds);
        this.pNoeuds.setContinuousLayout(true);
        JSplitPane pSynonymes2 = new JSplitPane(0);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.5);
        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(2);
        labTermes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelSynonymes.this.helpPNoeuds) {
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    PanelSynonymes.this.helpPNoeuds = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrT"));
                    PanelSynonymes.this.helpPNoeuds = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());
        this.jspNTermes = new JScrollPane();
        Charte.formate(this.jspNTermes);
        Charte.formate(this.jspNTermes.getViewport());
        Charte.formate(this.jspNTermes.getHorizontalScrollBar());
        Charte.formate(this.jspNTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add((Component)labTermes, "North");
        pTermes.add((Component)this.jspNTermes, "Center");
        pSynonymes2.setTopComponent(pTermes);
        this.bSuggN = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(this.bSuggN);
        this.bSuggN.setBackground(Color.WHITE);
        this.bSuggN.setBorder(Charte.getBorder());
        JButton bSuggRN = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRN);
        bSuggRN.setBackground(Color.WHITE);
        bSuggRN.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(0, 1, 100, 50);
        Charte.formate(sSeuil);
        Hashtable<Integer, JComponent> termesSeuil = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesSeuil).put(new Integer(1), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_1"), 0)));
        ((Dictionary)termesSeuil).put(new Integer(25), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_25"))));
        ((Dictionary)termesSeuil).put(new Integer(50), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_50"))));
        ((Dictionary)termesSeuil).put(new Integer(75), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_75"))));
        ((Dictionary)termesSeuil).put(new Integer(100), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_100"), 0)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add((Component)lSeuil, "West");
        pSeuil.add((Component)sSeuil, "Center");
        this.nbN = new JSlider(0, 0, 4, 0);
        Charte.formate(this.nbN);
        Hashtable<Integer, JComponent> termesnbN = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesnbN).put(new Integer(0), Charte.format(new JLabel("" + this.reponses[0], 0)));
        ((Dictionary)termesnbN).put(new Integer(1), Charte.format(new JLabel("" + this.reponses[1])));
        ((Dictionary)termesnbN).put(new Integer(2), Charte.format(new JLabel("" + this.reponses[2])));
        ((Dictionary)termesnbN).put(new Integer(3), Charte.format(new JLabel("" + this.reponses[3])));
        ((Dictionary)termesnbN).put(new Integer(4), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Rep_Toutes"), 0)));
        this.nbN.setLabelTable(termesnbN);
        this.nbN.setPaintLabels(true);
        this.nbN.setPaintTicks(true);
        this.nbN.setMajorTickSpacing(1);
        this.nbN.setMinorTickSpacing(1);
        this.nbN.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add((Component)lNRep, "West");
        pNRep.add((Component)this.nbN, "East");
        JPanel pGeneSugg = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add((Component)this.bSuggN, "West");
        JPanel pSlid = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pSlid);
        pSlid.add((Component)pSeuil, "Center");
        pSlid.add((Component)pNRep, "East");
        pGeneSugg.add((Component)pSlid, "Center");
        pGeneSugg.add((Component)bSuggRN, "East");
        Charte.formate(pGeneSugg);
        this.bSuggN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteNoeuds(sSeuil.getValue());
            }
        });
        bSuggRN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteRapideNoeuds(sSeuil.getValue());
            }
        });
        this.jspNSugg = new JScrollPane();
        Charte.formate(this.jspNSugg);
        Charte.formate(this.jspNSugg.getViewport());
        Charte.formate(this.jspNSugg.getHorizontalScrollBar());
        Charte.formate(this.jspNSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add((Component)pGeneSugg, "North");
        pSugg.add((Component)this.jspNSugg, "Center");
        pSynonymes2.setBottomComponent(pSugg);
        this.pNoeuds.setTopComponent(pSynonymes2);
        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"), 0);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add((Component)labSyno, "Center");
        Charte.formate(pSyno);
        this.jspNSynos = new JScrollPane();
        Charte.formate(this.jspNSynos);
        Charte.formate(this.jspNSynos.getViewport());
        Charte.formate(this.jspNSynos.getHorizontalScrollBar());
        Charte.formate(this.jspNSynos.getVerticalScrollBar());
        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add((Component)pSyno, "North");
        pSynos.add((Component)this.jspNSynos, "Center");
        this.pNoeuds.setBottomComponent(pSynos);
        this.refaisListesN();
    }

    private void confronteNoeuds(int pre) {
        this.confrontation.setSeuilNoeuds(0.01 * (double)pre);
        int choix = JOptionPane.showConfirmDialog(this, Charte.getMessage("PanelSyno_WarnTime"), Charte.getMessage("PanelSyno_WarnTimeT"), 0, 3, Charte.getSmiley("dat/img/_cligne.gif"));
        if (choix == 0) {
            new Thread(){

                @Override
                public void run() {
                    PanelSynonymes.this.processusSuggestionSynosN();
                }
            }.start();
            this.bSuggN.setText(Charte.getMessage("PanelSyno_Sugg2"));
            this.bSuggN.setEnabled(false);
        }
    }

    private void calculePanelTypesLiens() {
        this.pTypesLiens = new JSplitPane(0);
        Charte.formate(this.pTypesLiens);
        this.pTypesLiens.setContinuousLayout(true);
        JSplitPane pSynonymes2 = new JSplitPane(0);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.5);
        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(2);
        labTermes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelSynonymes.this.helpPTypesLiens) {
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    PanelSynonymes.this.helpPTypesLiens = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrTR"));
                    PanelSynonymes.this.helpPTypesLiens = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());
        this.jspTTermes = new JScrollPane();
        Charte.formate(this.jspTTermes);
        Charte.formate(this.jspTTermes.getViewport());
        Charte.formate(this.jspTTermes.getHorizontalScrollBar());
        Charte.formate(this.jspTTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add((Component)labTermes, "North");
        pTermes.add((Component)this.jspTTermes, "Center");
        pSynonymes2.setTopComponent(pTermes);
        this.bSuggT = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(this.bSuggT);
        this.bSuggT.setBackground(Color.WHITE);
        this.bSuggT.setBorder(Charte.getBorder());
        JButton bSuggRT = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRT);
        bSuggRT.setBackground(Color.WHITE);
        bSuggRT.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(0, 1, 100, 50);
        Charte.formate(sSeuil);
        Hashtable<Integer, JComponent> termesSeuil = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesSeuil).put(new Integer(1), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_1"), 0)));
        ((Dictionary)termesSeuil).put(new Integer(25), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_25"))));
        ((Dictionary)termesSeuil).put(new Integer(50), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_50"))));
        ((Dictionary)termesSeuil).put(new Integer(75), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_75"))));
        ((Dictionary)termesSeuil).put(new Integer(100), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_100"), 0)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add((Component)lSeuil, "West");
        pSeuil.add((Component)sSeuil, "Center");
        this.nbT = new JSlider(0, 0, 4, 0);
        Charte.formate(this.nbT);
        Hashtable<Integer, JComponent> termesnbT = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesnbT).put(new Integer(0), Charte.format(new JLabel("" + this.reponses[0], 0)));
        ((Dictionary)termesnbT).put(new Integer(1), Charte.format(new JLabel("" + this.reponses[1])));
        ((Dictionary)termesnbT).put(new Integer(2), Charte.format(new JLabel("" + this.reponses[2])));
        ((Dictionary)termesnbT).put(new Integer(3), Charte.format(new JLabel("" + this.reponses[3])));
        ((Dictionary)termesnbT).put(new Integer(4), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Rep_Toutes"), 0)));
        this.nbT.setLabelTable(termesnbT);
        this.nbT.setPaintLabels(true);
        this.nbT.setPaintTicks(true);
        this.nbT.setMajorTickSpacing(1);
        this.nbT.setMinorTickSpacing(1);
        this.nbT.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add((Component)lNRep, "West");
        pNRep.add((Component)this.nbT, "East");
        JPanel pGeneSugg = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add((Component)this.bSuggT, "West");
        JPanel pSlid = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pSlid);
        pSlid.add((Component)pSeuil, "Center");
        pSlid.add((Component)pNRep, "East");
        pGeneSugg.add((Component)pSlid, "Center");
        pGeneSugg.add((Component)bSuggRT, "East");
        Charte.formate(pGeneSugg);
        this.bSuggT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteTypesLiens(sSeuil.getValue());
            }
        });
        bSuggRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteRapideTypesLiens(sSeuil.getValue());
            }
        });
        this.jspTSugg = new JScrollPane();
        Charte.formate(this.jspTSugg);
        Charte.formate(this.jspTSugg.getViewport());
        Charte.formate(this.jspTSugg.getHorizontalScrollBar());
        Charte.formate(this.jspTSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add((Component)pGeneSugg, "North");
        pSugg.add((Component)this.jspTSugg, "Center");
        pSynonymes2.setBottomComponent(pSugg);
        this.pTypesLiens.setTopComponent(pSynonymes2);
        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"), 0);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add((Component)labSyno, "Center");
        Charte.formate(pSyno);
        this.jspTSynos = new JScrollPane();
        Charte.formate(this.jspTSynos);
        Charte.formate(this.jspTSynos.getViewport());
        Charte.formate(this.jspTSynos.getHorizontalScrollBar());
        Charte.formate(this.jspTSynos.getVerticalScrollBar());
        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add((Component)pSyno, "North");
        pSynos.add((Component)this.jspTSynos, "Center");
        this.pTypesLiens.setBottomComponent(pSynos);
        this.refaisListesT();
    }

    private void confronteTypesLiens(int pre) {
        this.confrontation.setSeuilNoeuds(0.01 * (double)pre);
        int choix = JOptionPane.showConfirmDialog(this, Charte.getMessage("PanelSyno_WarnTime"), Charte.getMessage("PanelSyno_WarnTimeT"), 0, 3, Charte.getSmiley("dat/img/_cligne.gif"));
        if (choix == 0) {
            new Thread(){

                @Override
                public void run() {
                    PanelSynonymes.this.processusSuggestionSynosT();
                }
            }.start();
            this.bSuggT.setText(Charte.getMessage("PanelSyno_Sugg2"));
            this.bSuggT.setEnabled(false);
        }
    }

    private void calculePanelProprietes() {
        this.pProprietes = new JSplitPane(0);
        Charte.formate(this.pProprietes);
        this.pProprietes.setContinuousLayout(true);
        JSplitPane pSynonymes2 = new JSplitPane(0);
        Charte.formate(pSynonymes2);
        pSynonymes2.setContinuousLayout(true);
        pSynonymes2.setDividerSize(5);
        pSynonymes2.setDividerLocation(0.5);
        final JButton labTermes = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes);
        labTermes.setHorizontalAlignment(2);
        labTermes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelSynonymes.this.helpPProprietes) {
                    labTermes.setText(Charte.getMessage("Panel_InstrB"));
                    PanelSynonymes.this.helpPProprietes = false;
                } else {
                    labTermes.setText(Charte.getMessage("PanelSyno_InstrP"));
                    PanelSynonymes.this.helpPProprietes = true;
                }
            }
        });
        labTermes.setBorder(Charte.getBorder());
        this.jspPTermes = new JScrollPane();
        Charte.formate(this.jspPTermes);
        Charte.formate(this.jspPTermes.getViewport());
        Charte.formate(this.jspPTermes.getHorizontalScrollBar());
        Charte.formate(this.jspPTermes.getVerticalScrollBar());
        JPanel pTermes = new JPanel(new BorderLayout());
        Charte.formate(pTermes);
        pTermes.setBorder(Charte.getBorder());
        pTermes.add((Component)labTermes, "North");
        pTermes.add((Component)this.jspPTermes, "Center");
        pSynonymes2.setTopComponent(pTermes);
        this.bSuggP = new JButton(Charte.getMessage("PanelSyno_Sugg"));
        Charte.formate(this.bSuggP);
        this.bSuggP.setBackground(Color.WHITE);
        this.bSuggP.setBorder(Charte.getBorder());
        JButton bSuggRP = new JButton(Charte.getMessage("PanelSyno_SuggR"));
        Charte.formate(bSuggRP);
        bSuggRP.setBackground(Color.WHITE);
        bSuggRP.setBorder(Charte.getBorder());
        final JSlider sSeuil = new JSlider(0, 1, 100, 50);
        Charte.formate(sSeuil);
        Hashtable<Integer, JComponent> termesSeuil = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesSeuil).put(new Integer(1), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_1"), 0)));
        ((Dictionary)termesSeuil).put(new Integer(25), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_25"))));
        ((Dictionary)termesSeuil).put(new Integer(50), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_50"))));
        ((Dictionary)termesSeuil).put(new Integer(75), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_75"))));
        ((Dictionary)termesSeuil).put(new Integer(100), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Sug_100"), 0)));
        sSeuil.setLabelTable(termesSeuil);
        sSeuil.setPaintLabels(true);
        sSeuil.setPaintTicks(true);
        sSeuil.setMajorTickSpacing(25);
        sSeuil.setMinorTickSpacing(5);
        sSeuil.setSnapToTicks(false);
        JLabel lSeuil = new JLabel(Charte.getMessage("PanelSyno_TxtPre"));
        JPanel pSeuil = new JPanel(new BorderLayout());
        pSeuil.add((Component)lSeuil, "West");
        pSeuil.add((Component)sSeuil, "Center");
        this.nbP = new JSlider(0, 0, 4, 0);
        Charte.formate(this.nbP);
        Hashtable<Integer, JComponent> termesnbP = new Hashtable<Integer, JComponent>(5);
        ((Dictionary)termesnbP).put(new Integer(0), Charte.format(new JLabel("" + this.reponses[0], 0)));
        ((Dictionary)termesnbP).put(new Integer(1), Charte.format(new JLabel("" + this.reponses[1])));
        ((Dictionary)termesnbP).put(new Integer(2), Charte.format(new JLabel("" + this.reponses[2])));
        ((Dictionary)termesnbP).put(new Integer(3), Charte.format(new JLabel("" + this.reponses[3])));
        ((Dictionary)termesnbP).put(new Integer(4), Charte.format(new JLabel(Charte.getMessage("PanelSyno_Rep_Toutes"), 0)));
        this.nbP.setLabelTable(termesnbP);
        this.nbP.setPaintLabels(true);
        this.nbP.setPaintTicks(true);
        this.nbP.setMajorTickSpacing(1);
        this.nbP.setMinorTickSpacing(1);
        this.nbP.setSnapToTicks(true);
        JLabel lNRep = new JLabel(Charte.getMessage("PanelSyno_TxtQt"));
        JPanel pNRep = new JPanel(new BorderLayout());
        pNRep.add((Component)lNRep, "West");
        pNRep.add((Component)this.nbP, "East");
        JPanel pGeneSugg = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pGeneSugg);
        pGeneSugg.add((Component)this.bSuggP, "West");
        JPanel pSlid = new JPanel(new BorderLayout(50, 0));
        Charte.formate(pSlid);
        pSlid.add((Component)pSeuil, "Center");
        pSlid.add((Component)pNRep, "East");
        pGeneSugg.add((Component)pSlid, "Center");
        pGeneSugg.add((Component)bSuggRP, "East");
        Charte.formate(pGeneSugg);
        this.bSuggP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteProprietes(sSeuil.getValue());
            }
        });
        bSuggRP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PanelSynonymes.this.confronteRapideProprietes(sSeuil.getValue());
            }
        });
        this.jspPSugg = new JScrollPane();
        Charte.formate(this.jspPSugg);
        Charte.formate(this.jspPSugg.getViewport());
        Charte.formate(this.jspPSugg.getHorizontalScrollBar());
        Charte.formate(this.jspPSugg.getVerticalScrollBar());
        JPanel pSugg = new JPanel(new BorderLayout());
        Charte.formate(pSugg);
        pSugg.setBorder(Charte.getBorder());
        pSugg.add((Component)pGeneSugg, "North");
        pSugg.add((Component)this.jspPSugg, "Center");
        pSynonymes2.setBottomComponent(pSugg);
        this.pProprietes.setTopComponent(pSynonymes2);
        JLabel labSyno = new JLabel(Charte.getMessage("PanelSyno_TxtTiss"), 0);
        Charte.formate(labSyno);
        labSyno.setBorder(Charte.getBorder());
        JPanel pSyno = new JPanel(new BorderLayout());
        pSyno.add((Component)labSyno, "Center");
        Charte.formate(pSyno);
        this.jspPSynos = new JScrollPane();
        Charte.formate(this.jspPSynos);
        Charte.formate(this.jspPSynos.getViewport());
        Charte.formate(this.jspPSynos.getHorizontalScrollBar());
        Charte.formate(this.jspPSynos.getVerticalScrollBar());
        JPanel pSynos = new JPanel(new BorderLayout());
        Charte.formate(pSynos);
        pSynos.setBorder(Charte.getBorder());
        pSynos.add((Component)pSyno, "North");
        pSynos.add((Component)this.jspPSynos, "Center");
        this.pProprietes.setBottomComponent(pSynos);
        this.refaisListesP();
    }

    private void confronteProprietes(int pre) {
        this.confrontation.setSeuilNoeuds(0.01 * (double)pre);
        int choix = JOptionPane.showConfirmDialog(this, Charte.getMessage("PanelSyno_WarnTime"), Charte.getMessage("PanelSyno_WarnTimeT"), 0, 3, Charte.getSmiley("dat/img/_cligne.gif"));
        if (choix == 0) {
            new Thread(){

                @Override
                public void run() {
                    PanelSynonymes.this.processusSuggestionSynosP();
                }
            }.start();
            this.bSuggP.setText(Charte.getMessage("PanelSyno_Sugg2"));
            this.bSuggP.setEnabled(false);
        }
    }

    private void refaisListesN() {
        int sel = this.lNTermes.getSelectedIndex();
        this.lNTermes = new JList<TexteCommun>(this.confrontation.getAllTermesNoeuds());
        Charte.formate(this.lNTermes);
        this.lNTermes.setDragEnabled(true);
        this.lNTermes.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelSynonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspNTermes.setViewportView(this.lNTermes);
        this.lNTermes.ensureIndexIsVisible(sel);
        sel = this.lNSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[Math.min(this.suggestionsN.length, this.reponses[this.nbN.getValue()])];
        for (int i = 0; i < l0.length; ++i) {
            l0[i] = this.suggestionsN[i];
        }
        this.lNSugg = new JList<ListeSynonymes>(l0);
        Charte.formate(this.lNSugg);
        this.lNSugg.setDragEnabled(true);
        this.lNSugg.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        this.jspNSugg.setViewportView(this.lNSugg);
        this.lNSugg.ensureIndexIsVisible(sel);
        sel = this.lNSynos.getSelectedIndex();
        this.lNSynos = new JList<ListeSynonymes>(this.confrontation.getListesSynonymesNoeuds());
        Charte.formate(this.lNSynos);
        this.lNSynos.setDragEnabled(true);
        this.lNSynos.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if (i >= l.getListe().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    res.add(lab3);
                }
                JLabel res4 = new JLabel("{" + l.getLien() + "}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>" + l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        this.jspNSynos.setViewportView(this.lNSynos);
        this.lNSynos.ensureIndexIsVisible(sel);
        this.dtN = new DropTarget(this.lNSynos, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if ((res.length > 1 || res[0].indexOf(";") > -1) && res[0].indexOf("{") == -1) {
                        if (res[0].indexOf(";") > -1) {
                            for (int i = 0; i < res.length; ++i) {
                                System.out.println(res[i]);
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + res[i], PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    PanelSynonymes.this.confrontation.addSynonymesNoeuds(res[i], d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(5000, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; ++i) {
                                s = s + res[i];
                                if (i >= res.length - 1) continue;
                                s = s + ";";
                            }
                            DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + s, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                PanelSynonymes.this.confrontation.addSynonymesNoeuds(s, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                        }
                        PanelSynonymes.this.refaisListesN();
                    } else if (res.length == 1 && res[0].indexOf(";") == -1) {
                        JOptionPane.showMessageDialog(PanelSynonymes.this.container, Charte.getMessage("PanelSyno_WarnSingle"), Charte.getMessage("PanelSyno_WarnSingleT"), 0, Charte.getSmiley("dat/img/_mouais.gif"));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{") + 1, res[0].indexOf("}"));
                        if (rais.startsWith("S\u00fbr \u00e0")) {
                            for (int i = 0; i < res.length; ++i) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + synos, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (d.isAnnule()) continue;
                                PanelSynonymes.this.confrontation.addSynonymesNoeuds(synos, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                            PanelSynonymes.this.refaisListesN();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtN2 = new DropTarget(this.lNTermes, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    for (int i = 0; i < res.length; ++i) {
                        PanelSynonymes.this.confrontation.removeSynonymesNoeuds(res[i].split("\\{")[0].trim());
                    }
                    EventHandler.notifyEvent(5000, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void refaisListesT() {
        int sel = this.lTTermes.getSelectedIndex();
        this.lTTermes = new JList<TexteCommun>(this.confrontation.getAllTermesTypesLiens());
        Charte.formate(this.lTTermes);
        this.lTTermes.setDragEnabled(true);
        this.lTTermes.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelSynonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspTTermes.setViewportView(this.lTTermes);
        this.lTTermes.ensureIndexIsVisible(sel);
        sel = this.lTSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[Math.min(this.suggestionsT.length, this.reponses[this.nbT.getValue()])];
        for (int i = 0; i < l0.length; ++i) {
            l0[i] = this.suggestionsT[i];
        }
        this.lTSugg = new JList<ListeSynonymes>(l0);
        Charte.formate(this.lTSugg);
        this.lTSugg.setDragEnabled(true);
        this.lTSugg.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        this.jspTSugg.setViewportView(this.lTSugg);
        this.lTSugg.ensureIndexIsVisible(sel);
        sel = this.lTSynos.getSelectedIndex();
        this.lTSynos = new JList<ListeSynonymes>(this.confrontation.getListesSynonymesTypesLiens());
        Charte.formate(this.lTSynos);
        this.lTSynos.setDragEnabled(true);
        this.lTSynos.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if (i >= l.getListe().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    res.add(lab3);
                }
                JLabel res4 = new JLabel("{" + l.getLien() + "}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>" + l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        this.jspTSynos.setViewportView(this.lTSynos);
        this.lTSynos.ensureIndexIsVisible(sel);
        this.dtT = new DropTarget(this.lTSynos, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if ((res.length > 1 || res[0].indexOf(";") > -1) && res[0].indexOf("{") == -1) {
                        if (res[0].indexOf(";") > -1) {
                            for (int i = 0; i < res.length; ++i) {
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + res[i], PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    PanelSynonymes.this.confrontation.addSynonymesTypesLiens(res[i], d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(5000, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; ++i) {
                                s = s + res[i];
                                if (i >= res.length - 1) continue;
                                s = s + ";";
                            }
                            DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + s, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                PanelSynonymes.this.confrontation.addSynonymesTypesLiens(s, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                        }
                        PanelSynonymes.this.refaisListesT();
                    } else if (res.length == 1 && res[0].indexOf(";") == -1) {
                        JOptionPane.showMessageDialog(PanelSynonymes.this.container, Charte.getMessage("PanelSyno_WarnSingle"), Charte.getMessage("PanelSyno_WarnSingleT"), 0, Charte.getSmiley("dat/img/_mouais.gif"));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{") + 1, res[0].indexOf("}"));
                        if (rais.startsWith("S\u00fbr \u00e0")) {
                            for (int i = 0; i < res.length; ++i) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + synos, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (d.isAnnule()) continue;
                                PanelSynonymes.this.confrontation.addSynonymesTypesLiens(synos, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                            PanelSynonymes.this.refaisListesT();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtT2 = new DropTarget(this.lTTermes, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    for (int i = 0; i < res.length; ++i) {
                        PanelSynonymes.this.confrontation.removeSynonymesTypesLiens(res[i].split("\\{")[0]);
                    }
                    EventHandler.notifyEvent(5000, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void refaisListesP() {
        int sel = this.lPTermes.getSelectedIndex();
        this.lPTermes = new JList<TexteCommun>(this.confrontation.getAllTermesProprietes());
        Charte.formate(this.lPTermes);
        this.lPTermes.setDragEnabled(true);
        this.lPTermes.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelSynonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspPTermes.setViewportView(this.lPTermes);
        this.lPTermes.ensureIndexIsVisible(sel);
        sel = this.lPSugg.getSelectedIndex();
        ListeSynonymes[] l0 = new ListeSynonymes[Math.min(this.suggestionsP.length, this.reponses[this.nbP.getValue()])];
        for (int i = 0; i < l0.length; ++i) {
            l0[i] = this.suggestionsP[i];
        }
        this.lPSugg = new JList<ListeSynonymes>(l0);
        Charte.formate(this.lPSugg);
        this.lPSugg.setDragEnabled(true);
        this.lPSugg.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                }
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        this.jspPSugg.setViewportView(this.lPSugg);
        this.lPSugg.ensureIndexIsVisible(sel);
        sel = this.lPSynos.getSelectedIndex();
        this.lPSynos = new JList<ListeSynonymes>(this.confrontation.getListesSynonymesProprietes());
        Charte.formate(this.lPSynos);
        this.lPSynos.setDragEnabled(true);
        this.lPSynos.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelSynonymes.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if (i >= l.getListe().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    res.add(lab3);
                }
                JLabel res4 = new JLabel("{" + l.getLien() + "}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                res.setToolTipText("<html>" + l.getCommentaire().replaceAll("\\n", "<br>"));
                return res;
            }
        });
        this.jspPSynos.setViewportView(this.lPSynos);
        this.lPSynos.ensureIndexIsVisible(sel);
        this.dtP = new DropTarget(this.lPSynos, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if ((res.length > 1 || res[0].indexOf(";") > -1) && res[0].indexOf("{") == -1) {
                        if (res[0].indexOf(";") > -1) {
                            for (int i = 0; i < res.length; ++i) {
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + res[i], PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (!d.isAnnule()) {
                                    PanelSynonymes.this.confrontation.addSynonymesProprietes(res[i], d.getChoix(), d.getCommentaires());
                                }
                                EventHandler.notifyEvent(5000, "");
                            }
                        } else {
                            String s = "";
                            for (int i = 0; i < res.length; ++i) {
                                s = s + res[i];
                                if (i >= res.length - 1) continue;
                                s = s + ";";
                            }
                            DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + s, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                            d.setVisible(true);
                            if (!d.isAnnule()) {
                                PanelSynonymes.this.confrontation.addSynonymesProprietes(s, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                        }
                        PanelSynonymes.this.refaisListesP();
                    } else if (res.length == 1 && res[0].indexOf(";") == -1) {
                        JOptionPane.showMessageDialog(PanelSynonymes.this.container, Charte.getMessage("PanelSyno_WarnSingle"), Charte.getMessage("PanelSyno_WarnSingleT"), 0, Charte.getSmiley("dat/img/_mouais.gif"));
                    } else {
                        String rais = res[0].substring(res[0].indexOf("{") + 1, res[0].indexOf("}"));
                        if (rais.startsWith("S\u00fbr \u00e0")) {
                            for (int i = 0; i < res.length; ++i) {
                                String synos = res[i].substring(0, res[i].indexOf("{"));
                                DialogueAnnotation d = new DialogueAnnotation(PanelSynonymes.this.parent, Charte.getMessage("PanelSyno_Justification") + synos, PanelSynonymes.this.confrontation.getRaisonsRapprocher());
                                d.setVisible(true);
                                if (d.isAnnule()) continue;
                                PanelSynonymes.this.confrontation.addSynonymesProprietes(synos, d.getChoix(), d.getCommentaires());
                            }
                            EventHandler.notifyEvent(5000, "");
                            PanelSynonymes.this.refaisListesP();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtP2 = new DropTarget(this.lPTermes, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    for (int i = 0; i < res.length; ++i) {
                        PanelSynonymes.this.confrontation.removeSynonymesProprietes(res[i].split("\\{")[0]);
                    }
                    EventHandler.notifyEvent(5000, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void processusSuggestionSynosN() {
        this.suggestionsN = this.confrontation.suggereNoeudsSynonymes();
        this.refaisListesN();
        this.bSuggN.setEnabled(true);
        this.bSuggN.setText(Charte.getMessage("PanelSyno_Sugg"));
    }

    private void confronteRapideNoeuds(int pre) {
        this.confrontation.setSeuilNoeuds(0.01 * (double)pre);
        this.suggestionsN = this.confrontation.suggereNoeudsSynonymes(500);
        this.refaisListesN();
    }

    private void processusSuggestionSynosT() {
        this.suggestionsT = this.confrontation.suggereTypesLiensSynonymes();
        this.refaisListesT();
        this.bSuggT.setEnabled(true);
        this.bSuggT.setText(Charte.getMessage("PanelSyno_Sugg"));
    }

    private void confronteRapideTypesLiens(int pre) {
        this.confrontation.setSeuilTypesLiens(0.01 * (double)pre);
        this.suggestionsT = this.confrontation.suggereTypesLiensSynonymes(500);
        this.refaisListesT();
    }

    private void processusSuggestionSynosP() {
        this.suggestionsP = this.confrontation.suggereProprietesSynonymes();
        this.refaisListesP();
        this.bSuggP.setEnabled(true);
        this.bSuggP.setText(Charte.getMessage("PanelSyno_Sugg"));
    }

    private void confronteRapideProprietes(int pre) {
        this.confrontation.setSeuilProprietes(0.01 * (double)pre);
        this.suggestionsP = this.confrontation.suggereProprietesSynonymes(500);
        this.refaisListesP();
    }

    @Override
    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode == 5000) {
            this.refaisListesN();
            this.refaisListesT();
            this.refaisListesP();
        }
    }
}

