/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import ihm.Charte;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Legende
extends JPanel {
    private final Color[] colors = new Color[]{new Color(0, 0, 255, 192), new Color(255, 0, 0, 192), new Color(0, 255, 0, 192), new Color(255, 255, 0, 192), new Color(128, 0, 255, 192), new Color(0, 0, 0, 192), new Color(0, 255, 255, 192), new Color(255, 128, 0, 192), new Color(255, 0, 255, 192), new Color(255, 128, 128, 192), new Color(255, 255, 255, 192), new Color(0, 0, 128, 192), new Color(255, 255, 128, 192), new Color(128, 255, 255, 192), new Color(0, 128, 0, 192), new Color(128, 0, 0, 192), new Color(255, 128, 255, 192), new Color(128, 128, 128, 192), new Color(128, 128, 0, 192), new Color(128, 0, 128, 192), new Color(0, 255, 128, 192), new Color(128, 255, 0, 192), new Color(0, 128, 128, 192), new Color(255, 0, 128, 192), new Color(128, 255, 128, 192), new Color(0, 128, 255, 192)};
    private String[] noms;

    public Legende(int nbPV) {
        int i;
        this.noms = new String[nbPV];
        for (i = 0; i < this.noms.length; ++i) {
            this.noms[i] = "";
        }
        for (i = 0; i < this.noms.length; ++i) {
            final int j = i;
            JLabel couleur = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension((Charte.getFont().getSize() + 1) / 2 * 3, (Charte.getFont().getSize() + 1) / 2 * 2);
                }

                @Override
                public void paint(Graphics g) {
                    g.setColor(Legende.this.colors[j % Legende.this.colors.length]);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
            Charte.formate(couleur);
            JLabel nom = new JLabel(this.noms[i], 2);
            Charte.formate(nom);
            JPanel p = new JPanel(new BorderLayout());
            Charte.formate(p);
            p.add((Component)couleur, "West");
            p.add((Component)nom, "Center");
            this.add(p);
        }
    }

    public Legende(String[] noms) {
        this.setLayout(new GridLayout(noms.length, 1));
        this.noms = noms;
        for (int i = 0; i < noms.length; ++i) {
            final int j = i;
            JLabel couleur = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension((Charte.getFont().getSize() + 1) / 2 * 3, (Charte.getFont().getSize() + 1) / 2 * 2);
                }

                @Override
                public void paint(Graphics g) {
                    g.setColor(Legende.this.colors[j % Legende.this.colors.length]);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
            Charte.formate(couleur);
            JLabel nom = new JLabel(noms[i], 2);
            Charte.formate(nom);
            JPanel p = new JPanel(new BorderLayout());
            Charte.formate(p);
            p.add((Component)couleur, "West");
            p.add((Component)nom, "Center");
            this.add(p);
        }
    }

    public JLabel getClasseur(boolean[] valeurs) {
        if (valeurs.length != this.noms.length) {
            throw new IllegalArgumentException();
        }
        return new Classeur(valeurs);
    }

    public JComponent getLegendeTextuelle() {
        int i;
        JPanel resultat = new JPanel();
        Charte.formate(resultat);
        int dX = Math.min(this.noms.length, this.colors.length / 2);
        int dY = (int)Math.ceil(1.0 * (double)this.noms.length / (double)dX);
        resultat.setLayout(new GridLayout(dY, dX, 5, 5));
        for (i = 0; i < this.noms.length; ++i) {
            JLabel img = this.getIndicateur(i);
            Charte.formate(img);
            JLabel txt = new JLabel(this.noms[i]);
            Charte.formate(txt);
            JPanel p = new JPanel(new BorderLayout());
            Charte.formate(p);
            p.add((Component)img, "West");
            p.add((Component)txt, "Center");
            resultat.add(p);
        }
        for (i = this.noms.length; i < dX * dY; ++i) {
            resultat.add(Charte.format(new JLabel("")));
        }
        resultat.setBorder(Charte.getBorder());
        return resultat;
    }

    public JLabel getIndicateur(int index) {
        if (index > this.noms.length) {
            throw new IllegalArgumentException();
        }
        return new JLabel(this.getIconeIndicateur(index));
    }

    public Icon getIconeIndicateur(int index) {
        BufferedImage im = new BufferedImage((Charte.getFont().getSize() + 1) / 2, (Charte.getFont().getSize() + 1) / 2 * 2, 2);
        Graphics g = im.getGraphics();
        g.setColor(this.colors[index % this.colors.length]);
        g.fillRect(0, 0, (Charte.getFont().getSize() + 1) / 2, (Charte.getFont().getSize() + 1) / 2 * 2);
        return new ImageIcon(im);
    }

    private class Classeur
    extends JLabel {
        private boolean[] valeurs;

        public Classeur(boolean[] valeurs) {
            this.valeurs = valeurs;
        }

        @Override
        public Dimension getPreferredSize() {
            int d0 = Math.max((Charte.getFont().getSize() + 1) / 2, 8);
            int dX = Math.min(this.valeurs.length, Legende.this.colors.length / 2);
            int dY = (int)Math.ceil(1.0 * (double)this.valeurs.length / (double)dX);
            int dimX = d0 * dX + 4;
            int dimY = d0 * dY + 4;
            return new Dimension(dimX, dimY);
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int d0 = Math.max((Charte.getFont().getSize() + 1) / 2, 8);
            int dX = Math.min(this.valeurs.length, Legende.this.colors.length / 2);
            int dY = (int)Math.ceil(1.0 * (double)this.valeurs.length / (double)dX);
            int dimX = d0 * dX;
            int dimY = d0 * dY;
            int dx = (w - dimX) / 2;
            int dy = (h - dimY) / 2;
            for (int i = 0; i < this.valeurs.length; ++i) {
                if (!this.valeurs[i]) continue;
                int x = d0 * (i % dX);
                int y = d0 * (i / dX);
                g.setColor(Legende.this.colors[i % Legende.this.colors.length]);
                g.fillRect(dx + x, dy + y, d0, d0);
            }
            Charte.getBorder().paintBorder(this, g, dx - 2, dy - 2, dimX + 4, dimY + 4);
        }
    }
}

