/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Chargeur;
import data.Confrontation;
import data.Graphe;
import data.ImportException;
import ihm.Charte;
import ihm.FenetreInit;
import ihm.PanelConfrontation;
import ihm.PanelHomonymes;
import ihm.PanelNotes;
import ihm.PanelSynonymes;
import ihm.PanelVisualisation;
import ihm.townto.EventHandler;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class FenetrePrincipale
extends JFrame {
    private int w;
    private int h;
    private JProgressBar enCours;
    private JDialog dEnCours;
    private JLabel lFond;
    private JPanel pConfs;
    private JComponent cConf;
    private JButton bAdd;
    private JButton bSuppr;
    private JButton bPhoto;
    private JButton bSave;
    private Confrontation confrontation;
    private String nom;
    private String dossier;
    private static final String AUTRE = Charte.getMessage("MainFrame_Autre");
    private boolean saved;
    private int photoX0;
    private int photoY0;
    private int photoX1;
    private int photoY1;
    private int stade;
    private MouseAdapter mouse;
    private MouseMotionAdapter mouseM;
    private BufferedImage image;
    private JPanel glassPane;

    public FenetrePrincipale(FenetreInit f) {
        this.w = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.h = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.nom = "";
        this.dossier = "";
        this.saved = false;
        this.photoX0 = 0;
        this.photoY0 = 0;
        this.photoX1 = 0;
        this.photoY1 = 0;
        this.stade = 0;
        this.mouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (FenetrePrincipale.this.stade == 0) {
                    FenetrePrincipale.this.photoX0 = me.getX();
                    FenetrePrincipale.this.photoY0 = me.getY();
                    FenetrePrincipale.this.stade = 1;
                } else {
                    FenetrePrincipale.this.photoX1 = me.getX();
                    FenetrePrincipale.this.photoY1 = me.getY();
                    FenetrePrincipale.this.photoFinie();
                }
            }
        };
        this.mouseM = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                if (FenetrePrincipale.this.stade == 1) {
                    FenetrePrincipale.this.photoX1 = me.getX();
                    FenetrePrincipale.this.photoY1 = me.getY();
                    FenetrePrincipale.this.glassPane.repaint();
                }
            }
        };
        this.glassPane = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (FenetrePrincipale.this.stade == 1) {
                    g.setColor(Charte.getForeground());
                    g.drawRect(Math.min(FenetrePrincipale.this.photoX0, FenetrePrincipale.this.photoX1) - 1, Math.min(FenetrePrincipale.this.photoY0, FenetrePrincipale.this.photoY1) - 1, Math.abs(FenetrePrincipale.this.photoX1 - FenetrePrincipale.this.photoX0) + 1, Math.abs(FenetrePrincipale.this.photoY1 - FenetrePrincipale.this.photoY0) + 1);
                }
            }
        };
        this.w = this.getToolkit().getScreenSize().width;
        this.setSize(this.w, this.h - 1);
        this.setTitle("ArcEnCiel v" + Charte.getVersion() + " ");
        this.setUndecorated(true);
        this.getContentPane().setLayout(null);
        this.lFond = new JLabel(Charte.getImage());
        this.lFond.setBackground(Color.WHITE);
        this.lFond.setSize(this.w, this.h - 1);
        this.glassPane.setOpaque(false);
        this.setGlassPane(this.glassPane);
        this.glassPane.addMouseListener(this.mouse);
        this.glassPane.addMouseMotionListener(this.mouseM);
        this.enCours = new JProgressBar(0);
        this.enCours.setIndeterminate(true);
        this.enCours.setString(Charte.getMessage("MainFrame_MsgEnCours"));
        this.enCours.setStringPainted(true);
        this.dEnCours = new JDialog((Frame)this, true);
        this.dEnCours.setUndecorated(true);
        this.dEnCours.getContentPane().setLayout(new GridLayout(1, 1));
        this.dEnCours.getContentPane().add(this.enCours);
        this.dEnCours.pack();
        this.dEnCours.setLocation(this.getSize().width / 2 - this.dEnCours.getSize().width / 2, this.getSize().height / 2 - this.dEnCours.getSize().height / 2);
        JButton bRed = new JButton(Charte.getMessage("MainFrame_Reduire"));
        bRed.setOpaque(false);
        bRed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.setExtendedState(1);
            }
        });
        bRed.setToolTipText(Charte.getMessage("MainFrame_ReduireTT"));
        bRed.setBounds(this.w - 202, 0, 100, 20);
        this.getContentPane().add(bRed);
        JButton bQuit = new JButton(Charte.getMessage("MainFrame_Quit"));
        bQuit.setOpaque(false);
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.quitter();
            }
        });
        bQuit.setToolTipText(Charte.getMessage("MainFrame_QuitTT"));
        bQuit.setBounds(this.w - 101, 0, 100, 20);
        this.getContentPane().add(bQuit);
        JLabel logo = new JLabel(Charte.getLogo());
        logo.setBounds(0, 0, 20, 20);
        this.getContentPane().add(logo);
        this.bAdd = new JButton(Charte.getMessage("MainFrame_Open"));
        this.bAdd.setOpaque(false);
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.presenteSauvegardes();
            }
        });
        this.bAdd.setToolTipText(Charte.getMessage("MainFrame_OpenTT"));
        this.bAdd.setBounds(21, 0, 100, 20);
        this.getContentPane().add(this.bAdd);
        this.bSuppr = new JButton(Charte.getMessage("MainFrame_Close"));
        this.bSuppr.setOpaque(false);
        this.bSuppr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.suppConf();
            }
        });
        this.bSuppr.setToolTipText(Charte.getMessage("MainFrame_CloseTT"));
        this.bSuppr.setBounds(122, 0, 100, 20);
        this.getContentPane().add(this.bSuppr);
        this.bSave = new JButton(Charte.getMessage("MainFrame_Save"));
        this.bSave.setOpaque(false);
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.save();
            }
        });
        this.bSave.setToolTipText(Charte.getMessage("MainFrame_SaveTT"));
        this.bSave.setBounds(223, 0, 100, 20);
        this.getContentPane().add(this.bSave);
        this.bPhoto = new JButton(Charte.getMessage("MainFrame_Capture"));
        this.bPhoto.setOpaque(false);
        this.bPhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FenetrePrincipale.this.photo();
            }
        });
        this.bPhoto.setToolTipText(Charte.getMessage("MainFrame_CaptureTT"));
        this.bPhoto.setBounds(324, 0, 100, 20);
        this.getContentPane().add(this.bPhoto);
        this.pConfs = new JPanel(new BorderLayout());
        Charte.formate(this.pConfs);
        this.pConfs.setOpaque(false);
        this.pConfs.setBounds(0, 20, this.w, this.h - 21);
        this.getContentPane().add(this.pConfs);
        this.getContentPane().add(this.lFond);
        this.boutonsFermes();
        this.setVisible(true);
        f.dispose();
        this.disBonjour();
    }

    public JDialog getIndicateurAttente() {
        return this.dEnCours;
    }

    private void boutonsOuverts() {
        this.bPhoto.setEnabled(true);
        this.bSave.setEnabled(true);
        this.bSuppr.setEnabled(true);
        this.bAdd.setEnabled(false);
    }

    private void boutonsFermes() {
        this.bPhoto.setEnabled(false);
        this.bSave.setEnabled(false);
        this.bSuppr.setEnabled(false);
        this.bAdd.setEnabled(true);
    }

    private void ajouter() {
        final JFileChooser choix = new JFileChooser("./dat/pdv");
        FileFilter filtre1 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("leu") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_LEU");
            }
        };
        FileFilter filtre2 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("bch") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_BCH");
            }
        };
        FileFilter filtre3 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("two") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_TWO");
            }
        };
        FileFilter filtre4 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("xtm") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_XTM");
            }
        };
        FileFilter filtre6 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("jou") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_JOU");
            }
        };
        FileFilter filtre7 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("mdn") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_MDN");
            }
        };
        FileFilter filtre5 = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("leu") || f.getName().endsWith("bch") || f.getName().endsWith("two") || f.getName().endsWith("xtm") || f.getName().endsWith("jou") || f.getName().endsWith("mdn") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Charte.getMessage("Format_all");
            }
        };
        choix.addChoosableFileFilter(filtre1);
        choix.addChoosableFileFilter(filtre2);
        choix.addChoosableFileFilter(filtre3);
        choix.addChoosableFileFilter(filtre4);
        choix.addChoosableFileFilter(filtre6);
        choix.addChoosableFileFilter(filtre7);
        choix.addChoosableFileFilter(filtre5);
        choix.setAcceptAllFileFilterUsed(false);
        choix.setFileSelectionMode(0);
        choix.setMultiSelectionEnabled(true);
        int choisi = choix.showOpenDialog(this);
        if (choisi == 0) {
            this.boutonsOuverts();
            new Thread(){

                @Override
                public void run() {
                    FenetrePrincipale.this.processusAjout(choix.getSelectedFiles());
                }
            }.start();
            this.dEnCours.setVisible(true);
        }
        this.actualise();
    }

    private void suppConf() {
        int choix = JOptionPane.showConfirmDialog(this, Charte.getMessage("MainFrame_WarnClose"), Charte.getMessage("MainFrame_WarnCloseT"), 0, 3, Charte.getSmiley("dat/img/_cligne.gif"));
        System.runFinalization();
        System.gc();
        if (choix == 0) {
            this.boutonsFermes();
            this.pConfs.remove(this.cConf);
            this.cConf = null;
            this.actualise();
            this.lFond.setIcon(Charte.getImage());
        }
        this.dossier = "";
    }

    private void quitter() {
        int choix = 2;
        if (this.cConf != null) {
            Object[] options = new String[]{Charte.OUI, Charte.getMessage("MainFrame_QuitWoSave"), Charte.getMessage("MainFrame_NoQuit")};
            choix = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), Charte.getMessage("MainFrame_WarnQuit"), Charte.getMessage("MainFrame_WarnQuitT"), 0, 1, Charte.getSmiley("dat/img/_cligne.gif"), options, options[0]);
        } else {
            this.quitter2();
        }
        if (choix == 0) {
            this.save();
            if (this.saved) {
                this.quitter2();
            } else {
                JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_RepNoQuit"), Charte.getMessage("MainFrame_RepNoQuitT"), 0, Charte.getSmiley("dat/img/_cligne.gif"));
            }
        } else if (choix == 1) {
            this.quitter2();
        }
    }

    private void quitter2() {
        Charte.setDernierUtilisateur(this.nom);
        Charte.saveIni();
        System.out.println("Arr\u00eat de Hippodamos...");
        System.out.println("Arr\u00eat termin\u00e9.");
        System.exit(0);
    }

    private void processusAjout(File[] files) {
        Vector<Graphe> graphes = new Vector<Graphe>();
        if (files.length > 1) {
            try {
                for (int i = 0; i < files.length; ++i) {
                    Graphe nouveauGraphe;
                    if (files[i].getName().endsWith(".leu")) {
                        nouveauGraphe = Chargeur.chargeLEU(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (files[i].getName().endsWith(".xml")) {
                        nouveauGraphe = Chargeur.chargeLEUEN(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (files[i].getName().endsWith(".bch")) {
                        nouveauGraphe = Chargeur.chargeBCH(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (files[i].getName().endsWith(".two")) {
                        nouveauGraphe = Chargeur.chargeTWO(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (files[i].getName().endsWith(".xtm")) {
                        nouveauGraphe = Chargeur.chargeXTM(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (files[i].getName().endsWith(".jou")) {
                        nouveauGraphe = Chargeur.chargeJOU(files[i]);
                        graphes.add(nouveauGraphe);
                        continue;
                    }
                    if (!files[i].getName().endsWith(".mdn")) continue;
                    nouveauGraphe = Chargeur.chargeMDN(files[i]);
                    graphes.add(nouveauGraphe);
                }
                Vector aConfronter = new Vector();
                for (int i = 0; i < graphes.size(); ++i) {
                    aConfronter.add(graphes.elementAt(i));
                }
                Graphe[] gAConf = new Graphe[aConfronter.size()];
                aConfronter.toArray(gAConf);
                this.confrontation = new Confrontation(gAConf);
                this.cConf = this.createConfComponent(this.confrontation);
                this.pConfs.add(this.cConf);
                this.lFond.setIcon(Charte.getFiligrane());
                this.save();
                if (!this.saved) {
                    this.pConfs.remove(this.cConf);
                    this.cConf = null;
                    this.actualise();
                    this.boutonsFermes();
                    this.lFond.setIcon(Charte.getImage());
                }
            }
            catch (ImportException ie) {
                this.boutonsFermes();
                this.lFond.setIcon(Charte.getImage());
                ie.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnOneVP"), Charte.getMessage("MainFrame_WarnOneVPT"), 0, Charte.getSmiley("dat/img/_pfff1.gif"));
            this.boutonsFermes();
            this.lFond.setIcon(Charte.getImage());
        }
        this.actualise();
        this.dEnCours.setVisible(false);
    }

    private void actualise() {
        this.pConfs.setBackground(new Color(0, 0, 0, 32));
        this.pConfs.repaint();
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setVisible(false);
        this.repaint();
    }

    private JComponent createConfComponent(Confrontation confrontation) {
        JPanel pMain = new JPanel(new GridLayout(1, 1));
        pMain.setBorder(Charte.getBorder());
        pMain.setOpaque(false);
        JTabbedPane pTab = new JTabbedPane(2, 0);
        Charte.formate(pTab);
        PanelVisualisation pVisu = new PanelVisualisation(confrontation);
        PanelHomonymes pPolysemies = new PanelHomonymes(confrontation);
        PanelSynonymes pSynonymies = new PanelSynonymes(this, confrontation);
        PanelConfrontation pConfrontation = new PanelConfrontation(this, confrontation);
        PanelNotes pNotes = new PanelNotes(confrontation, this);
        pTab.add(Charte.getMessage("MainFrame_TabExplorer"), pVisu);
        pTab.add(Charte.getMessage("MainFrame_TabSeparer"), pPolysemies);
        pTab.add(Charte.getMessage("MainFrame_TabRelier"), pSynonymies);
        pTab.add(Charte.getMessage("MainFrame_TabObserver"), pConfrontation);
        pTab.add(Charte.getMessage("MainFrame_TabPublier"), pNotes);
        for (int i = 0; i < pTab.getTabCount(); ++i) {
            pTab.setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        pTab.setOpaque(false);
        pMain.add(pTab);
        return pMain;
    }

    private void save() {
        this.saved = false;
        if (this.cConf != null) {
            File[] f = new File("dat/usr/" + this.nom).listFiles();
            Vector<String> v = new Vector<String>();
            v.add(AUTRE);
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].isDirectory()) continue;
                v.add(f[i].getName());
            }
            Object[] s = new String[v.size()];
            v.toArray(s);
            Object nomD = AUTRE;
            if (s.length > 1) {
                nomD = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_SaveOu"), Charte.getMessage("MainFrame_SaveOuT"), 3, Charte.getSmiley("dat/img/_veryhappy.gif"), s, this.dossier);
            }
            if (nomD != null && nomD.equals(AUTRE)) {
                nomD = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_NewSave"), Charte.getMessage("MainFrame_NewSaveT"), 1, Charte.getSmiley("dat/img/_veryhappy.gif"), null, this.dossier);
            }
            if (nomD != null) {
                String nomDossier = nomD.toString();
                if (nomDossier.equals("")) {
                    JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_RefusNew"), Charte.getMessage("MainFrame_RefusNewT"), 1, Charte.getSmiley("dat/img/_euh.gif"));
                } else if (nomDossier.equals(AUTRE)) {
                    nomD = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_Reserve"), Charte.getMessage("MainFrame_ReserveT"), 1, Charte.getSmiley("dat/img/_pfff1.gif"), null, this.dossier);
                    if (nomD != null) {
                        nomDossier = nomD.toString();
                        if (!nomDossier.equals("") && !nomDossier.equals(AUTRE)) {
                            this.save2(nomDossier);
                        } else {
                            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_Detresse"), Charte.getMessage("MainFrame_DetresseT"), 1, Charte.getSmiley("dat/img/_ouin.gif"));
                        }
                    }
                } else {
                    this.save2(nomDossier);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_RienASave"), Charte.getMessage("MainFrame_RienASaveT"), 1, Charte.getSmiley("dat/img/_colere.gif"));
        }
    }

    private void save2(String nomDossier) {
        this.dossier = nomDossier;
        File d = new File("dat/usr/" + this.nom + "/" + this.dossier + "/");
        File f = new File("dat/usr/" + this.nom + "/" + this.dossier + "/" + this.dossier + ".sav");
        try {
            d.mkdirs();
            f.createNewFile();
            this.confrontation.save(f);
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_ValideSave"), Charte.getMessage("MainFrame_ValideSaveT"), 1, Charte.getSmiley("dat/img/_cligne.gif"));
            this.saved = true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnNoSave") + ioe.getMessage(), Charte.getMessage("MainFrame_WarnNoSaveT"), 1, Charte.getSmiley("dat/img/_maman.gif"));
        }
    }

    private void load(final File f) {
        this.boutonsOuverts();
        new Thread(){

            @Override
            public void run() {
                FenetrePrincipale.this.load2(f);
            }
        }.start();
        this.dEnCours.setVisible(true);
    }

    private void load2(File f) {
        try {
            this.dossier = f.getParentFile().getName();
            this.confrontation = Confrontation.load(f);
            this.cConf = this.createConfComponent(this.confrontation);
            this.pConfs.add(this.cConf);
            this.lFond.setIcon(Charte.getFiligrane());
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnNoLoad") + ioe.getMessage(), Charte.getMessage("MainFrame_WarnNoLoadT"), 1, Charte.getSmiley("dat/img/_maman.gif"));
            this.boutonsFermes();
            this.lFond.setIcon(Charte.getImage());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnNoLoad") + e.getClass() + "(" + e.getMessage() + ")", Charte.getMessage("MainFrame_WarnNoLoadT"), 1, Charte.getSmiley("dat/img/_maman.gif"));
            this.boutonsFermes();
            this.lFond.setIcon(Charte.getImage());
        }
        this.actualise();
        this.dEnCours.setVisible(false);
    }

    private void disBonjour() {
        String nomS = Charte.getDernierUtilisateur();
        Object n = JOptionPane.showInputDialog(null, Charte.getMessage("MainFrame_Welcome"), Charte.getMessage("MainFrame_WelcomeT"), 3, Charte.getSmiley("dat/img/_veryhappy.gif"), null, nomS);
        if (n == null) {
            n = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_SnifNoName"), Charte.getMessage("MainFrame_SnifNoNameT"), 3, Charte.getSmiley("dat/img/_ouin.gif"), null, "");
        } else if (n.equals("")) {
            n = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_SnifNoName"), Charte.getMessage("MainFrame_SnifNoNameT"), 3, Charte.getSmiley("dat/img/_ouin.gif"), null, "");
        }
        if (n == null) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_RefuseEnter"), Charte.getMessage("MainFrame_RefuseEnterT"), 1, Charte.getSmiley("dat/img/_triste.gif"));
            System.exit(1);
        } else if (n.equals("")) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_RefuseEnter"), Charte.getMessage("MainFrame_RefuseEnterT"), 1, Charte.getSmiley("dat/img/_triste.gif"));
            System.exit(1);
        }
        this.nom = n.toString();
        try {
            File f = new File("dat/usr/" + this.nom);
            boolean trouve = false;
            if (f.exists() && f.isDirectory()) {
                trouve = true;
            }
            if (!trouve) {
                throw new FileNotFoundException();
            }
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_Registered") + " " + this.nom + Charte.getMessage("MainFrame_Registered2"), Charte.getMessage("MainFrame_RegisteredT"), 1, Charte.getSmiley("dat/img/_veryhappy.gif"));
            this.presenteSauvegardes();
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_NewUser") + " " + this.nom + Charte.getMessage("MainFrame_NewUser2"), Charte.getMessage("MainFrame_NewUserT"), 1, Charte.getSmiley("dat/img/_veryhappy.gif"));
            File f = new File("dat/usr/" + this.nom);
            f.mkdirs();
            this.ajouter();
        }
    }

    private void presenteSauvegardes() {
        File f = new File("dat/usr/" + this.nom);
        Vector<String> v = new Vector<String>();
        File[] ff = f.listFiles();
        v.addElement(AUTRE);
        for (int i = 0; i < ff.length; ++i) {
            v.addElement(ff[i].getName());
        }
        Object[] f2 = new String[v.size()];
        v.toArray(f2);
        if (f2.length > 1) {
            Object choix = JOptionPane.showInputDialog(this, Charte.getMessage("MainFrame_PresentFiles"), Charte.getMessage("MainFrame_PresentFilesT"), 3, Charte.getSmiley("dat/img/_study.gif"), f2, f2[0]);
            if (choix != null) {
                if (!choix.equals(AUTRE)) {
                    this.dossier = choix.toString();
                    this.load(new File("dat/usr/" + this.nom + "/" + choix + "/" + choix + ".sav"));
                } else {
                    JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_NewFile"), Charte.getMessage("MainFrame_NewFileT"), 1, Charte.getSmiley("dat/img/_cligne.gif"));
                    this.ajouter();
                }
            } else {
                JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_NewFile"), Charte.getMessage("MainFrame_NewFileT"), 1, Charte.getSmiley("dat/img/_cligne.gif"));
                this.ajouter();
            }
        } else {
            JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_NoFile"), Charte.getMessage("MainFrame_NoFileT"), 1, Charte.getSmiley("dat/img/_euh.gif"));
            this.ajouter();
        }
    }

    File getDossier() {
        return new File("dat/usr/" + this.nom + "/" + this.dossier);
    }

    private void photo() {
        this.stade = 0;
        this.getGlassPane().setVisible(true);
        this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon("dat/img/photo.gif").getImage(), new Point(15, 15), "photo"));
        this.lFond.setIcon(Charte.getImageBlanche());
    }

    private void photoFinie() {
        if (Math.abs(this.photoX1 - this.photoX0) > 0 && Math.abs(this.photoY1 - this.photoY0) > 0) {
            try {
                Rectangle r = new Rectangle(Math.min(this.photoX0, this.photoX1), Math.min(this.photoY0, this.photoY1), Math.abs(this.photoX1 - this.photoX0), Math.abs(this.photoY1 - this.photoY0));
                Robot bot = new Robot();
                this.image = bot.createScreenCapture(r);
            }
            catch (AWTException ae) {
                JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnNoPhoto") + ae.getMessage(), Charte.getMessage("MainFrame_WarnNoPhotoT"), 1, Charte.getSmiley("dat/img/_ouin.gif"));
            }
            Object[] options = new String[]{Charte.getMessage("MainFrame_PhotoGarder"), Charte.getMessage("MainFrame_PhotoJeter")};
            JLabel l = new JLabel(new ImageIcon(this.image));
            l.setBorder(Charte.getBorder());
            int choix = JOptionPane.showOptionDialog(this, l, Charte.getMessage("MainFrame_PhotoPrise"), 0, 1, Charte.getSmiley("dat/img/_veryhappy.gif"), options, options[0]);
            if (choix == 0) {
                JFileChooser f = new JFileChooser(new File("dat/usr/" + this.nom + "/" + this.dossier));
                FileFilter filtre = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith("png") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Charte.getMessage("Format_PNG");
                    }
                };
                f.addChoosableFileFilter(filtre);
                choix = f.showSaveDialog(this);
                if (choix == 0) {
                    try {
                        File save = f.getSelectedFile();
                        if (!save.getName().endsWith("png")) {
                            save = new File(save.getPath() + ".png");
                        }
                        ImageIO.write((RenderedImage)this.image, "png", save);
                        JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_ValideSave"), Charte.getMessage("MainFrame_ValideSaveT"), 1, Charte.getSmiley("dat/img/_cligne.gif"));
                        EventHandler.notifyEvent(5001, "");
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, Charte.getMessage("MainFrame_WarnNoSave") + ioe.getMessage(), Charte.getMessage("MainFrame_WarnNoSaveT"), 1, Charte.getSmiley("dat/img/_maman.gif"));
                    }
                }
            }
        }
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getDefaultCursor());
        this.lFond.setIcon(Charte.getFiligrane());
    }
}

