/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class Charte {
    private static String lastUser = "";
    private static Map langues;
    private static String langue;
    private static int TAILLE_POLICE;
    private static final Font policeNorm;
    private static final Color couleurEcriture;
    private static final Color couleurSurlignage;
    private static final Color couleurFond;
    private static final Color couleurAutres;
    private static final Border bordure;
    private static final ImageIcon image;
    private static final ImageIcon imageBlanche;
    private static final ImageIcon filigrane;
    private static final ImageIcon logo;
    private static final ImageIcon son;
    public static String OK;
    public static String CANCEL;
    public static String OUI;
    public static String NON;
    public static final String ANGE = "dat/img/_ange.gif";
    public static final String CHASSE = "dat/img/_chasse.gif";
    public static final String CHOC = "dat/img/_choc.gif";
    public static final String CLIN_D_OEIL = "dat/img/_cligne.gif";
    public static final String COLERE = "dat/img/_colere.gif";
    public static final String DODO = "dat/img/_dodo.gif";
    public static final String CONFUS = "dat/img/_euh.gif";
    public static final String DELIRE = "dat/img/_fou.gif";
    public static final String MALIN = "dat/img/_hehe.gif";
    public static final String MOQUEUR = "dat/img/_langue.gif";
    public static final String PEUR = "dat/img/_maman.gif";
    public static final String FAIM = "dat/img/_miam.gif";
    public static final String MITIGE = "dat/img/_mouais.gif";
    public static final String SADIQUE = "dat/img/_mouark.gif";
    public static final String EXTASIE = "dat/img/_mrgreen.gif";
    public static final String PLEUR = "dat/img/_ouin.gif";
    public static final String DEPRIME = "dat/img/_pfff1.gif";
    public static final String LAS = "dat/img/_pfff2.gif";
    public static final String EN_VEUT = "dat/img/_rambo.gif";
    public static final String NEUTRE = "dat/img/_rien.gif";
    public static final String RIRE = "dat/img/_rire.gif";
    public static final String YEUX_AU_CIEL = "dat/img/_roll.gif";
    public static final String SOURIANT = "dat/img/_sourire.gif";
    public static final String ETUDE = "dat/img/_study.gif";
    public static final String TRISTE = "dat/img/_triste.gif";
    public static final String CONTENT = "dat/img/_veryhappy.gif";

    public static String getVersion() {
        return "4.1";
    }

    public static void formate(JComponent jc) {
        jc.setOpaque(false);
        jc.setBorder(null);
        jc.setForeground(couleurEcriture);
        jc.setFont(policeNorm);
    }

    public static JComponent format(JComponent jc) {
        Charte.formate(jc);
        return jc;
    }

    public static Font getFont() {
        return policeNorm;
    }

    public static Color getForeground() {
        return couleurEcriture;
    }

    public static Color getBackground() {
        return couleurFond;
    }

    public static Color getMiscellaneous() {
        return couleurAutres;
    }

    public static Border getBorder() {
        return bordure;
    }

    public static ImageIcon getImage() {
        return image;
    }

    public static ImageIcon getImageBlanche() {
        return imageBlanche;
    }

    public static ImageIcon getFiligrane() {
        return filigrane;
    }

    public static ImageIcon getLogo() {
        return logo;
    }

    public static ImageIcon getIconeSon() {
        return son;
    }

    public static ImageIcon getSmiley(String icone) {
        return new ImageIcon(icone);
    }

    public static String getMessage(String id) {
        Object s = ((Map)langues.get(langue)).get(id);
        if (s == null) {
            JOptionPane.showMessageDialog(null, "\u00b0x\u00b0   " + id + "   \u00b0x\u00b0");
            s = "\u00b0x\u00b0   " + id + "   \u00b0x\u00b0";
        }
        return s.toString();
    }

    public static void setLangue(String lng) {
        langue = lng;
        Charte.initUI();
    }

    public static String getLangue() {
        return langue;
    }

    public static String[] getLangues() {
        String[] res = new String[langues.keySet().size()];
        langues.keySet().toArray(res);
        return res;
    }

    public static String getDernierUtilisateur() {
        return lastUser;
    }

    public static void setDernierUtilisateur(String nom) {
        lastUser = nom;
    }

    public static Map getMessagesIncomprehension() {
        String[] listeLangues = Charte.getLangues();
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(langue, ((Map)langues.get(langue)).get("InitLng_OK").toString());
        for (int i = 0; i < listeLangues.length; ++i) {
            if (listeLangues[i].equals(langue)) continue;
            res.put(listeLangues[i], ((Map)langues.get(listeLangues[i])).get("InitLng_KO").toString());
        }
        return res;
    }

    public static void saveIni() {
        try {
            File f = new File("arcenciel.ini");
            f.createNewFile();
            FileWriter fw = new FileWriter(f);
            fw.write("dernier utilisateur=" + lastUser + "\n");
            fw.write("langue=" + langue + "\n");
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void initUI() {
        OK = Charte.getMessage("Button_OK");
        CANCEL = Charte.getMessage("Button_Cancel");
        OUI = Charte.getMessage("Button_Yes");
        NON = Charte.getMessage("Button_No");
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        UIManager.put("TabbedPane.selected", new Color(255, 255, 255, 0));
        UIManager.put("TabbedPane.tabsOpaque", Boolean.FALSE);
        UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
        UIManager.put("OptionPane.yesButtonText", OUI);
        UIManager.put("OptionPane.noButtonText", NON);
        UIManager.put("OptionPane.okButtonText", OK);
        UIManager.put("OptionPane.cancelButtonText", CANCEL);
        UIManager.put("ProgressBar.cycleTime", new Integer(2000));
        UIManager.put("ToolTip.foreground", couleurEcriture);
        UIManager.put("OptionPane.foreground", couleurEcriture);
        UIManager.put("TextArea.foreground", couleurEcriture);
        UIManager.put("OptionPane.messageForeground", couleurEcriture);
        UIManager.put("Button.foreground", couleurEcriture);
        UIManager.put("TextPane.foreground", couleurEcriture);
        UIManager.put("Panel.foreground", couleurEcriture);
        UIManager.put("Label.foreground", couleurEcriture);
        UIManager.put("TextField.foreground", couleurEcriture);
        UIManager.put("ScrollBar.foreground", couleurEcriture);
        UIManager.put("ComboBox.foreground", couleurEcriture);
        UIManager.put("Table.foreground", couleurEcriture);
        UIManager.put("TableHeader.foreground", couleurEcriture);
        UIManager.put("TextPane.foreground", couleurEcriture);
        UIManager.put("List.foreground", couleurEcriture);
        UIManager.put("ComboBox.disabledForeground", couleurEcriture);
        UIManager.put("ComboBox.selectionForeground", couleurEcriture);
        UIManager.put("Label.disabledForeground", couleurEcriture);
        UIManager.put("List.selectionForeground", couleurEcriture);
        UIManager.put("OptionPane.messageForeground", couleurEcriture);
        UIManager.put("ProgressBar.selectionForeground", couleurEcriture);
        UIManager.put("Table.focusCellForeground", couleurEcriture);
        UIManager.put("Table.selectionForeground", couleurEcriture);
        UIManager.put("TextField.caretForeground", couleurEcriture);
        UIManager.put("TextField.inactiveForeground", couleurEcriture.darker());
        UIManager.put("TextField.selectionForeground", couleurEcriture);
        UIManager.put("TextPane.caretForeground", couleurEcriture);
        UIManager.put("TextPane.inactiveForeground", couleurEcriture.darker());
        UIManager.put("TextPane.selectionForeground", couleurEcriture);
        UIManager.put("ProgressBar.foreground", couleurFond.darker());
        UIManager.put("ToolTip.background", couleurFond);
        UIManager.put("OptionPane.background", couleurFond);
        UIManager.put("Button.background", couleurFond);
        UIManager.put("TextPane.background", couleurFond);
        UIManager.put("TextArea.background", couleurFond);
        UIManager.put("Panel.background", couleurFond);
        UIManager.put("Label.background", couleurFond);
        UIManager.put("TextField.background", couleurFond);
        UIManager.put("ScrollBar.background", couleurFond);
        UIManager.put("ComboBox.background", couleurFond);
        UIManager.put("Table.background", couleurFond);
        UIManager.put("TableHeader.background", couleurFond);
        UIManager.put("ProgressBar.background", couleurFond);
        UIManager.put("TextPane.background", couleurFond);
        UIManager.put("List.background", couleurFond);
        UIManager.put("Slider.background", couleurFond);
        UIManager.put("List.selectionBackground", couleurFond.darker());
        UIManager.put("ComboBox.selectionBackground", couleurFond.darker());
        UIManager.put("ProgressBar.selectionBackground", couleurFond.darker());
        UIManager.put("Table.selectionBackground", couleurFond.darker());
        UIManager.put("TextField.selectionBackground", couleurFond.darker());
        UIManager.put("TextArea.selectionBackground", couleurFond.darker());
        UIManager.put("Button.select", couleurFond.darker());
        UIManager.put("Table.focusCellBackground", couleurFond.darker());
        UIManager.put("ToolTip.font", policeNorm);
        UIManager.put("OptionPane.font", policeNorm);
        UIManager.put("OptionPane.messageFont", policeNorm);
        UIManager.put("OptionPane.buttonFont", policeNorm);
        UIManager.put("Button.font", policeNorm);
        UIManager.put("ComboBox.font", policeNorm);
        UIManager.put("Label.font", policeNorm);
        UIManager.put("TextField.font", policeNorm);
        UIManager.put("TextArea.font", policeNorm);
        UIManager.put("Table.font", policeNorm);
        UIManager.put("TableHeader.font", policeNorm);
        UIManager.put("ProgressBar.font", policeNorm);
        UIManager.put("List.font", policeNorm);
        UIManager.put("ToolTip.border", bordure);
        UIManager.put("Button.border", bordure);
        UIManager.put("TableHeader.cellBorder", bordure);
        UIManager.put("SplitPaneDivider.border", bordure);
        UIManager.put("ProgressBar.border", bordure);
        UIManager.put("TextField.border", bordure);
        UIManager.put("TextArea.border", bordure);
        UIManager.put("TextPane.border", bordure);
        UIManager.put("List.focusCellHighlightBorder", BorderFactory.createEmptyBorder());
        UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder());
    }

    static {
        TAILLE_POLICE = 13;
        if (Toolkit.getDefaultToolkit().getScreenSize().width <= 800) {
            TAILLE_POLICE = 11;
        } else if (Toolkit.getDefaultToolkit().getScreenSize().width <= 1024) {
            TAILLE_POLICE = 12;
        }
        policeNorm = new Font("Garamond", 0, TAILLE_POLICE);
        couleurEcriture = Color.BLACK;
        couleurSurlignage = Color.BLUE;
        couleurFond = new Color(224, 224, 224);
        couleurAutres = new Color(0, 0, 0);
        bordure = BorderFactory.createBevelBorder(0, new Color(255, 255, 255), new Color(192, 192, 192), new Color(255, 255, 255), new Color(192, 192, 192));
        image = new ImageIcon(Toolkit.getDefaultToolkit().createImage("dat/img/fond.jpg").getScaledInstance(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height, 4));
        imageBlanche = new ImageIcon(Toolkit.getDefaultToolkit().createImage("dat/img/blanc.jpg").getScaledInstance(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height, 4));
        filigrane = new ImageIcon(Toolkit.getDefaultToolkit().createImage("dat/img/filigrane.jpg").getScaledInstance(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height, 4));
        logo = new ImageIcon("dat/img/icone.gif");
        son = new ImageIcon("dat/img/son.gif");
        OK = "";
        CANCEL = "";
        OUI = "";
        NON = "";
        langues = new HashMap();
        File f = new File("dat/lng");
        File[] fLangues = f.listFiles();
        for (int i = 0; i < fLangues.length; ++i) {
            if (!fLangues[i].getName().endsWith(".lng")) continue;
            HashMap<String, String> donnees = new HashMap<String, String>();
            try {
                BufferedReader lect = new BufferedReader(new FileReader(fLangues[i]));
                while (lect.ready()) {
                    String[] ligne = lect.readLine().trim().split("=");
                    donnees.put(ligne[0].trim(), ligne[1].trim());
                }
                langues.put(fLangues[i].getName().split("\\.")[0].trim(), donnees);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                aioobe.printStackTrace();
            }
        }
        File fl = new File("arcenciel.ini");
        if (fl.exists()) {
            String nomS = "";
            try {
                BufferedReader r = new BufferedReader(new FileReader(fl));
                String s = "";
                while (!s.startsWith("dernier utilisateur=")) {
                    s = r.readLine();
                }
                lastUser = s.split("=")[1].trim();
                while (!s.startsWith("langue=")) {
                    s = r.readLine();
                }
                Charte.setLangue(s.split("=")[1].trim());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Charte.setLangue("" + langues.keySet().iterator().next());
        }
    }
}

