/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Propriete;
import java.util.HashSet;
import java.util.Set;

public class TypeLien {
    private String nom;
    private Set proprietes;
    private int marqueurHomonymie;
    private String description = "";

    public TypeLien(String nom) {
        this.nom = nom;
        this.proprietes = new HashSet();
        this.marqueurHomonymie = 0;
    }

    public TypeLien(String nom, Propriete[] proprietes) {
        this(nom);
        for (int i = 0; i < proprietes.length; ++i) {
            this.proprietes.add(proprietes[i]);
        }
    }

    public void addPropriete(Propriete p) {
        this.proprietes.add(p);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNomBase() {
        return this.nom;
    }

    public String getNom() {
        return this.nom + (this.marqueurHomonymie == 0 ? "" : " - " + this.marqueurHomonymie);
    }

    public void setHomonyme(int numero) {
        this.marqueurHomonymie = numero;
    }

    public Propriete[] getProprietes() {
        Propriete[] res = new Propriete[this.proprietes.size()];
        this.proprietes.toArray(res);
        return res;
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof TypeLien && ((TypeLien)o).nom.equalsIgnoreCase(this.nom)) {
            res = true;
        }
        return res;
    }

    public String toString() {
        return this.nom + " (" + this.proprietes + ")";
    }
}

