/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ListeSynonymes;
import data.TexteCommun;
import java.util.Vector;

public class MotHomonyme {
    private TexteCommun[] mots;
    private String lien = "";
    private String comm = "";

    public MotHomonyme(TexteCommun[] mots, String lien, String commentaire) {
        this.mots = mots;
        this.lien = lien;
        this.comm = commentaire;
    }

    public MotHomonyme(String sauvegarde) {
        String[] s = sauvegarde.split("::");
        this.lien = s[0];
        this.comm = s[1];
        Vector<TexteCommun> v = new Vector<TexteCommun>();
        for (int i = 2; i < s.length; ++i) {
            TexteCommun t = new TexteCommun(s[i]);
            v.add(t);
        }
        this.mots = new TexteCommun[v.size()];
        v.toArray(this.mots);
    }

    public String getSauvegarde() {
        String s = "";
        s = s + this.lien + "::" + this.comm + "::";
        for (int i = 0; i < this.mots.length; ++i) {
            s = s + this.mots[i].getSauvegarde().split("\\$")[0].split(" - ")[0] + "$" + this.mots[i].getSauvegarde().split("\\$")[1];
            if (i >= this.mots.length - 1) continue;
            s = s + "::";
        }
        return s;
    }

    public TexteCommun[] getMots() {
        return this.mots;
    }

    public String getLien() {
        return this.lien;
    }

    public String getCommentaire() {
        return this.comm;
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof ListeSynonymes) {
            MotHomonyme l = (MotHomonyme)o;
            return l.getMots().equals(this.getMots());
        }
        return res;
    }

    public String toString() {
        String res = this.mots[0].getTexte();
        if (!this.lien.equals("")) {
            res = res + " {" + this.lien + "}";
        }
        return res;
    }
}

