/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Association;
import data.Lien;
import data.Noeud;
import data.Propriete;
import data.TypeLien;
import data.TypeNoeud;
import ihm.Charte;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Graphe {
    private String nom;
    private Map typesNoeuds;
    private Map typesLiens;
    private Map noeuds;
    private Map liens;
    private Vector associations;
    private int tn = -1;
    private int tl = -1;
    private Set nomsNoeuds = new HashSet();

    public Graphe(String nom) {
        this.nom = nom;
        this.typesNoeuds = new HashMap();
        this.typesLiens = new HashMap();
        this.noeuds = new HashMap();
        this.liens = new HashMap();
        this.associations = new Vector();
    }

    public String getNom() {
        return this.nom;
    }

    public void addTypeNoeud(int id, TypeNoeud type) {
        if (!this.typesNoeuds.containsValue(type)) {
            this.typesNoeuds.put(new Integer(id), type);
        }
    }

    public void addTypeNoeud(TypeNoeud type) {
        this.addTypeNoeud(this.tn--, type);
    }

    public TypeNoeud getTypeNoeud(int id) {
        return (TypeNoeud)this.typesNoeuds.get(new Integer(id));
    }

    public TypeNoeud[] getAllTypesNoeuds() {
        TypeNoeud[] types = new TypeNoeud[this.typesNoeuds.values().size()];
        this.typesNoeuds.values().toArray(types);
        return types;
    }

    public void addTypeLien(int id, TypeLien type) {
        if (!this.typesLiens.containsValue(type)) {
            this.typesLiens.put(new Integer(id), type);
        }
    }

    public void addTypeLien(TypeLien type) {
        this.addTypeLien(this.tl--, type);
    }

    public TypeLien getTypeLien(int id) {
        return (TypeLien)this.typesLiens.get(new Integer(id));
    }

    public TypeLien[] getAllTypesLiens() {
        TypeLien[] types = new TypeLien[this.typesLiens.values().size()];
        this.typesLiens.values().toArray(types);
        return types;
    }

    public Propriete[] getAllProprietes() {
        TypeLien[] tl = this.getAllTypesLiens();
        HashSet<Propriete> res = new HashSet<Propriete>();
        for (int i = 0; i < tl.length; ++i) {
            Propriete[] p = tl[i].getProprietes();
            for (int j = 0; j < p.length; ++j) {
                res.add(p[j]);
            }
        }
        Propriete[] resultat = new Propriete[res.size()];
        res.toArray(resultat);
        return resultat;
    }

    public void addNoeud(int id, Noeud noeud) {
        while (this.nomsNoeuds.contains(noeud.getLabel())) {
            noeud.declareAmbigu();
        }
        this.nomsNoeuds.add(noeud.getLabel());
        this.noeuds.put(new Integer(id), noeud);
        this.addTypeNoeud(noeud.getType());
    }

    public Noeud getNoeud(int id) {
        return (Noeud)this.noeuds.get(new Integer(id));
    }

    public Noeud trouveNoeud(String nom) {
        Noeud res = null;
        Noeud[] n = this.getAllNoeuds();
        for (int i = 0; i < n.length; ++i) {
            if (!n[i].getLabel().equals(nom)) continue;
            res = n[i];
            break;
        }
        return res;
    }

    public void desambigueHomonyme(String nom, int numero) {
        this.trouveNoeud(nom).setHomonyme(numero);
    }

    public void removeDesambiguation(String nom) {
        this.trouveNoeud(nom).setHomonyme(0);
    }

    public TypeLien trouveTypeLien(String nom) {
        TypeLien res = null;
        TypeLien[] n = this.getAllTypesLiens();
        for (int i = 0; i < n.length; ++i) {
            if (!n[i].getNom().equals(nom)) continue;
            res = n[i];
            break;
        }
        return res;
    }

    public void desambigueHomonymeTL(String nom, int numero) {
        this.trouveTypeLien(nom).setHomonyme(numero);
    }

    public void removeDesambiguationTL(String nom) {
        this.trouveTypeLien(nom).setHomonyme(0);
    }

    private Propriete[] trouveProprietes(String nom) {
        Vector<Propriete> res = new Vector<Propriete>();
        TypeLien[] n = this.getAllTypesLiens();
        block0: for (int i = 0; i < n.length; ++i) {
            Propriete[] p = n[i].getProprietes();
            for (int j = 0; j < p.length; ++j) {
                if (!p[j].getNom().equals(nom)) continue;
                res.addElement(p[j]);
                continue block0;
            }
        }
        Propriete[] pp = new Propriete[res.size()];
        res.toArray(pp);
        return pp;
    }

    public void desambigueHomonymeP(String nom, int numero) {
        Propriete[] pp = this.trouveProprietes(nom);
        for (int i = 0; i < pp.length; ++i) {
            pp[i].setHomonyme(numero);
        }
    }

    public void removeDesambiguationP(String nom) {
        Propriete[] pp = this.trouveProprietes(nom);
        for (int i = 0; i < pp.length; ++i) {
            pp[i].setHomonyme(0);
        }
    }

    public int getIdNoeud(String label) {
        Noeud[] n = this.getAllNoeuds();
        int i = 0;
        for (i = 0; i < n.length && !n[i].getLabel().equals(label); ++i) {
        }
        return i;
    }

    public Noeud[] getAllNoeuds() {
        Noeud[] n = new Noeud[this.noeuds.values().size()];
        this.noeuds.values().toArray(n);
        Arrays.sort(n, new ComparateurNoeuds());
        return n;
    }

    public void addLien(int id, Lien lien) {
        this.liens.put(new Integer(id), lien);
        this.addTypeLien(lien.getType());
    }

    public Lien getLien(int id) {
        return (Lien)this.liens.get(new Integer(id));
    }

    public Lien[] getAllLiens() {
        Lien[] l = new Lien[this.liens.values().size()];
        this.liens.values().toArray(l);
        return l;
    }

    public void addAssociation(Association asso) {
        this.associations.add(asso);
    }

    public void addAssociation(int idLien, int idNoeudOrigine, int idNoeudDestination) throws NullPointerException {
        Lien l = (Lien)this.liens.get(new Integer(idLien));
        Noeud n1 = (Noeud)this.noeuds.get(new Integer(idNoeudOrigine));
        Noeud n2 = (Noeud)this.noeuds.get(new Integer(idNoeudDestination));
        if (l == null) {
            throw new NullPointerException(Charte.getMessage("Graphe_Error_Unk_Link") + " " + idLien);
        }
        if (n1 == null) {
            throw new NullPointerException(Charte.getMessage("Graphe_Error_Unk_Node") + " " + idNoeudOrigine);
        }
        if (n2 == null) {
            throw new NullPointerException(Charte.getMessage("Graphe_Error_Unk_Node") + " " + idNoeudDestination);
        }
        this.addAssociation(new Association(l, n1, n2));
    }

    public Association[] getAllAssociations() {
        Association[] as = new Association[this.associations.size()];
        this.associations.toArray(as);
        return as;
    }

    public Association[] getAssociationsContenant(Noeud noeud) {
        Association[] a = this.getAllAssociations();
        Vector<Association> res = new Vector<Association>();
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getOrigine().equals(noeud) && !a[i].getDestination().equals(noeud)) continue;
            res.add(a[i]);
        }
        Association[] r = new Association[res.size()];
        res.toArray(r);
        return r;
    }

    private String formatage(String s) {
        s = s.toLowerCase();
        s = s.replaceAll("\u00e1|\u00e0|\u00e2|\u00e4|\u00e5", "a");
        s = s.replaceAll("\u00df", "s");
        s = s.replaceAll("\u00e7", "c");
        s = s.replaceAll("\u00e9|\u00e8|\u00ea|\u00eb", "e");
        s = s.replaceAll("\u00ed|\u00ec|\u00ee|\u00ef", "i");
        s = s.replaceAll("\u00f1", "n");
        s = s.replaceAll("\u00f3|\u00f2|\u00f4|\u00f6", "o");
        s = s.replaceAll("\u00fa|\u00f9|\u00fb|\u00fc", "u");
        s = s.replaceAll("\u00ff", "y");
        s = s.replaceAll("\\W", " ");
        return s;
    }

    public String toString() {
        return "Graphe :  " + this.noeuds.keySet().size() + " noeuds, " + this.liens.keySet().size() + " liens, " + this.associations.size() + " associations entre eux.";
    }

    private class ComparateurNoeuds
    implements Comparator {
        private ComparateurNoeuds() {
        }

        public int compare(Object o1, Object o2) {
            int a = Graphe.this.formatage(((Noeud)o1).getLabel()).compareToIgnoreCase(Graphe.this.formatage(((Noeud)o2).getLabel()));
            return a;
        }
    }
}

