/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Association;
import data.Chargeur;
import data.Graphe;
import data.ImportException;
import data.LienEntreListes;
import data.ListeSynonymes;
import data.MotHomonyme;
import data.Noeud;
import data.Propriete;
import data.TexteCommun;
import data.TypeLien;
import ihm.Charte;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Confrontation {
    private Graphe[] graphes;
    private Set listeMotsVides;
    private Map listePolysemiques;
    private Map listeTLPolysemiques;
    private Map listePPolysemiques;
    private TableSynonymes tableSynonymesN;
    private TableSynonymes tableSynonymesT;
    private TableSynonymes tableSynonymesP;
    private double seuilN = 0.5;
    private double seuilT = 0.5;
    private double seuilP = 0.5;
    private Map allMotsGraphe = null;
    private Map allTermesNoeuds = null;
    private Map allTermesTypesLiens = null;
    private Map allTermesProprietes = null;
    private Map allTermesCommuns = null;
    private Map allTypesLiensCommuns = null;
    private Map allProprietesCommunes = null;
    private Vector raisonsRapprochement;
    private Vector raisonsEloignement;
    public static final String RAISON_IDENTITE = Charte.getMessage("Conf_Identite");
    public static final String RAISON_A_PRECISER = Charte.getMessage("Conf_APreciser");

    public Confrontation(Graphe[] graphes) {
        this.graphes = graphes;
        this.listeMotsVides = new HashSet();
        this.listePolysemiques = new HashMap();
        this.listeTLPolysemiques = new HashMap();
        this.listePPolysemiques = new HashMap();
        this.tableSynonymesN = new TableSynonymes();
        this.tableSynonymesT = new TableSynonymes();
        this.tableSynonymesP = new TableSynonymes();
    }

    public void save(File f) throws IOException {
        ListeSynonymes[] l;
        MotHomonyme[] m;
        int i;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, false));
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotOpenSave"));
        }
        try {
            writer.write("$$ Graphes");
            writer.newLine();
            for (int i2 = 0; i2 < this.graphes.length; ++i2) {
                writer.write(this.graphes[i2].getNom());
                writer.newLine();
            }
            writer.write("$$ Fin Graphes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenVP"));
        }
        try {
            writer.write("$$ Mots Vides");
            writer.newLine();
            TexteCommun[] t = new TexteCommun[this.listeMotsVides.size()];
            this.listeMotsVides.toArray(t);
            for (i = 0; i < t.length; ++i) {
                writer.write(t[i].getTexte());
                writer.newLine();
            }
            writer.write("$$ Fin Mots Vides");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenMV"));
        }
        try {
            writer.write("$$ Noeuds Homonymes");
            writer.newLine();
            m = new MotHomonyme[this.listePolysemiques.values().size()];
            this.listePolysemiques.values().toArray(m);
            for (i = 0; i < m.length; ++i) {
                writer.write(m[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Noeuds Homonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenTeH"));
        }
        try {
            writer.write("$$ Types de Liens Homonymes");
            writer.newLine();
            m = new MotHomonyme[this.listeTLPolysemiques.values().size()];
            this.listeTLPolysemiques.values().toArray(m);
            for (i = 0; i < m.length; ++i) {
                writer.write(m[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Types de Liens Homonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenRTH"));
        }
        try {
            writer.write("$$ Propri\u00e9t\u00e9s Homonymes");
            writer.newLine();
            m = new MotHomonyme[this.listePPolysemiques.values().size()];
            this.listePPolysemiques.values().toArray(m);
            for (i = 0; i < m.length; ++i) {
                writer.write(m[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Propri\u00e9t\u00e9s Homonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenRPH"));
        }
        try {
            writer.write("$$ Noeuds Synonymes");
            writer.newLine();
            l = this.tableSynonymesN.getListes();
            for (i = 0; i < l.length; ++i) {
                writer.write(l[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Noeuds Synonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenTeS"));
        }
        try {
            writer.write("$$ Types de Liens Synonymes");
            writer.newLine();
            l = this.tableSynonymesT.getListes();
            for (i = 0; i < l.length; ++i) {
                writer.write(l[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Types de Liens Synonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenRTS"));
        }
        try {
            writer.write("$$ Propri\u00e9t\u00e9s Synonymes");
            writer.newLine();
            l = this.tableSynonymesP.getListes();
            for (i = 0; i < l.length; ++i) {
                writer.write(l[i].getSauvegarde());
                writer.newLine();
            }
            writer.write("$$ Fin Propri\u00e9t\u00e9s Synonymes");
            writer.newLine();
            writer.flush();
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotWrittenRPS"));
        }
    }

    public static Confrontation load(File f) throws IOException {
        int i;
        String sy;
        ListeSynonymes ll;
        MotHomonyme m;
        Confrontation res;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
        }
        catch (IOException ioe) {
            throw new IOException(Charte.getMessage("Error_NotOpenSave"));
        }
        String s = "";
        Vector<Graphe> gr = new Vector<Graphe>();
        while (!s.equals("$$ Graphes") && reader.ready()) {
            s = reader.readLine();
        }
        if (!reader.ready()) {
            throw new IOException(Charte.getMessage("Error_EmptySave"));
        }
        try {
            while (!s.equals("$$ Fin Graphes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Graphes")) continue;
                Graphe g = new Graphe("");
                if (s.endsWith("bch")) {
                    g = Chargeur.chargeBCH(new File("dat/pdv/" + s));
                } else if (s.endsWith("leu")) {
                    g = Chargeur.chargeLEU(new File("dat/pdv/" + s));
                } else if (s.endsWith("xml")) {
                    g = Chargeur.chargeLEUEN(new File("dat/pdv/" + s));
                } else if (s.endsWith("two")) {
                    g = Chargeur.chargeTWO(new File("dat/pdv/" + s));
                } else if (s.endsWith("xtm")) {
                    g = Chargeur.chargeXTM(new File("dat/pdv/" + s));
                } else if (s.endsWith("jou")) {
                    g = Chargeur.chargeJOU(new File("dat/pdv/" + s));
                } else if (s.endsWith("mdn")) {
                    g = Chargeur.chargeMDN(new File("dat/pdv/" + s));
                } else {
                    throw new IOException(Charte.getMessage("Error_Format"));
                }
                gr.addElement(g);
            }
            Graphe[] gra = new Graphe[gr.size()];
            gr.toArray(gra);
            res = new Confrontation(gra);
        }
        catch (ImportException ie) {
            throw new IOException(Charte.getMessage("Error_NotReadVP"));
        }
        try {
            HashSet<TexteCommun> mv = new HashSet<TexteCommun>();
            while (!s.equals("$$ Mots Vides")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Mots Vides")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Mots Vides")) continue;
                TexteCommun t = res.trouveMot(s);
                mv.add(t);
            }
            res.listeMotsVides = mv;
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadMV"));
        }
        try {
            res.getRaisonsEloigner();
            while (!s.equals("$$ Noeuds Homonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Noeuds Homonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Noeuds Homonymes")) continue;
                m = new MotHomonyme(s);
                res.addMotPolysemique(m.getMots(), m.getLien(), m.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadTeH"));
        }
        try {
            while (!s.equals("$$ Types de Liens Homonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Types de Liens Homonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Types de Liens Homonymes")) continue;
                m = new MotHomonyme(s);
                res.addTypeLienPolysemique(m.getMots(), m.getLien(), m.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadRTH"));
        }
        try {
            while (!s.equals("$$ Propri\u00e9t\u00e9s Homonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Propri\u00e9t\u00e9s Homonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Propri\u00e9t\u00e9s Homonymes")) continue;
                m = new MotHomonyme(s);
                res.addProprietePolysemique(m.getMots(), m.getLien(), m.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadRPH"));
        }
        res.getRaisonsRapprocher();
        res.getAllTermesNoeuds();
        try {
            while (!s.equals("$$ Noeuds Synonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Noeuds Synonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Noeuds Synonymes")) continue;
                ll = new ListeSynonymes(s);
                sy = "";
                for (i = 0; i < ll.getListe().length; ++i) {
                    sy = sy + ll.getListe()[i].getTexte();
                    if (i >= ll.getListe().length - 1) continue;
                    sy = sy + ";";
                }
                res.addSynonymesNoeuds(sy, ll.getLien(), ll.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadTeS"));
        }
        res.getAllTermesTypesLiens();
        try {
            while (!s.equals("$$ Types de Liens Synonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Types de Liens Synonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Types de Liens Synonymes")) continue;
                ll = new ListeSynonymes(s);
                sy = "";
                for (i = 0; i < ll.getListe().length; ++i) {
                    sy = sy + ll.getListe()[i].getTexte();
                    if (i >= ll.getListe().length - 1) continue;
                    sy = sy + ";";
                }
                res.addSynonymesTypesLiens(sy, ll.getLien(), ll.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadRTS"));
        }
        res.getAllTermesProprietes();
        try {
            while (!s.equals("$$ Propri\u00e9t\u00e9s Synonymes")) {
                s = reader.readLine();
            }
            while (!s.equals("$$ Fin Propri\u00e9t\u00e9s Synonymes")) {
                s = reader.readLine().trim();
                if (s.equals("$$ Fin Propri\u00e9t\u00e9s Synonymes")) continue;
                ll = new ListeSynonymes(s);
                sy = "";
                for (i = 0; i < ll.getListe().length; ++i) {
                    sy = sy + ll.getListe()[i].getTexte();
                    if (i >= ll.getListe().length - 1) continue;
                    sy = sy + ";";
                }
                res.addSynonymesProprietes(sy, ll.getLien(), ll.getCommentaire());
            }
        }
        catch (Exception ie) {
            throw new IOException(Charte.getMessage("Error_NotReadRPS"));
        }
        return res;
    }

    public int getNombreDeGraphes() {
        return this.graphes.length;
    }

    public Graphe getGrapheAt(int i) {
        return this.graphes[i];
    }

    public String[] getAllNomsGraphes() {
        String[] res = new String[this.graphes.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.graphes[i].getNom();
        }
        return res;
    }

    public void setSeuilNoeuds(double seuil) {
        if (seuil < 0.0) {
            seuil = 0.0;
        }
        if (seuil > 1.0) {
            seuil = 1.0;
        }
        this.seuilN = seuil;
    }

    public void setSeuilTypesLiens(double seuil) {
        if (seuil < 0.0) {
            seuil = 0.0;
        }
        if (seuil > 1.0) {
            seuil = 1.0;
        }
        this.seuilT = seuil;
    }

    public void setSeuilProprietes(double seuil) {
        if (seuil < 0.0) {
            seuil = 0.0;
        }
        if (seuil > 1.0) {
            seuil = 1.0;
        }
        this.seuilP = seuil;
    }

    public TexteCommun[] getAllMotsGraphes(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        if (this.allMotsGraphe == null) {
            this.allMotsGraphe = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Noeud[] noeuds = this.graphes[i].getAllNoeuds();
                for (int j = 0; j < noeuds.length; ++j) {
                    String[] l = this.formatage(noeuds[j].getLabel()).split(" ");
                    for (int k = 0; k < l.length; ++k) {
                        if (l[k].length() <= 0) continue;
                        String mot = l[k].trim();
                        TexteCommun tc = (TexteCommun)this.allMotsGraphe.get(mot);
                        if (tc == null) {
                            TexteCommun add = new TexteCommun(mot, this.graphes.length);
                            add.addConcerne(i, true);
                            this.allMotsGraphe.put(mot, add);
                            continue;
                        }
                        tc.addConcerne(i, true);
                    }
                }
                TypeLien[] typesLiens = this.graphes[i].getAllTypesLiens();
                for (int j = 0; j < typesLiens.length; ++j) {
                    String[] l = this.formatage(typesLiens[j].getNom()).split(" ");
                    for (int k = 0; k < l.length; ++k) {
                        if (l[k].length() <= 0) continue;
                        String mot = l[k].trim();
                        TexteCommun tc = (TexteCommun)this.allMotsGraphe.get(mot);
                        if (tc == null) {
                            TexteCommun add = new TexteCommun(mot, this.graphes.length);
                            add.addConcerne(i, true);
                            this.allMotsGraphe.put(mot, add);
                            continue;
                        }
                        tc.addConcerne(i, true);
                    }
                }
                Propriete[] proprietes = this.graphes[i].getAllProprietes();
                for (int j = 0; j < proprietes.length; ++j) {
                    String[] l = this.formatage(proprietes[j].getNom()).split(" ");
                    for (int k = 0; k < l.length; ++k) {
                        if (l[k].length() <= 0) continue;
                        String mot = l[k].trim();
                        TexteCommun tc = (TexteCommun)this.allMotsGraphe.get(mot);
                        if (tc == null) {
                            TexteCommun add = new TexteCommun(mot, this.graphes.length);
                            add.addConcerne(i, true);
                            this.allMotsGraphe.put(mot, add);
                            continue;
                        }
                        tc.addConcerne(i, true);
                    }
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allMotsGraphe.values().size()];
        this.allMotsGraphe.values().toArray(termes);
        Arrays.sort(termes, cmp);
        return termes;
    }

    public TexteCommun trouveMot(String mot) {
        this.getAllMotsGraphes(new ComparateurMotsVides());
        return (TexteCommun)this.allMotsGraphe.get(mot);
    }

    public void addMotVide(String mot) {
        this.getAllMotsGraphes(new ComparateurMotsVides());
        this.listeMotsVides.add((TexteCommun)this.allMotsGraphe.get(mot));
    }

    public void removeMotVide(String mot) {
        this.getAllMotsGraphes(new ComparateurMotsVides());
        this.listeMotsVides.remove((TexteCommun)this.allMotsGraphe.get(mot));
    }

    public TexteCommun[] getListeMotsVides(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        TexteCommun[] res = new TexteCommun[this.listeMotsVides.size()];
        this.listeMotsVides.toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getListeMotsNonVides(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        Vector<TexteCommun> v = new Vector<TexteCommun>();
        TexteCommun[] ss = this.getAllMotsGraphes(cmp);
        Vector motsVides = new Vector(this.listeMotsVides);
        for (int i = 0; i < ss.length; ++i) {
            boolean present = false;
            for (int j = 0; j < motsVides.size(); ++j) {
                if (!motsVides.elementAt(j).equals(ss[i])) continue;
                present = true;
                break;
            }
            if (present) continue;
            v.addElement(ss[i]);
        }
        TexteCommun[] res = new TexteCommun[v.size()];
        v.toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getAllTermesCommuns(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        if (this.allTermesCommuns == null) {
            HashMap<String, TexteCommun> liste = new HashMap<String, TexteCommun>();
            this.allTermesCommuns = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Noeud[] noeuds = this.graphes[i].getAllNoeuds();
                for (int j = 0; j < noeuds.length; ++j) {
                    String terme = noeuds[j].getLabel();
                    TexteCommun tc = (TexteCommun)liste.get(terme);
                    if (tc == null) {
                        tc = new TexteCommun(terme, this.graphes.length);
                        tc.addConcerne(i, true);
                        liste.put(terme, tc);
                        continue;
                    }
                    if (tc.getConcernes()[i]) continue;
                    tc.addConcerne(i, true);
                    this.allTermesCommuns.put(terme, tc);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allTermesCommuns.values().size()];
        this.allTermesCommuns.values().toArray(termes);
        Arrays.sort(termes, cmp);
        return termes;
    }

    public MotHomonyme trouveMotPolysemique(String mot) {
        return (MotHomonyme)this.listePolysemiques.get(mot);
    }

    public void addMotPolysemique(TexteCommun[] repartition, String raison, String commentaires) {
        if (repartition.length > 1) {
            this.ajouteRaisonEloignement(raison);
            String id = repartition[0].getTexte();
            for (int i = 0; i < repartition.length; ++i) {
                for (int j = 0; j < this.graphes.length; ++j) {
                    if (!repartition[i].getConcernes()[j]) continue;
                    this.graphes[j].desambigueHomonyme(repartition[i].getTexte(), i + 1);
                }
                repartition[i] = new TexteCommun(repartition[i].getTexte() + " - " + (i + 1), repartition[i].getConcernes());
            }
            this.allTermesNoeuds = null;
            this.allTermesCommuns = null;
            this.listePolysemiques.put(id, new MotHomonyme(repartition, raison, commentaires));
        }
    }

    public void removeMotPolysemique(String mot) {
        int i;
        MotHomonyme m = (MotHomonyme)this.listePolysemiques.get(mot);
        TexteCommun[] t = m.getMots();
        TexteCommun n = new TexteCommun(t[0].getTexte(), this.graphes.length);
        for (i = 0; i < t.length; ++i) {
            for (int j = 0; j < this.graphes.length; ++j) {
                if (!t[i].getConcernes()[j]) continue;
                n.addConcerne(j, true);
                this.graphes[j].removeDesambiguation(t[i].getTexte());
            }
        }
        for (i = 0; i < t.length; ++i) {
            this.fusionneSynonymieNoeuds(t[i].getTexte(), n);
        }
        this.allTermesNoeuds = null;
        this.allTermesCommuns = null;
        this.listePolysemiques.remove(mot);
    }

    public MotHomonyme[] getListeMotsPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurHomonymes)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        MotHomonyme[] res = new MotHomonyme[this.listePolysemiques.values().size()];
        this.listePolysemiques.values().toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getListeMotsNonPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        Vector<TexteCommun> v = new Vector<TexteCommun>();
        TexteCommun[] ss = this.getAllTermesCommuns(cmp);
        for (int i = 0; i < ss.length; ++i) {
            v.addElement(ss[i]);
        }
        TexteCommun[] res = new TexteCommun[v.size()];
        v.toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getAllTypesLiensCommuns(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        if (this.allTypesLiensCommuns == null) {
            HashMap<String, TexteCommun> liste = new HashMap<String, TexteCommun>();
            this.allTypesLiensCommuns = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                TypeLien[] types = this.graphes[i].getAllTypesLiens();
                for (int j = 0; j < types.length; ++j) {
                    String terme = types[j].getNom();
                    TexteCommun tc = (TexteCommun)liste.get(terme);
                    if (tc == null) {
                        tc = new TexteCommun(terme, this.graphes.length);
                        tc.addConcerne(i, true);
                        liste.put(terme, tc);
                        continue;
                    }
                    if (tc.getConcernes()[i]) continue;
                    tc.addConcerne(i, true);
                    this.allTypesLiensCommuns.put(terme, tc);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allTypesLiensCommuns.values().size()];
        this.allTypesLiensCommuns.values().toArray(termes);
        Arrays.sort(termes, cmp);
        return termes;
    }

    public MotHomonyme trouveTypeLienPolysemique(String mot) {
        return (MotHomonyme)this.listeTLPolysemiques.get(mot);
    }

    public void addTypeLienPolysemique(TexteCommun[] repartition, String raison, String commentaires) {
        if (repartition.length > 1) {
            String id = repartition[0].getTexte();
            this.ajouteRaisonEloignement(raison);
            for (int i = 0; i < repartition.length; ++i) {
                for (int j = 0; j < this.graphes.length; ++j) {
                    if (!repartition[i].getConcernes()[j]) continue;
                    this.graphes[j].desambigueHomonymeTL(repartition[i].getTexte(), i + 1);
                }
                repartition[i] = new TexteCommun(repartition[i].getTexte() + " - " + (i + 1), repartition[i].getConcernes());
            }
            this.allTermesTypesLiens = null;
            this.allTypesLiensCommuns = null;
            this.listeTLPolysemiques.put(id, new MotHomonyme(repartition, raison, commentaires));
        }
    }

    public void removeTypeLienPolysemique(String mot) {
        int i;
        MotHomonyme m = (MotHomonyme)this.listeTLPolysemiques.get(mot);
        TexteCommun[] t = m.getMots();
        TexteCommun n = new TexteCommun(t[0].getTexte(), this.graphes.length);
        for (i = 0; i < t.length; ++i) {
            for (int j = 0; j < this.graphes.length; ++j) {
                if (!t[i].getConcernes()[j]) continue;
                n.addConcerne(j, true);
                this.graphes[j].removeDesambiguationTL(t[i].getTexte());
            }
        }
        for (i = 0; i < t.length; ++i) {
            this.fusionneSynonymieTypesLiens(t[i].getTexte(), n);
        }
        this.allTermesTypesLiens = null;
        this.allTypesLiensCommuns = null;
        this.listeTLPolysemiques.remove(mot);
    }

    public MotHomonyme[] getListeTypesLiensPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurHomonymes)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        MotHomonyme[] res = new MotHomonyme[this.listeTLPolysemiques.values().size()];
        this.listeTLPolysemiques.values().toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getListeTypesLiensNonPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        Vector<TexteCommun> v = new Vector<TexteCommun>();
        TexteCommun[] ss = this.getAllTypesLiensCommuns(cmp);
        for (int i = 0; i < ss.length; ++i) {
            v.addElement(ss[i]);
        }
        TexteCommun[] res = new TexteCommun[v.size()];
        v.toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getAllProprietesCommunes(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        if (this.allProprietesCommunes == null) {
            HashMap<String, TexteCommun> liste = new HashMap<String, TexteCommun>();
            this.allProprietesCommunes = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Propriete[] types = this.graphes[i].getAllProprietes();
                for (int j = 0; j < types.length; ++j) {
                    String terme = types[j].getNom();
                    TexteCommun tc = (TexteCommun)liste.get(terme);
                    if (tc == null) {
                        tc = new TexteCommun(terme, this.graphes.length);
                        tc.addConcerne(i, true);
                        liste.put(terme, tc);
                        continue;
                    }
                    if (tc.getConcernes()[i]) continue;
                    tc.addConcerne(i, true);
                    this.allProprietesCommunes.put(terme, tc);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allProprietesCommunes.values().size()];
        this.allProprietesCommunes.values().toArray(termes);
        Arrays.sort(termes, cmp);
        return termes;
    }

    public MotHomonyme trouveProprietePolysemique(String mot) {
        return (MotHomonyme)this.listePPolysemiques.get(mot);
    }

    public void addProprietePolysemique(TexteCommun[] repartition, String raison, String commentaires) {
        if (repartition.length > 1) {
            String id = repartition[0].getTexte();
            this.ajouteRaisonEloignement(raison);
            for (int i = 0; i < repartition.length; ++i) {
                for (int j = 0; j < this.graphes.length; ++j) {
                    if (!repartition[i].getConcernes()[j]) continue;
                    this.graphes[j].desambigueHomonymeP(repartition[i].getTexte(), i + 1);
                }
                repartition[i] = new TexteCommun(repartition[i].getTexte() + " - " + (i + 1), repartition[i].getConcernes());
            }
            this.allTermesProprietes = null;
            this.allProprietesCommunes = null;
            this.listePPolysemiques.put(id, new MotHomonyme(repartition, raison, commentaires));
        }
    }

    public void removeProprietePolysemique(String mot) {
        int i;
        MotHomonyme m = (MotHomonyme)this.listePPolysemiques.get(mot);
        TexteCommun[] t = m.getMots();
        TexteCommun n = new TexteCommun(t[0].getTexte(), this.graphes.length);
        for (i = 0; i < t.length; ++i) {
            for (int j = 0; j < this.graphes.length; ++j) {
                if (!t[i].getConcernes()[j]) continue;
                n.addConcerne(j, true);
                this.graphes[j].removeDesambiguationP(t[i].getTexte());
            }
        }
        for (i = 0; i < t.length; ++i) {
            this.fusionneSynonymieProprietes(t[i].getTexte(), n);
        }
        this.allTermesProprietes = null;
        this.allProprietesCommunes = null;
        this.listePPolysemiques.remove(mot);
    }

    public MotHomonyme[] getListeProprietesPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurHomonymes)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        MotHomonyme[] res = new MotHomonyme[this.listePPolysemiques.values().size()];
        this.listePPolysemiques.values().toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getListeProprietesNonPolysemiques(Comparator cmp) {
        if (!(cmp instanceof ComparateurMotsVides) && !(cmp instanceof ComparateurTexteCommun)) {
            throw new IllegalArgumentException(Charte.getMessage("Error_WrongComparator"));
        }
        Vector<TexteCommun> v = new Vector<TexteCommun>();
        TexteCommun[] ss = this.getAllProprietesCommunes(cmp);
        for (int i = 0; i < ss.length; ++i) {
            v.addElement(ss[i]);
        }
        TexteCommun[] res = new TexteCommun[v.size()];
        v.toArray(res);
        Arrays.sort(res, cmp);
        return res;
    }

    public TexteCommun[] getAllTermesNoeuds() {
        if (this.allTermesNoeuds == null) {
            this.allTermesNoeuds = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Noeud[] noeuds = this.graphes[i].getAllNoeuds();
                for (int j = 0; j < noeuds.length; ++j) {
                    String terme = noeuds[j].getLabel();
                    TexteCommun tc = (TexteCommun)this.allTermesNoeuds.get(terme);
                    if (tc == null) {
                        TexteCommun add = new TexteCommun(terme, this.graphes.length);
                        add.addConcerne(i, true);
                        this.allTermesNoeuds.put(terme, add);
                        continue;
                    }
                    tc.addConcerne(i, true);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allTermesNoeuds.values().size()];
        this.allTermesNoeuds.values().toArray(termes);
        Arrays.sort(termes, new ComparateurTexteCommun());
        return termes;
    }

    public TexteCommun trouveTermeNoeud(String mot) {
        return (TexteCommun)this.allTermesNoeuds.get(mot);
    }

    public void addSynonymesNoeuds(String synos, String raison, String commentaires) {
        this.ajouteRaisonRapprochement(raison);
        ListeSynonymes liste = new ListeSynonymes(raison, commentaires);
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesNoeuds.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesN.add(liste);
    }

    public void removeSynonymesNoeuds(String synos) {
        ListeSynonymes liste = new ListeSynonymes("", "");
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesNoeuds.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesN.remove(liste);
    }

    private void fusionneSynonymieNoeuds(String nom, TexteCommun fusion) {
        ListeSynonymes[] listes = this.tableSynonymesN.getListes();
        for (int i = 0; i < listes.length; ++i) {
            if (!listes[i].contains(new TexteCommun(nom, this.graphes.length))) continue;
            listes[i].termeFusionne(new TexteCommun(nom, this.graphes.length), fusion);
            if (listes[i].getListe().length >= 2) continue;
            this.tableSynonymesN.remove(listes[i]);
        }
    }

    public ListeSynonymes[] getListesSynonymesNoeuds() {
        return this.tableSynonymesN.getListes();
    }

    public ListeSynonymes[] getListesSynonymesNoeuds(TexteCommun texte) {
        Vector<ListeSynonymes> v = new Vector<ListeSynonymes>();
        if (texte != null) {
            ListeSynonymes[] listes = this.tableSynonymesN.getListes();
            for (int i = 0; i < listes.length; ++i) {
                if (!listes[i].contains(texte)) continue;
                v.addElement(listes[i]);
            }
        }
        ListeSynonymes[] res = new ListeSynonymes[v.size()];
        v.toArray(res);
        return res;
    }

    public ListeSynonymes[] getListesSynonymesNoeuds(MotHomonyme mot) {
        TexteCommun[] t = mot.getMots();
        HashSet<ListeSynonymes> res = new HashSet<ListeSynonymes>();
        for (int i = 0; i < t.length; ++i) {
            ListeSynonymes[] l = this.getListesSynonymesNoeuds(t[i]);
            for (int j = 0; j < l.length; ++j) {
                res.add(l[j]);
            }
        }
        ListeSynonymes[] res2 = new ListeSynonymes[res.size()];
        res.toArray(res2);
        return res2;
    }

    public ListeSynonymes[] getListeCompleteNoeudsLies() {
        Vector<ListeSynonymes> v = new Vector<ListeSynonymes>();
        ListeSynonymes[] synos = this.getListesSynonymesNoeuds();
        for (int i = 0; i < synos.length; ++i) {
            v.add(synos[i]);
        }
        TexteCommun[] nonHomos = this.getListeMotsNonPolysemiques(this.getComparateurAlphabetique());
        for (int i = 0; i < nonHomos.length; ++i) {
            boolean contient = false;
            for (int j = 0; j < synos.length; ++j) {
                if (!synos[j].contains(nonHomos[i])) continue;
                contient = true;
            }
            if (contient) continue;
            ListeSynonymes liste = new ListeSynonymes(RAISON_IDENTITE, "");
            liste.add(nonHomos[i]);
            v.add(liste);
        }
        ListeSynonymes[] l = new ListeSynonymes[v.size()];
        v.toArray(l);
        return l;
    }

    public TexteCommun[] getAllTermesTypesLiens() {
        if (this.allTermesTypesLiens == null) {
            this.allTermesTypesLiens = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                TypeLien[] noeuds = this.graphes[i].getAllTypesLiens();
                for (int j = 0; j < noeuds.length; ++j) {
                    String terme = noeuds[j].getNom();
                    TexteCommun tc = (TexteCommun)this.allTermesTypesLiens.get(terme);
                    if (tc == null) {
                        TexteCommun add = new TexteCommun(terme, this.graphes.length);
                        add.addConcerne(i, true);
                        this.allTermesTypesLiens.put(terme, add);
                        continue;
                    }
                    tc.addConcerne(i, true);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allTermesTypesLiens.values().size()];
        this.allTermesTypesLiens.values().toArray(termes);
        Arrays.sort(termes, new ComparateurTexteCommun());
        return termes;
    }

    public TexteCommun trouveTermeTypeLien(String mot) {
        return (TexteCommun)this.allTermesTypesLiens.get(mot);
    }

    public void addSynonymesTypesLiens(String synos, String raison, String commentaires) {
        this.ajouteRaisonRapprochement(raison);
        ListeSynonymes liste = new ListeSynonymes(raison, commentaires);
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesTypesLiens.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesT.add(liste);
    }

    public void removeSynonymesTypesLiens(String synos) {
        ListeSynonymes liste = new ListeSynonymes("", "");
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesTypesLiens.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesT.remove(liste);
    }

    public ListeSynonymes[] getListesSynonymesTypesLiens() {
        return this.tableSynonymesT.getListes();
    }

    public ListeSynonymes[] getListesSynonymesTypesLiens(TexteCommun texte) {
        Vector<ListeSynonymes> v = new Vector<ListeSynonymes>();
        if (texte != null) {
            ListeSynonymes[] listes = this.tableSynonymesT.getListes();
            for (int i = 0; i < listes.length; ++i) {
                if (!listes[i].contains(texte)) continue;
                v.addElement(listes[i]);
            }
        }
        ListeSynonymes[] res = new ListeSynonymes[v.size()];
        v.toArray(res);
        return res;
    }

    public ListeSynonymes[] getListesSynonymesTypesLiens(MotHomonyme mot) {
        TexteCommun[] t = mot.getMots();
        HashSet<ListeSynonymes> res = new HashSet<ListeSynonymes>();
        for (int i = 0; i < t.length; ++i) {
            ListeSynonymes[] l = this.getListesSynonymesTypesLiens(t[i]);
            for (int j = 0; j < l.length; ++j) {
                res.add(l[j]);
            }
        }
        ListeSynonymes[] res2 = new ListeSynonymes[res.size()];
        res.toArray(res2);
        return res2;
    }

    private void fusionneSynonymieTypesLiens(String nom, TexteCommun fusion) {
        ListeSynonymes[] listes = this.tableSynonymesT.getListes();
        for (int i = 0; i < listes.length; ++i) {
            if (!listes[i].contains(new TexteCommun(nom, this.graphes.length))) continue;
            listes[i].termeFusionne(new TexteCommun(nom, this.graphes.length), fusion);
            if (listes[i].getListe().length >= 2) continue;
            this.tableSynonymesT.remove(listes[i]);
        }
    }

    public TexteCommun[] getAllTermesProprietes() {
        if (this.allTermesProprietes == null) {
            this.allTermesProprietes = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Propriete[] noeuds = this.graphes[i].getAllProprietes();
                for (int j = 0; j < noeuds.length; ++j) {
                    String terme = noeuds[j].getNom();
                    TexteCommun tc = (TexteCommun)this.allTermesProprietes.get(terme);
                    if (tc == null) {
                        TexteCommun add = new TexteCommun(terme, this.graphes.length);
                        add.addConcerne(i, true);
                        this.allTermesProprietes.put(terme, add);
                        continue;
                    }
                    tc.addConcerne(i, true);
                }
            }
        }
        TexteCommun[] termes = new TexteCommun[this.allTermesProprietes.values().size()];
        this.allTermesProprietes.values().toArray(termes);
        Arrays.sort(termes, new ComparateurTexteCommun());
        return termes;
    }

    public TexteCommun trouveTermePropriete(String mot) {
        return (TexteCommun)this.allTermesProprietes.get(mot);
    }

    public void addSynonymesProprietes(String synos, String raison, String commentaires) {
        this.ajouteRaisonRapprochement(raison);
        ListeSynonymes liste = new ListeSynonymes(raison, commentaires);
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesProprietes.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesP.add(liste);
    }

    public void removeSynonymesProprietes(String synos) {
        ListeSynonymes liste = new ListeSynonymes("", "");
        String[] s = synos.split(";");
        for (int i = 0; i < s.length; ++i) {
            TexteCommun tc = (TexteCommun)this.allTermesProprietes.get(s[i]);
            liste.add(tc);
        }
        this.tableSynonymesP.remove(liste);
    }

    public ListeSynonymes[] getListesSynonymesProprietes() {
        return this.tableSynonymesP.getListes();
    }

    public ListeSynonymes[] getListesSynonymesProprietes(TexteCommun texte) {
        Vector<ListeSynonymes> v = new Vector<ListeSynonymes>();
        if (texte != null) {
            ListeSynonymes[] listes = this.tableSynonymesP.getListes();
            for (int i = 0; i < listes.length; ++i) {
                if (!listes[i].contains(texte)) continue;
                v.addElement(listes[i]);
            }
        }
        ListeSynonymes[] res = new ListeSynonymes[v.size()];
        v.toArray(res);
        return res;
    }

    public ListeSynonymes[] getListesSynonymesProprietes(MotHomonyme mot) {
        TexteCommun[] t = mot.getMots();
        HashSet<ListeSynonymes> res = new HashSet<ListeSynonymes>();
        for (int i = 0; i < t.length; ++i) {
            ListeSynonymes[] l = this.getListesSynonymesProprietes(t[i]);
            for (int j = 0; j < l.length; ++j) {
                res.add(l[j]);
            }
        }
        ListeSynonymes[] res2 = new ListeSynonymes[res.size()];
        res.toArray(res2);
        return res2;
    }

    private void fusionneSynonymieProprietes(String nom, TexteCommun fusion) {
        ListeSynonymes[] listes = this.tableSynonymesP.getListes();
        for (int i = 0; i < listes.length; ++i) {
            if (!listes[i].contains(new TexteCommun(nom, this.graphes.length))) continue;
            listes[i].termeFusionne(new TexteCommun(nom, this.graphes.length), fusion);
            if (listes[i].getListe().length >= 2) continue;
            this.tableSynonymesP.remove(listes[i]);
        }
    }

    public ListeSynonymes[] suggereNoeudsSynonymes() {
        Vector<ListeSynonymes> res = new Vector<ListeSynonymes>();
        TexteCommun[] termes = this.getAllTermesNoeuds();
        for (int i = 0; i < termes.length; ++i) {
            for (int j = i + 1; j < termes.length; ++j) {
                double fiabilite;
                if (termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilN)) continue;
                ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
                l.add(termes[i]);
                l.add(termes[j]);
                res.add(l);
            }
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.size()];
        res.toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public ListeSynonymes[] suggereNoeudsSynonymes(int ms) {
        HashMap<String, ListeSynonymes> res = new HashMap<String, ListeSynonymes>();
        long time = System.currentTimeMillis();
        TexteCommun[] termes = this.getAllTermesNoeuds();
        while (System.currentTimeMillis() <= time + (long)ms) {
            double fiabilite;
            int j;
            int i = (int)(Math.random() * (double)termes.length);
            if (i == (j = (int)(Math.random() * (double)termes.length)) || termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilN)) continue;
            ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
            l.add(termes[i]);
            l.add(termes[j]);
            res.put(l.getSauvegarde(), l);
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.values().size()];
        res.values().toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public ListeSynonymes[] suggereTypesLiensSynonymes() {
        Vector<ListeSynonymes> res = new Vector<ListeSynonymes>();
        TexteCommun[] termes = this.getAllTermesTypesLiens();
        for (int i = 0; i < termes.length; ++i) {
            for (int j = i + 1; j < termes.length; ++j) {
                double fiabilite;
                if (termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilT)) continue;
                ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
                l.add(termes[i]);
                l.add(termes[j]);
                res.add(l);
            }
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.size()];
        res.toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public ListeSynonymes[] suggereTypesLiensSynonymes(int ms) {
        HashMap<String, ListeSynonymes> res = new HashMap<String, ListeSynonymes>();
        long time = System.currentTimeMillis();
        TexteCommun[] termes = this.getAllTermesTypesLiens();
        while (System.currentTimeMillis() < time + (long)ms) {
            double fiabilite;
            int j;
            int i = (int)(Math.random() * (double)termes.length);
            if (i == (j = (int)(Math.random() * (double)termes.length)) || termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilT)) continue;
            ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
            l.add(termes[i]);
            l.add(termes[j]);
            res.put(l.getSauvegarde(), l);
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.values().size()];
        res.values().toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public ListeSynonymes[] suggereProprietesSynonymes() {
        Vector<ListeSynonymes> res = new Vector<ListeSynonymes>();
        TexteCommun[] termes = this.getAllTermesProprietes();
        for (int i = 0; i < termes.length; ++i) {
            for (int j = i + 1; j < termes.length; ++j) {
                double fiabilite;
                if (termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilP)) continue;
                ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
                l.add(termes[i]);
                l.add(termes[j]);
                res.add(l);
            }
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.size()];
        res.toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public ListeSynonymes[] suggereProprietesSynonymes(int ms) {
        HashMap<String, ListeSynonymes> res = new HashMap<String, ListeSynonymes>();
        long time = System.currentTimeMillis();
        TexteCommun[] termes = this.getAllTermesProprietes();
        while (System.currentTimeMillis() < time + (long)ms) {
            double fiabilite;
            int j;
            int i = (int)(Math.random() * (double)termes.length);
            if (i == (j = (int)(Math.random() * (double)termes.length)) || termes[i].hasPVCommun(termes[j]) || !((fiabilite = this.testeConcordance(termes[i], termes[j]) * this.testeConcordance(termes[j], termes[i])) > this.seuilP)) continue;
            ListeSynonymes l = new ListeSynonymes(Charte.getMessage("Conf_SurA") + " " + (int)(fiabilite * 100.0) + "%", "");
            l.add(termes[i]);
            l.add(termes[j]);
            res.put(l.getSauvegarde(), l);
        }
        ListeSynonymes[] res3 = new ListeSynonymes[res.values().size()];
        res.values().toArray(res3);
        Arrays.sort(res3, new ComparateurSynonymes());
        return res3;
    }

    public String[] getRaisonsRapprocher() {
        if (this.raisonsRapprochement == null) {
            this.raisonsRapprochement = new Vector();
            this.raisonsRapprochement.addElement(Charte.getMessage("Conf_Syno"));
            this.raisonsRapprochement.addElement(Charte.getMessage("Conf_Proches"));
            this.raisonsRapprochement.addElement(Charte.getMessage("Conf_Lies"));
            this.raisonsRapprochement.addElement(RAISON_A_PRECISER);
        }
        String[] res = new String[this.raisonsRapprochement.size()];
        this.raisonsRapprochement.toArray(res);
        return res;
    }

    public void ajouteRaisonRapprochement(String raison) {
        boolean nouveau = true;
        for (int i = 0; i < this.raisonsRapprochement.size(); ++i) {
            if (!((String)this.raisonsRapprochement.elementAt(i)).equals(raison)) continue;
            nouveau = false;
            break;
        }
        if (nouveau) {
            this.raisonsRapprochement.insertElementAt(raison, this.raisonsRapprochement.size() - 1);
        }
    }

    public String[] getRaisonsEloigner() {
        if (this.raisonsEloignement == null) {
            this.raisonsEloignement = new Vector();
            this.raisonsEloignement.addElement(Charte.getMessage("Conf_Homo"));
            this.raisonsEloignement.addElement(Charte.getMessage("Conf_Poly"));
            this.raisonsEloignement.addElement(Charte.getMessage("Conf_PasPar"));
            this.raisonsEloignement.addElement(RAISON_A_PRECISER);
        }
        String[] res = new String[this.raisonsEloignement.size()];
        this.raisonsEloignement.toArray(res);
        return res;
    }

    public void ajouteRaisonEloignement(String raison) {
        boolean nouveau = true;
        for (int i = 0; i < this.raisonsEloignement.size(); ++i) {
            if (!((String)this.raisonsEloignement.elementAt(i)).equals(raison)) continue;
            nouveau = false;
            break;
        }
        if (nouveau) {
            this.raisonsEloignement.insertElementAt(raison, this.raisonsEloignement.size() - 1);
        }
    }

    private double testeConcordance(TexteCommun terme1, TexteCommun terme2) {
        boolean ok = false;
        String t1 = this.enleveMotsVides(this.formatage(terme1.getTexte()));
        String t2 = this.enleveMotsVides(this.formatage(terme2.getTexte()));
        int lettresCommunes = 0;
        int indexTerme1 = 0;
        int indexTerme2 = 0;
        int max = 0;
        for (int i = 0; i < t1.length(); ++i) {
            indexTerme1 = i;
            lettresCommunes = 0;
            while (indexTerme1 < t1.length() && indexTerme2 < t2.length()) {
                if (t1.charAt(indexTerme1) == t2.charAt(indexTerme2)) {
                    ++indexTerme1;
                    ++indexTerme2;
                    ++lettresCommunes;
                    continue;
                }
                ++indexTerme1;
            }
            if (lettresCommunes <= max) continue;
            max = lettresCommunes;
        }
        return 1.0 * (double)max / (double)t2.length();
    }

    private String enleveMotsVides(String s) {
        int i;
        String[] mots = this.formatage(s).trim().split(" ");
        Vector<String> motsV = new Vector<String>();
        for (int i2 = 0; i2 < mots.length; ++i2) {
            motsV.addElement(mots[i2]);
        }
        Vector mv = new Vector(this.listeMotsVides);
        block1: for (int h = 0; h < motsV.size(); ++h) {
            for (i = 0; i < mv.size(); ++i) {
                if (!((String)motsV.elementAt(h)).equalsIgnoreCase(((TexteCommun)mv.elementAt(i)).getTexte())) continue;
                motsV.remove(h);
                --h;
                continue block1;
            }
        }
        String res = "";
        for (i = 0; i < motsV.size(); ++i) {
            res = res + (String)motsV.elementAt(i) + " ";
        }
        return res.trim();
    }

    private String formatage(String s) {
        s = s.toLowerCase();
        s = s.replaceAll("\u00e1|\u00e0|\u00e2|\u00e4|\u00e5", "a");
        s = s.replaceAll("\u00df", "ss");
        s = s.replaceAll("\u00e7", "c");
        s = s.replaceAll("\u00e9|\u00e8|\u00ea|\u00eb", "e");
        s = s.replaceAll("\u00ed|\u00ec|\u00ee|\u00ef", "i");
        s = s.replaceAll("\u00f1", "n");
        s = s.replaceAll("\u00f3|\u00f2|\u00f4|\u00f6", "o");
        s = s.replaceAll("\u00fa|\u00f9|\u00fb|\u00fc", "u");
        s = s.replaceAll("\u00ff", "y");
        s = s.replaceAll("\\W", "");
        return s;
    }

    public LienEntreListes[] getListesLiees(ListeSynonymes l) {
        if (this.allTermesNoeuds == null) {
            this.allTermesNoeuds = new HashMap();
            for (int i = 0; i < this.graphes.length; ++i) {
                Noeud[] noeuds = this.graphes[i].getAllNoeuds();
                for (int j = 0; j < noeuds.length; ++j) {
                    String terme = noeuds[j].getLabel();
                    TexteCommun tc = (TexteCommun)this.allTermesNoeuds.get(terme);
                    if (tc == null) {
                        TexteCommun add = new TexteCommun(terme, this.graphes.length);
                        add.addConcerne(i, true);
                        this.allTermesNoeuds.put(terme, add);
                        continue;
                    }
                    tc.addConcerne(i, true);
                }
            }
        }
        HashSet<LienEntreListes> res = new HashSet<LienEntreListes>();
        TexteCommun[] mots = l.getListe();
        for (int i = 0; i < mots.length; ++i) {
            for (int j = 0; j < this.graphes.length; ++j) {
                if (!mots[i].getConcernes()[j]) continue;
                Association[] liens = this.graphes[j].getAssociationsContenant(this.graphes[j].trouveNoeud(mots[i].getTexte()));
                for (int k = 0; k < liens.length; ++k) {
                    String orig = liens[k].getOrigine().getLabel();
                    String dest = liens[k].getDestination().getLabel();
                    String autre = "";
                    autre = orig.equals(mots[i].getTexte()) ? dest : orig;
                    TexteCommun motLie = (TexteCommun)this.allTermesNoeuds.get(autre);
                    ListeSynonymes[] synos = this.getListesSynonymesNoeuds();
                    boolean trouve = false;
                    for (int m = 0; m < synos.length; ++m) {
                        if (!synos[m].contains(motLie)) continue;
                        trouve = true;
                        res.add(new LienEntreListes(l, synos[m]));
                    }
                    if (trouve) continue;
                    ListeSynonymes lDest = new ListeSynonymes("", "");
                    lDest.add(motLie);
                    res.add(new LienEntreListes(l, lDest));
                }
            }
        }
        LienEntreListes[] res2 = new LienEntreListes[res.size()];
        res.toArray(res2);
        return res2;
    }

    public String toString() {
        return "Confronteur de " + this.graphes.length + " points de vue.";
    }

    public Comparator getComparateurHomonymes() {
        return new ComparateurHomonymes();
    }

    public Comparator getComparateurAlphabetique() {
        return new ComparateurTexteCommun();
    }

    public Comparator getComparateurParNbLettres() {
        return new ComparateurMotsVides();
    }

    private class ComparateurHomonymes
    implements Comparator {
        private ComparateurHomonymes() {
        }

        public int compare(Object o1, Object o2) {
            MotHomonyme l1 = (MotHomonyme)o1;
            MotHomonyme l2 = (MotHomonyme)o2;
            return l1.getMots()[0].getTexte().compareToIgnoreCase(l2.getMots()[0].getTexte());
        }
    }

    private class ComparateurSynonymes
    implements Comparator {
        private ComparateurSynonymes() {
        }

        public int compare(Object o1, Object o2) {
            ListeSynonymes l1 = (ListeSynonymes)o1;
            ListeSynonymes l2 = (ListeSynonymes)o2;
            String[] parse1 = l1.getLien().split(" ");
            String[] parse2 = l2.getLien().split(" ");
            String nb1 = parse1[parse1.length - 1];
            String nb2 = parse2[parse2.length - 1];
            int i1 = Integer.parseInt(nb1.substring(0, nb1.length() - 1));
            int i2 = Integer.parseInt(nb2.substring(0, nb2.length() - 1));
            return i2 - i1;
        }
    }

    private class ComparateurString
    implements Comparator {
        private ComparateurString() {
        }

        public int compare(Object o1, Object o2) {
            int a = Confrontation.this.formatage((String)o1).compareToIgnoreCase(Confrontation.this.formatage((String)o2));
            return a;
        }
    }

    private class ComparateurTexteCommun
    implements Comparator {
        private ComparateurTexteCommun() {
        }

        public int compare(Object o1, Object o2) {
            int a = Confrontation.this.formatage(((TexteCommun)o1).getTexte()).compareToIgnoreCase(Confrontation.this.formatage(((TexteCommun)o2).getTexte()));
            return a;
        }
    }

    private class ComparateurMotsVides
    implements Comparator {
        private ComparateurMotsVides() {
        }

        public int compare(Object o1, Object o2) {
            int a = ((TexteCommun)o1).getTexte().length() - ((TexteCommun)o2).getTexte().length();
            if (a == 0) {
                a = Confrontation.this.formatage(((TexteCommun)o1).getTexte()).compareToIgnoreCase(Confrontation.this.formatage(((TexteCommun)o2).getTexte()));
            }
            return a;
        }
    }

    private class TableSynonymes {
        private Vector liste = new Vector();

        public void add(ListeSynonymes synos) {
            this.liste.add(synos);
            this.controleIntersections();
        }

        public void remove(ListeSynonymes synos) {
            this.liste.remove(synos);
        }

        private void controleIntersections() {
            block0: for (int i = 0; i < this.liste.size(); ++i) {
                for (int j = i + 1; j < this.liste.size(); ++j) {
                    ListeSynonymes l2;
                    ListeSynonymes l1 = (ListeSynonymes)this.liste.elementAt(i);
                    if (!l1.intersects(l2 = (ListeSynonymes)this.liste.elementAt(j)) || l1.equals(l2)) continue;
                    l1.mergeWith(l2);
                    this.liste.remove(l2);
                    --j;
                    --i;
                    continue block0;
                }
            }
        }

        public ListeSynonymes[] getListes() {
            ListeSynonymes[] res = new ListeSynonymes[this.liste.size()];
            this.liste.toArray(res);
            return res;
        }
    }
}

