/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Association;
import data.Graphe;
import data.ImportException;
import data.Lien;
import data.Noeud;
import data.Propriete;
import data.TypeLien;
import data.TypeNoeud;
import data.xml.DOMCreationFailureException;
import data.xml.XMLReader;
import ihm.Charte;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Chargeur {
    private static int idCat = 1;
    private static int idCatL = 0;

    public static Graphe chargeLEU(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList noeuds = doc.getElementsByTagName("noeud");
            for (int i = 0; i < noeuds.getLength(); ++i) {
                Node noeud = noeuds.item(i);
                NamedNodeMap atts = noeud.getAttributes();
                resultat.addNoeud(Integer.parseInt(atts.getNamedItem("id").getNodeValue().trim()), new Noeud(atts.getNamedItem("nom").getNodeValue().trim(), new TypeNoeud(atts.getNamedItem("type").getNodeValue().trim())));
            }
            NodeList liens = doc.getElementsByTagName("lien");
            for (int i = 0; i < liens.getLength(); ++i) {
                Node lien = liens.item(i);
                NamedNodeMap atts = lien.getAttributes();
                resultat.addLien(Integer.parseInt(atts.getNamedItem("id").getNodeValue().trim()), new Lien(atts.getNamedItem("nom").getNodeValue().trim(), new TypeLien(atts.getNamedItem("type").getNodeValue().trim())));
            }
            NodeList typesNoeuds = doc.getElementsByTagName("typenoeud");
            for (int i = 0; i < typesNoeuds.getLength(); ++i) {
                Node typeNoeud = typesNoeuds.item(i);
                NamedNodeMap atts = typeNoeud.getAttributes();
                resultat.addTypeNoeud(i, new TypeNoeud(atts.getNamedItem("nom").getNodeValue().trim()));
            }
            NodeList associations = doc.getElementsByTagName("association");
            for (int i = 0; i < associations.getLength(); ++i) {
                Node association = associations.item(i);
                NamedNodeMap atts = association.getAttributes();
                resultat.addAssociation(Integer.parseInt(atts.getNamedItem("lien").getNodeValue().trim()), Integer.parseInt(atts.getNamedItem("orig").getNodeValue().trim()), Integer.parseInt(atts.getNamedItem("dest").getNodeValue().trim()));
            }
            NodeList typesLiens = doc.getElementsByTagName("typelien");
            for (int i = 0; i < typesLiens.getLength(); ++i) {
                Node typeLien = typesLiens.item(i);
                NamedNodeMap atts = typeLien.getAttributes();
                NodeList props = typeLien.getChildNodes();
                Vector<String> rangeP = new Vector<String>();
                Vector<String> rangeV = new Vector<String>();
                for (int j = 0; j < props.getLength(); ++j) {
                    Node prop = props.item(j);
                    if (!prop.getNodeName().equalsIgnoreCase("propriete")) continue;
                    NamedNodeMap pv = prop.getAttributes();
                    rangeP.addElement(pv.getNamedItem("nom").getNodeValue().trim());
                    rangeV.addElement(pv.getNamedItem("val").getNodeValue().trim());
                }
                Propriete[] proprietes = new Propriete[rangeP.size()];
                for (int j = 0; j < rangeP.size(); ++j) {
                    String s = ((String)rangeV.elementAt(j)).trim();
                    int val = -1;
                    if (s.toLowerCase().equals("vrai") || s.toLowerCase().equals("true") || s.toLowerCase().equals("toujours") || s.toLowerCase().equals("always") || s.toLowerCase().equals("oui") || s.toLowerCase().equals("yes")) {
                        val = 1;
                    }
                    if (s.toLowerCase().equals("faux") || s.toLowerCase().equals("false") || s.toLowerCase().equals("jamais") || s.toLowerCase().equals("never") || s.toLowerCase().equals("non") || s.toLowerCase().equals("no")) {
                        val = 0;
                    }
                    proprietes[j] = new Propriete(rangeP.elementAt(j).toString(), val);
                }
                resultat.addTypeLien(i, new TypeLien(atts.getNamedItem("nom").getNodeValue().trim(), proprietes));
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    public static Graphe chargeLEUEN(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList noeuds = doc.getElementsByTagName("node");
            for (int i = 0; i < noeuds.getLength(); ++i) {
                Node noeud = noeuds.item(i);
                NamedNodeMap atts = noeud.getAttributes();
                resultat.addNoeud(Integer.parseInt(atts.getNamedItem("id").getNodeValue().trim()), new Noeud(atts.getNamedItem("name").getNodeValue().trim(), new TypeNoeud(atts.getNamedItem("type").getNodeValue().trim())));
            }
            NodeList liens = doc.getElementsByTagName("link");
            for (int i = 0; i < liens.getLength(); ++i) {
                Node lien = liens.item(i);
                NamedNodeMap atts = lien.getAttributes();
                resultat.addLien(Integer.parseInt(atts.getNamedItem("id").getNodeValue().trim()), new Lien(atts.getNamedItem("name").getNodeValue().trim(), new TypeLien(atts.getNamedItem("type").getNodeValue().trim())));
            }
            NodeList typesNoeuds = doc.getElementsByTagName("nodetype");
            for (int i = 0; i < typesNoeuds.getLength(); ++i) {
                Node typeNoeud = typesNoeuds.item(i);
                NamedNodeMap atts = typeNoeud.getAttributes();
                resultat.addTypeNoeud(i, new TypeNoeud(atts.getNamedItem("name").getNodeValue().trim()));
            }
            NodeList associations = doc.getElementsByTagName("edge");
            for (int i = 0; i < associations.getLength(); ++i) {
                Node association = associations.item(i);
                NamedNodeMap atts = association.getAttributes();
                resultat.addAssociation(Integer.parseInt(atts.getNamedItem("link").getNodeValue().trim()), Integer.parseInt(atts.getNamedItem("from").getNodeValue().trim()), Integer.parseInt(atts.getNamedItem("to").getNodeValue().trim()));
            }
            NodeList typesLiens = doc.getElementsByTagName("linktype");
            for (int i = 0; i < typesLiens.getLength(); ++i) {
                Node typeLien = typesLiens.item(i);
                NamedNodeMap atts = typeLien.getAttributes();
                NodeList props = typeLien.getChildNodes();
                Vector<String> rangeP = new Vector<String>();
                Vector<String> rangeV = new Vector<String>();
                for (int j = 0; j < props.getLength(); ++j) {
                    Node prop = props.item(j);
                    if (!prop.getNodeName().equalsIgnoreCase("property")) continue;
                    NamedNodeMap pv = prop.getAttributes();
                    rangeP.addElement(pv.getNamedItem("name").getNodeValue().trim());
                    rangeV.addElement(pv.getNamedItem("value").getNodeValue().trim());
                }
                Propriete[] proprietes = new Propriete[rangeP.size()];
                for (int j = 0; j < rangeP.size(); ++j) {
                    String s = ((String)rangeV.elementAt(j)).trim();
                    int val = -1;
                    if (s.toLowerCase().equals("vrai") || s.toLowerCase().equals("true") || s.toLowerCase().equals("toujours") || s.toLowerCase().equals("always") || s.toLowerCase().equals("oui") || s.toLowerCase().equals("yes")) {
                        val = 1;
                    }
                    if (s.toLowerCase().equals("faux") || s.toLowerCase().equals("false") || s.toLowerCase().equals("jamais") || s.toLowerCase().equals("never") || s.toLowerCase().equals("non") || s.toLowerCase().equals("no")) {
                        val = 0;
                    }
                    proprietes[j] = new Propriete(rangeP.elementAt(j).toString(), val);
                }
                resultat.addTypeLien(i, new TypeLien(atts.getNamedItem("name").getNodeValue().trim(), proprietes));
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    public static Graphe chargeBCH(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        resultat.addTypeNoeud(0, new TypeNoeud("descripteur"));
        Propriete[] props = new Propriete[]{new Propriete("Transitivit\u00e9", 1), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 0)};
        resultat.addTypeLien(0, new TypeLien("sp\u00e9cialisation", props));
        Propriete[] props2 = new Propriete[]{new Propriete("Transitivit\u00e9", 1), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 1)};
        resultat.addTypeLien(1, new TypeLien("sp\u00e9cialisation optionnelle", props2));
        int idLien = -1;
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList lieux = doc.getElementsByTagName("LIEU");
            for (int i = 0; i < lieux.getLength(); ++i) {
                int j;
                Node lieu = lieux.item(i);
                NamedNodeMap atts = lieu.getAttributes();
                NodeList liste = lieu.getChildNodes();
                int id = Integer.parseInt(atts.getNamedItem("ID").getNodeValue().trim());
                String nom = "";
                Vector<Integer> idLiens = new Vector<Integer>();
                Vector<Integer> idSL = new Vector<Integer>();
                for (j = 0; j < liste.getLength(); ++j) {
                    Node item = liste.item(j);
                    if (item.getNodeName().equals("NOM")) {
                        nom = item.getChildNodes().item(0).getNodeValue().trim();
                    }
                    if (!item.getNodeName().equals("ID_SOUS_LIEU")) continue;
                    idSL.add(Integer.valueOf(item.getChildNodes().item(0).getNodeValue().trim()));
                    if (item.getAttributes().getNamedItem("CERTAIN").getNodeValue().equals("OUI")) {
                        resultat.addLien(++idLien, new Lien("contient", new TypeLien("sp\u00e9cialisation")));
                        idLiens.add(new Integer(idLien));
                        continue;
                    }
                    resultat.addLien(++idLien, new Lien("contient", new TypeLien("sp\u00e9cialisation optionnelle")));
                    idLiens.add(new Integer(idLien));
                }
                resultat.addNoeud(id, new Noeud(nom, new TypeNoeud("descripteur")));
                for (j = 0; j < idLiens.size(); ++j) {
                    resultat.addAssociation((Integer)idLiens.elementAt(j), id, (Integer)idSL.elementAt(j));
                }
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    public static Graphe chargeTWO(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        TypeNoeud image = new TypeNoeud("Image");
        resultat.addTypeNoeud(image);
        TypeNoeud son = new TypeNoeud("Son");
        resultat.addTypeNoeud(son);
        Propriete[] props0 = new Propriete[]{new Propriete("Transitivit\u00e9", 0), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 0)};
        TypeLien ressourceDe = new TypeLien("ressource de", props0);
        resultat.addTypeLien(10000, ressourceDe);
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList typesLiens = doc.getElementsByTagName("RELATION_TYPE");
            for (int i = 0; i < typesLiens.getLength(); ++i) {
                Node typeLien = typesLiens.item(i);
                NamedNodeMap atts = typeLien.getAttributes();
                int id = Integer.parseInt(atts.getNamedItem("ID").getNodeValue());
                NodeList data = typeLien.getChildNodes();
                String nom = "";
                boolean sym = false;
                boolean trns = false;
                boolean mbo = false;
                String desc = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    if (data.item(j).getNodeName().equals("RELATION_NAME")) {
                        nom = data.item(j).getChildNodes().item(0).getNodeValue().trim();
                    }
                    if (data.item(j).getNodeName().equals("RELATION_DEF")) {
                        desc = data.item(j).getChildNodes().item(0).getNodeValue().trim();
                    }
                    if (!data.item(j).getNodeName().equals("RELATION_PROPERTIES")) continue;
                    NamedNodeMap prop = data.item(j).getAttributes();
                    sym = Boolean.getBoolean(prop.getNamedItem("SYMMETRIC").getNodeValue().trim());
                    trns = Boolean.getBoolean(prop.getNamedItem("TRANSITIVE").getNodeValue().trim());
                    mbo = Boolean.getBoolean(prop.getNamedItem("MAYBEOPTIONAL").getNodeValue().trim());
                }
                Propriete p = new Propriete("Sym\u00e9trie", sym ? 1 : -1);
                Propriete p2 = new Propriete("Transitivit\u00e9", trns ? 1 : -1);
                Propriete p3 = new Propriete("Optionnel", mbo ? -1 : 0);
                Propriete[] props = new Propriete[]{p, p2, p3};
                TypeLien tL = new TypeLien(nom, props);
                tL.setDescription(desc);
                resultat.addTypeLien(id + 1, tL);
            }
            NodeList domaines = doc.getElementsByTagName("DOMAIN");
            for (int i = 0; i < domaines.getLength(); ++i) {
                Node domaine = domaines.item(i);
                NamedNodeMap atts = domaine.getAttributes();
                int id = Integer.parseInt(atts.getNamedItem("ID").getNodeValue().trim());
                NodeList data = domaine.getChildNodes();
                String nom = "";
                String desc = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    if (data.item(j).getNodeName().equals("DOMAIN_NAME")) {
                        nom = data.item(j).getChildNodes().item(0).getNodeValue().trim();
                    }
                    if (!data.item(j).getNodeName().equals("DOMAIN_DEF")) continue;
                    desc = data.item(j).getChildNodes().item(0).getNodeValue().trim();
                }
                TypeNoeud tN = new TypeNoeud(nom);
                tN.setDescription(desc);
                resultat.addTypeNoeud(id, tN);
            }
            NodeList concepts = doc.getElementsByTagName("CONCEPT");
            for (int i = 0; i < concepts.getLength(); ++i) {
                int id0;
                int j;
                Node concept = concepts.item(i);
                NamedNodeMap atts = concept.getAttributes();
                int id = Integer.parseInt(atts.getNamedItem("ID").getNodeValue().trim());
                NodeList data = concept.getChildNodes();
                String nom = "";
                String desc = "";
                Vector<Noeud> images = new Vector<Noeud>();
                Vector<Noeud> sons = new Vector<Noeud>();
                int dom = 0;
                for (int j2 = 0; j2 < data.getLength(); ++j2) {
                    if (data.item(j2).getNodeName().equals("CONCEPT_NAME")) {
                        nom = data.item(j2).getChildNodes().item(0).getNodeValue().trim();
                    }
                    if (data.item(j2).getNodeName().equals("CONCEPT_DOMAIN")) {
                        dom = Integer.parseInt(data.item(j2).getAttributes().getNamedItem("ID").getNodeValue().trim());
                    }
                    if (data.item(j2).getNodeName().equals("CONCEPT_DEFS")) {
                        NodeList defs = data.item(j2).getChildNodes();
                        boolean defTrouvee = false;
                        block13: for (int k = 0; k < defs.getLength(); ++k) {
                            Node df = defs.item(k);
                            if (!df.getNodeName().equals("CONCEPT_DEF")) continue;
                            NodeList sdf = df.getChildNodes();
                            for (int l = 0; l < sdf.getLength(); ++l) {
                                if (!sdf.item(l).getNodeName().equals("CONCEPT_DEF_TEXT")) continue;
                                if (defTrouvee) {
                                    desc = desc + "<br><br>";
                                }
                                desc = desc + sdf.item(l).getChildNodes().item(0).getNodeValue().trim();
                                defTrouvee = true;
                                continue block13;
                            }
                        }
                    }
                    if (!data.item(j2).getNodeName().equals("MULTIMEDIA")) continue;
                    NodeList ress = data.item(j2).getChildNodes();
                    for (int k = 0; k < ress.getLength(); ++k) {
                        Node res = ress.item(k);
                        if (!res.getNodeName().equals("RESOURCE")) continue;
                        NodeList datars = res.getChildNodes();
                        for (int l = 0; l < datars.getLength(); ++l) {
                            Noeud n;
                            Node datar = datars.item(l);
                            if (!datar.getNodeName().equals("URI")) continue;
                            String uri = datar.getChildNodes().item(0).getNodeValue().trim();
                            if (uri.endsWith("jpg") || uri.endsWith("gif") || uri.endsWith("png")) {
                                n = new Noeud("file:/" + new File("dat/pdv/" + uri).getAbsolutePath().replaceAll("\\\\", "/"), image);
                                images.addElement(n);
                            }
                            if (!uri.endsWith("au") && !uri.endsWith("mid") && !uri.endsWith("wav")) continue;
                            n = new Noeud("file:/" + new File("dat/pdv/" + uri).getAbsolutePath().replaceAll("\\\\", "/"), son);
                            sons.addElement(n);
                        }
                    }
                }
                Noeud n = new Noeud(nom, resultat.getTypeNoeud(dom));
                n.setDescription(desc);
                resultat.addNoeud(id, n);
                for (j = 0; j < images.size(); ++j) {
                    Noeud nn = (Noeud)images.elementAt(j);
                    id0 = Integer.parseInt(j + 1 + "0" + id);
                    int idL0 = Integer.parseInt("1" + id0);
                    resultat.addNoeud(id0, nn);
                    Lien l = new Lien("", ressourceDe);
                    resultat.addLien(idL0, l);
                    resultat.addAssociation(new Association(l, nn, n));
                }
                for (j = 0; j < sons.size(); ++j) {
                    Noeud nn = (Noeud)sons.elementAt(j);
                    id0 = Integer.parseInt(j + 1 + "1" + id);
                    int idL0 = Integer.parseInt("1" + id0);
                    resultat.addNoeud(id0, nn);
                    Lien l = new Lien("", ressourceDe);
                    resultat.addLien(idL0, l);
                    resultat.addAssociation(new Association(l, nn, n));
                }
            }
            NodeList relations = doc.getElementsByTagName("RELATION");
            for (int i = 0; i < relations.getLength(); ++i) {
                Node relation = relations.item(i);
                NodeList data = relation.getChildNodes();
                int type = 0;
                int orig = 0;
                int dest = 0;
                for (int j = 0; j < data.getLength(); ++j) {
                    if (data.item(j).getNodeName().equals("CONCEPT_ORIG")) {
                        orig = Integer.parseInt(data.item(j).getAttributes().getNamedItem("ID").getNodeValue().trim());
                    }
                    if (data.item(j).getNodeName().equals("CONCEPT_DEST")) {
                        dest = Integer.parseInt(data.item(j).getAttributes().getNamedItem("ID").getNodeValue().trim());
                    }
                    if (!data.item(j).getNodeName().equals("TYPE")) continue;
                    type = Integer.parseInt(data.item(j).getAttributes().getNamedItem("ID").getNodeValue().trim());
                }
                Lien l = new Lien("", resultat.getTypeLien(type + 1));
                Association a = new Association(l, resultat.getNoeud(orig), resultat.getNoeud(dest));
                resultat.addLien(i, l);
                resultat.addAssociation(a);
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    public static Graphe chargeXTM(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        try {
            String id;
            NodeList data;
            String id2;
            NamedNodeMap atts;
            int i;
            Document doc = XMLReader.getDOM(file);
            TypeNoeud theme = new TypeNoeud("Th\u00e8me");
            resultat.addTypeNoeud(theme);
            TypeNoeud asso = new TypeNoeud("Association");
            resultat.addTypeNoeud(asso);
            TypeLien instanceOf = new TypeLien("est une instance de");
            resultat.addTypeLien(instanceOf);
            TypeLien role = new TypeLien("a pour r\u00f4le");
            resultat.addTypeLien(role);
            TypeLien membre = new TypeLien("est membre de");
            resultat.addTypeLien(membre);
            TypeLien subject = new TypeLien("a pour sujet");
            resultat.addTypeLien(subject);
            HashMap<String, Integer> ids = new HashMap<String, Integer>();
            int unnamedAsso = 1;
            int idLienSuivant = 0;
            NodeList topics = doc.getElementsByTagName("topic");
            NodeList associations = doc.getElementsByTagName("association");
            for (i = 0; i < topics.getLength(); ++i) {
                Node topic = topics.item(i);
                atts = topic.getAttributes();
                id2 = atts.item(0).getNodeValue();
                NodeList data2 = topic.getChildNodes();
                String desc = "Noms alternatifs : ";
                for (int j = 0; j < data2.getLength(); ++j) {
                    if (!data2.item(j).getNodeName().equals("baseName")) continue;
                    NodeList data22 = data2.item(j).getChildNodes();
                    for (int k = 0; k < data22.getLength(); ++k) {
                        if (!data22.item(k).getNodeName().equals("baseNameString")) continue;
                        String s = data22.item(k).getChildNodes().item(0).getNodeValue().trim();
                        desc = desc + "<br> * " + s;
                    }
                }
                ids.put(id2, new Integer(i));
                Noeud n = new Noeud(id2, theme);
                n.setDescription(desc);
                resultat.addNoeud(i, n);
            }
            for (i = 0; i < associations.getLength(); ++i) {
                Node association = associations.item(i);
                atts = association.getAttributes();
                id2 = "";
                try {
                    id2 = atts.item(0).getNodeValue();
                }
                catch (NullPointerException npe) {
                    id2 = "Association non nomm\u00e9e " + unnamedAsso;
                    ++unnamedAsso;
                }
                String desc = "Association";
                ids.put(id2, new Integer(i + topics.getLength()));
                Noeud n = new Noeud(id2, asso);
                n.setDescription(desc);
                resultat.addNoeud(i + topics.getLength(), n);
            }
            for (i = 0; i < topics.getLength(); ++i) {
                data = topics.item(i).getChildNodes();
                id = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    Object o;
                    if (data.item(j).getNodeName().equals("instanceOf")) {
                        NodeList data2 = data.item(j).getChildNodes();
                        for (int k = 0; k < data2.getLength(); ++k) {
                            if (!data2.item(k).getNodeName().equals("topicRef") && !data2.item(k).getNodeName().equals("subjectIndicatorRef")) continue;
                            id = data2.item(k).getAttributes().item(0).getNodeValue();
                            id = id.substring(1, id.length());
                        }
                    }
                    if ((o = ids.get(id)) == null) continue;
                    int idBase = i;
                    int idDest = (Integer)o;
                    Lien l = new Lien("", instanceOf);
                    resultat.addLien(idLienSuivant, l);
                    resultat.addAssociation(idLienSuivant, idBase, idDest);
                    ++idLienSuivant;
                }
            }
            for (i = 0; i < associations.getLength(); ++i) {
                data = associations.item(i).getChildNodes();
                id = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    if (!data.item(j).getNodeName().equals("instanceOf")) continue;
                    NodeList data2 = data.item(j).getChildNodes();
                    for (int k = 0; k < data2.getLength(); ++k) {
                        if (!data2.item(k).getNodeName().equals("topicRef") && !data2.item(k).getNodeName().equals("subjectIndicatorRef")) continue;
                        id = data2.item(k).getAttributes().item(0).getNodeValue();
                        id = id.substring(1, id.length());
                    }
                }
                Object o = ids.get(id);
                if (o == null) continue;
                int idBase = i + topics.getLength();
                int idDest = (Integer)o;
                Lien l = new Lien("", instanceOf);
                resultat.addLien(idLienSuivant, l);
                resultat.addAssociation(idLienSuivant, idBase, idDest);
                ++idLienSuivant;
            }
            for (i = 0; i < associations.getLength(); ++i) {
                data = associations.item(i).getChildNodes();
                int idAsso = i + topics.getLength();
                String idCible = "";
                String idRole = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    if (!data.item(j).getNodeName().equals("member")) continue;
                    NodeList data2 = data.item(j).getChildNodes();
                    for (int k = 0; k < data2.getLength(); ++k) {
                        if (data2.item(k).getNodeName().equals("roleSpec")) {
                            NodeList data3 = data2.item(k).getChildNodes();
                            for (int l = 0; l < data3.getLength(); ++l) {
                                if (!data3.item(l).getNodeName().equals("topicRef") && !data3.item(l).getNodeName().equals("subjectIndicatorRef")) continue;
                                idRole = data3.item(l).getAttributes().item(0).getNodeValue();
                                idRole = idRole.substring(1, idRole.length());
                            }
                        }
                        if (!data2.item(k).getNodeName().equals("topicRef") && !data2.item(k).getNodeName().equals("subjectIndicatorRef")) continue;
                        idCible = data2.item(k).getAttributes().item(0).getNodeValue();
                        idCible = idCible.substring(1, idCible.length());
                    }
                    Object o = ids.get(idRole);
                    if (o == null) continue;
                    int idDest = idAsso;
                    int idBase = (Integer)o;
                    Lien l = new Lien("", membre);
                    resultat.addLien(idLienSuivant, l);
                    resultat.addAssociation(idLienSuivant, idBase, idDest);
                    ++idLienSuivant;
                    Object o2 = ids.get(idCible);
                    if (o2 == null) continue;
                    idDest = idBase;
                    idBase = (Integer)o2;
                    l = new Lien("", role);
                    resultat.addLien(idLienSuivant, l);
                    resultat.addAssociation(idLienSuivant, idBase, idDest);
                    ++idLienSuivant;
                }
            }
            for (i = 0; i < topics.getLength(); ++i) {
                data = topics.item(i).getChildNodes();
                String id3 = "";
                for (int j = 0; j < data.getLength(); ++j) {
                    if (!data.item(j).getNodeName().equals("subjectIdentity")) continue;
                    NodeList data2 = data.item(j).getChildNodes();
                    for (int k = 0; k < data2.getLength(); ++k) {
                        if (!data2.item(k).getNodeName().equals("topicRef") && !data2.item(k).getNodeName().equals("subjectIndicatorRef")) continue;
                        id3 = data2.item(k).getAttributes().item(0).getNodeValue();
                        id3 = id3.substring(1, id3.length());
                    }
                }
                Object o = ids.get(id3);
                if (o == null) continue;
                int idBase = i;
                int idDest = (Integer)o;
                Lien l = new Lien("", subject);
                resultat.addLien(idLienSuivant, l);
                resultat.addAssociation(idLienSuivant, idBase, idDest);
                ++idLienSuivant;
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    public static Graphe chargeJOU(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        resultat.addTypeNoeud(0, new TypeNoeud("Cat\u00e9gorie"));
        Propriete[] props = new Propriete[]{new Propriete("Transitivit\u00e9", 1), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 0)};
        resultat.addTypeLien(0, new TypeLien("Est une Cat\u00e9gorie de", props));
        idCat = 1;
        idCatL = 0;
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList journaux = doc.getElementsByTagName("JOURNAL");
            if (journaux.getLength() < 1 || journaux.getLength() > 1) {
                throw new IllegalStateException("Il ne peut y avoir qu'un journal par fichier");
            }
            Node journal = journaux.item(0);
            NodeList categories = journal.getChildNodes();
            String nom = "";
            for (int i = 0; i < categories.getLength(); ++i) {
                Node categorie = categories.item(i);
                if (categorie.getNodeName().equals("NOM")) {
                    nom = categorie.getChildNodes().item(0).getNodeValue().trim();
                    resultat.addNoeud(0, new Noeud(nom, resultat.getTypeNoeud(0)));
                    continue;
                }
                if (!categorie.getNodeName().equals("CATEGORIE")) continue;
                Chargeur.lisCategorie(categorie, 0, resultat);
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }

    private static void lisCategorie(Node n, int idPere, Graphe resultat) {
        NodeList categories = n.getChildNodes();
        String nom = "";
        int id = idCat++;
        for (int i = 0; i < categories.getLength(); ++i) {
            Node categorie = categories.item(i);
            if (categorie.getNodeName().equals("NOM")) {
                int idL;
                nom = categorie.getChildNodes().item(0).getNodeValue().trim();
                resultat.addNoeud(id, new Noeud(nom, resultat.getTypeNoeud(0)));
                ++idCatL;
                resultat.addLien(idL, new Lien("", resultat.getTypeLien(0)));
                resultat.addAssociation(idL, id, idPere);
                continue;
            }
            if (!categorie.getNodeName().equals("CATEGORIE")) continue;
            Chargeur.lisCategorie(categorie, id, resultat);
        }
    }

    public static Graphe chargeMDN(File file) throws ImportException {
        String nomPDV = file.getPath();
        try {
            nomPDV = nomPDV.split("pdv")[1];
            nomPDV = nomPDV.substring(1, nomPDV.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        Graphe resultat = new Graphe(nomPDV);
        resultat.addTypeNoeud(0, new TypeNoeud("Th\u00e8me"));
        resultat.addTypeNoeud(1, new TypeNoeud("Sujet"));
        resultat.addTypeNoeud(2, new TypeNoeud("Article"));
        Propriete[] props = new Propriete[]{new Propriete("Transitivit\u00e9", 1), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 0)};
        resultat.addTypeLien(0, new TypeLien("est une cat\u00e9gorie de", props));
        Propriete[] props2 = new Propriete[]{new Propriete("Transitivit\u00e9", 0), new Propriete("R\u00e9flexivit\u00e9", 0), new Propriete("Sym\u00e9trie", 0), new Propriete("Optionnel", 0)};
        resultat.addTypeLien(1, new TypeLien("est trait\u00e9 par", props2));
        try {
            Document doc = XMLReader.getDOM(file);
            NodeList journaux = doc.getElementsByTagName("JOURNAL");
            if (journaux.getLength() < 1 || journaux.getLength() > 1) {
                throw new IllegalStateException("Il ne peut y avoir qu'un journal par fichier");
            }
            Node journal = journaux.item(0);
            NodeList themes = journal.getChildNodes();
            for (int i = 0; i < themes.getLength(); ++i) {
                String nom = "";
                Node theme = themes.item(i);
                if (!theme.getNodeName().equals("THEME")) continue;
                NodeList sujets = theme.getChildNodes();
                for (int j = 0; j < sujets.getLength(); ++j) {
                    String nom2 = "";
                    Node sujet = sujets.item(j);
                    if (sujet.getNodeName().equals("NOM")) {
                        nom = sujet.getChildNodes().item(0).getNodeValue().trim();
                        resultat.addNoeud(100 + i, new Noeud(nom, resultat.getTypeNoeud(0)));
                    }
                    if (!sujet.getNodeName().equals("SUJET")) continue;
                    NodeList articles = sujet.getChildNodes();
                    for (int k = 0; k < articles.getLength(); ++k) {
                        String nom3 = "";
                        Node article = articles.item(k);
                        if (article.getNodeName().equals("NOM")) {
                            nom2 = article.getChildNodes().item(0).getNodeValue().trim();
                            resultat.addNoeud(10000 + 100 * i + j, new Noeud(nom2, resultat.getTypeNoeud(1)));
                            resultat.addLien(10000 + 100 * i + j, new Lien("", resultat.getTypeLien(0)));
                            resultat.addAssociation(10000 + 100 * i + j, 10000 + 100 * i + j, 100 + i);
                        }
                        if (!article.getNodeName().equals("ARTICLE")) continue;
                        nom3 = article.getChildNodes().item(0).getNodeValue().trim();
                        resultat.addNoeud(1000000 + 10000 * i + 100 * j + k, new Noeud(nom3, resultat.getTypeNoeud(2)));
                        resultat.addLien(1000000 + 10000 * i + 100 * j + k, new Lien("", resultat.getTypeLien(1)));
                        resultat.addAssociation(1000000 + 10000 * i + 100 * j + k, 1000000 + 10000 * i + 100 * j + k, 10000 + 100 * i + j);
                    }
                }
            }
        }
        catch (DOMCreationFailureException dcfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_MalformedXML") + " (" + dcfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(dcfe);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Critical_Info"), Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(npe);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Id_Not_Number") + " (" + nfe.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(nfe);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(null, "<html>" + Charte.getMessage("Error_Entry") + " (" + ise.getMessage() + ")", Charte.getMessage("Error_In") + " " + file.getName(), 0);
            throw new ImportException(ise);
        }
        return resultat;
    }
}

