/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import data.ListeSynonymes;
import ihm.Charte;
import ihm.Legende;
import ihm.townto.GraphPanel;
import ihm.townto.LinkFactory;
import ihm.townto.MultiPVGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiPVGraphPanel
extends GraphPanel {
    private Legende legende;

    public MultiPVGraphPanel(int nbPV, MultiPVGraph gd, int id) {
        super(gd, id);
        this.legende = new Legende(nbPV);
        this.setGraph(gd);
    }

    public void setGraph(MultiPVGraph gd) {
        this.createStuff(gd);
        this.layout.invalidate();
        for (int i = 0; i < 100 / gd.getNumberOfNodes(); ++i) {
            this.doLayout();
        }
    }

    @Override
    boolean isInCrownOf(GraphPanel.Node firstNode, GraphPanel.Node secondNode) {
        boolean yes = false;
        if (this.isActiveNode(firstNode) && this.isInFirstCrown(secondNode) || this.isActiveNode(firstNode) && this.isInSecondCrown(secondNode)) {
            yes = true;
        }
        if (!yes && this.isInFirstCrown(firstNode)) {
            GraphPanel.Node[] liste = this.getSecondCrown(firstNode);
            for (int i = 0; i < liste.length; ++i) {
                if (liste[i].getId() != secondNode.getId()) continue;
                yes = true;
                break;
            }
        }
        return yes;
    }

    protected void createStuff(MultiPVGraph gd) {
        GraphPanel.NumberLink link;
        GraphPanel.NumberNode node;
        int i;
        this.processing = true;
        this.removeAll();
        this.activeNode = new MultiPVNode(gd.getMultiPVActive().getListe(), gd.getMultiPVActive().getDescription(), gd.getMultiPVActive().getId(), (GraphPanel)this);
        this.activeNode.setBorder(Charte.getBorder());
        this.add(this.activeNode);
        MultiPVGraph.MultiPVGraphNode[] nodes1 = gd.getMultiPVSortedFirstCrown();
        this.crown1 = new MultiPVNode[nodes1.length];
        for (int i2 = 0; i2 < this.crown1.length; ++i2) {
            this.crown1[i2] = new MultiPVNode(nodes1[i2].getListe(), nodes1[i2].getDescription(), nodes1[i2].getId(), (GraphPanel)this);
            this.add(this.crown1[i2]);
        }
        MultiPVGraph.MultiPVGraphNode[] nodes2 = gd.getMultiPVSortedSecondCrown();
        this.crown2 = new MultiPVNode[nodes2.length];
        for (int i3 = 0; i3 < this.crown2.length; ++i3) {
            this.crown2[i3] = new MultiPVNode(nodes2[i3].getListe(), nodes2[i3].getDescription(), nodes2[i3].getId(), (GraphPanel)this);
            this.add(this.crown2[i3]);
        }
        Vector<GraphPanel.NumberNode> num = new Vector<GraphPanel.NumberNode>();
        Vector<GraphPanel.NumberLink> lin = new Vector<GraphPanel.NumberLink>();
        for (i = 0; i < nodes1.length; ++i) {
            if (nodes1[i].getRelationsCount() <= 0) continue;
            node = new GraphPanel.NumberNode(nodes1[i].getId(), nodes1[i].getRelationsCount());
            link = new GraphPanel.NumberLink(this.crown1[i], node);
            num.addElement(node);
            lin.addElement(link);
            this.add(node);
            this.add(link);
        }
        for (i = 0; i < nodes2.length; ++i) {
            if (nodes2[i].getRelationsCount() <= 0) continue;
            node = new GraphPanel.NumberNode(nodes2[i].getId(), nodes2[i].getRelationsCount());
            link = new GraphPanel.NumberLink(this.crown2[i], node);
            num.addElement(node);
            lin.addElement(link);
            this.add(node);
            this.add(link);
        }
        this.numbers = new GraphPanel.NumberNode[num.size()];
        num.toArray(this.numbers);
        this.nLinks = new GraphPanel.NumberLink[lin.size()];
        lin.toArray(this.nLinks);
        MultiPVGraph.MultiPVGraphLink[] llinks = gd.getMultiPVLinks();
        this.links = new MultiPVLink[llinks.length];
        boolean it = false;
        for (int i4 = 0; i4 < this.links.length; ++i4) {
            int j;
            this.links[i4] = new MultiPVLink(new MultiPVNode(new ListeSynonymes("", ""), "", 0, (GraphPanel)this), new MultiPVNode(new ListeSynonymes("", ""), "", 0, (GraphPanel)this), Charte.getMiscellaneous());
            MultiPVNode node1 = null;
            MultiPVNode node2 = null;
            int from = llinks[i4].getIdConcept1();
            int to = llinks[i4].getIdConcept2();
            if (from >= 0 && from <= 9) {
                node1 = (MultiPVNode)this.activeNode;
            }
            if (to >= 0 && to <= 9) {
                node2 = (MultiPVNode)this.activeNode;
            }
            if (from >= 10 && from <= 999) {
                for (j = 0; j < this.crown1.length; ++j) {
                    if (this.crown1[j].getId() != from) continue;
                    node1 = (MultiPVNode)this.crown1[j];
                }
            }
            if (to >= 10 && to <= 999) {
                for (j = 0; j < this.crown1.length; ++j) {
                    if (this.crown1[j].getId() != to) continue;
                    node2 = (MultiPVNode)this.crown1[j];
                }
            }
            if (from >= 1000 && from <= 99999) {
                for (j = 0; j < this.crown2.length; ++j) {
                    if (this.crown2[j].getId() != from) continue;
                    node1 = (MultiPVNode)this.crown2[j];
                }
            }
            if (to >= 1000 && to <= 99999) {
                for (j = 0; j < this.crown2.length; ++j) {
                    if (this.crown2[j].getId() != to) continue;
                    node2 = (MultiPVNode)this.crown2[j];
                }
            }
            if (node1 != null && node2 != null) {
                this.links[i4] = new MultiPVLink(node1, node2, llinks[i4].getColor());
                this.add(this.links[i4]);
            }
            this.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        }
        this.arrows = new LinkFactory.ArrowComponent[this.links.length];
        LinkFactory factory = new LinkFactory();
        for (int i5 = 0; i5 < this.arrows.length; ++i5) {
            int x1 = this.links[i5].getNode1().getLocation().x;
            int y1 = this.links[i5].getNode1().getLocation().y;
            int x2 = this.links[i5].getNode2().getLocation().x;
            int y2 = this.links[i5].getNode2().getLocation().y;
            String text = " " + this.links[i5].getText() + " ";
            this.arrows[i5] = factory.createArrowComponent(text, LinkFactory.createArrow(x1, y1, x2, y2), this.links[i5].getColor(), this);
        }
        this.processing = false;
    }

    protected class MultiPVLink
    extends GraphPanel.Link {
        public MultiPVLink(MultiPVNode node1, MultiPVNode node2, Color color) {
            super(node1, node2, "", color);
        }

        @Override
        public String getText() {
            String s = "";
            return s;
        }
    }

    class MultiPVNode
    extends GraphPanel.Node {
        private JLabel[] contenu;

        public MultiPVNode(ListeSynonymes name, String description, int id, GraphPanel parent) {
            super("", description, id, parent);
            this.removeAll();
            this.setLayout(new GridLayout(name.getListe().length, 1));
            JPanel[] pMots = new JPanel[name.getListe().length];
            this.contenu = new JLabel[name.getListe().length];
            for (int i = 0; i < pMots.length; ++i) {
                String name0;
                String son;
                Image image;
                block20: {
                    URI uri;
                    pMots[i] = new JPanel(new BorderLayout());
                    Charte.formate(pMots[i]);
                    pMots[i].add((Component)MultiPVGraphPanel.this.legende.getClasseur(name.getListe()[i].getConcernes()), "West");
                    image = null;
                    son = "";
                    name0 = name.getListe()[i].getTexte();
                    this.contenu[i] = new JLabel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Dimension d = super.getPreferredSize();
                            int x = 1;
                            if (d.width > 200) {
                                x += d.width / 200;
                            }
                            int h = (int)(1.8 * (double)x * (double)this.getFont().getSize());
                            return new Dimension(d.width / x, x > 1 ? h : d.height);
                        }
                    };
                    if (name0.endsWith("jpg") || name0.endsWith("gif") || name0.endsWith("png")) {
                        try {
                            uri = new URI(name0).normalize();
                            if (uri.getScheme().startsWith("file")) {
                                image = new ImageIcon(new File(uri).getAbsolutePath()).getImage();
                                if (image.getWidth(this) > 100 || image.getHeight(this) > 50) {
                                    image = image.getScaledInstance(100, 50, 4);
                                }
                                break block20;
                            }
                            if (uri.getScheme().startsWith("http")) {
                                image = new ImageIcon(uri.toURL()).getImage();
                                if (image.getWidth(this) > 100 || image.getHeight(this) > 50) {
                                    image = image.getScaledInstance(100, 50, 4);
                                }
                                break block20;
                            }
                            image = null;
                        }
                        catch (NullPointerException npe) {
                            image = null;
                        }
                        catch (URISyntaxException use) {
                            image = null;
                        }
                        catch (MalformedURLException mue) {
                            image = null;
                        }
                    } else if (name0.endsWith("au") || name0.endsWith("mid") || name0.endsWith("wav")) {
                        try {
                            uri = new URI(name0).normalize();
                            son = uri.getScheme().startsWith("file") ? new File(uri).getAbsolutePath() : (uri.getScheme().startsWith("http") ? uri.toURL().toString() : "");
                        }
                        catch (NullPointerException npe) {
                            son = "";
                        }
                        catch (URISyntaxException use) {
                            son = "";
                        }
                        catch (MalformedURLException mue) {
                            son = "";
                        }
                    }
                }
                if (image != null) {
                    this.contenu[i].setIcon(new ImageIcon(image));
                } else if (!son.equals("")) {
                    this.contenu[i].setIcon(Charte.getIconeSon());
                } else {
                    this.contenu[i].setText("<html>" + name0);
                }
                Charte.formate(this.contenu[i]);
                pMots[i].add((Component)this.contenu[i], "Center");
                this.add(pMots[i]);
            }
            this.setCursor(new Cursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    MultiPVGraphPanel.this.layout.setActive(false);
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    MultiPVGraphPanel.this.layout.setActive(true);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    MultiPVNode.this.translate(me.getX() - ((Component)me.getSource()).getSize().width / 2, me.getY() - ((Component)me.getSource()).getSize().height / 2);
                }
            });
        }

        @Override
        protected void translate(int px, int py) {
            int i;
            int x1 = this.getLocation().x + px;
            int y1 = this.getLocation().y + py;
            this.setLocation(x1, y1);
            for (i = 0; i < MultiPVGraphPanel.this.crown1.length; ++i) {
                if (!MultiPVGraphPanel.this.isInCrownOf(this, MultiPVGraphPanel.this.crown1[i])) continue;
                MultiPVGraphPanel.this.crown1[i].translate2(px, py);
            }
            for (i = 0; i < MultiPVGraphPanel.this.crown2.length; ++i) {
                if (!MultiPVGraphPanel.this.isInCrownOf(this, MultiPVGraphPanel.this.crown2[i])) continue;
                MultiPVGraphPanel.this.crown2[i].translate2(px, py);
            }
        }

        @Override
        protected void translate2(int px, int py) {
            int x1 = this.getLocation().x + px;
            int y1 = this.getLocation().y + py;
            this.setLocation(x1, y1);
        }

        @Override
        public void setFontSize(int fontSize) {
            for (int i = 0; i < this.contenu.length; ++i) {
                this.contenu[i].setFont(this.getFont().deriveFont((float)fontSize));
            }
        }

        @Override
        public void setBold() {
            for (int i = 0; i < this.contenu.length; ++i) {
                this.contenu[i].setFont(this.getFont().deriveFont(1));
            }
        }
    }
}

