/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import data.ListeSynonymes;
import ihm.Charte;
import ihm.townto.Graph;
import ihm.townto.LinkFailureException;
import java.util.HashSet;
import java.util.Vector;

public class MultiPVGraph
extends Graph {
    public MultiPVGraph() {
        this.setActive(new ListeSynonymes("", ""), "");
    }

    public void setActive(ListeSynonymes concept, String description) {
        super.setActive(concept.toString(), description);
        this.activeConcept = new MultiPVNode(concept, description, 0);
    }

    public ListeSynonymes getActiveConceptList() {
        return ((MultiPVNode)this.activeConcept).getListe();
    }

    public void addLink(ListeSynonymes linkFrom, String descFrom, ListeSynonymes linkTo, String descTo) throws LinkFailureException {
        this.addLink(linkFrom, descFrom, 0, linkTo, descTo, 0);
    }

    public void addLink(ListeSynonymes linkFrom, String descFrom, int countFrom, ListeSynonymes linkTo, String descTo, int countTo) throws LinkFailureException {
        MultiPVNode s;
        int i;
        MultiPVNode nodeFrom = new MultiPVNode(new ListeSynonymes("", ""), "", -1);
        MultiPVNode nodeTo = new MultiPVNode(new ListeSynonymes("", ""), "", -1);
        if (linkFrom.equals(((MultiPVNode)this.activeConcept).getListe())) {
            nodeFrom = (MultiPVNode)this.activeConcept;
        }
        if (linkTo.equals(((MultiPVNode)this.activeConcept).getListe())) {
            nodeTo = (MultiPVNode)this.activeConcept;
        }
        for (i = 0; i < this.firstCrown.size(); ++i) {
            s = (MultiPVNode)this.firstCrown.elementAt(i);
            if (linkFrom.equals(s.getListe())) {
                nodeFrom = s;
            }
            if (!linkTo.equals(s.getListe())) continue;
            nodeTo = s;
        }
        for (i = 0; i < this.secondCrown.size(); ++i) {
            s = (MultiPVNode)this.secondCrown.elementAt(i);
            if (linkFrom.equals(s.getListe())) {
                nodeFrom = s;
            }
            if (!linkTo.equals(s.getListe())) continue;
            nodeTo = s;
        }
        if (nodeFrom.getId() == -1 && nodeTo.getId() == -1) {
            throw new LinkFailureException(Charte.getMessage("Graph_Error_NoConcept") + " " + linkFrom + " " + Charte.getMessage("Graph_Error_NoConcept2") + " " + linkTo + ".");
        }
        if (nodeFrom.getId() == nodeTo.getId()) {
            throw new LinkFailureException(Charte.getMessage("Graph_Error_SameConcept") + " " + linkFrom + " " + Charte.getMessage("Graph_Error_SameConcept2") + " " + linkTo + ".");
        }
        int nFrom = nodeFrom.getId();
        int nTo = nodeTo.getId();
        if (nFrom == -1) {
            if (nTo <= 9) {
                nFrom = this.maxIdCrown1 * 10 + nTo;
                ++this.maxIdCrown1;
                nodeFrom = new MultiPVNode(linkFrom, descFrom, nFrom, countFrom);
                this.addToFirstCrown(nodeFrom);
            }
            if (nTo >= 10 && nTo <= 999) {
                nFrom = this.maxIdCrown2 * 1000 + nTo;
                ++this.maxIdCrown2;
                nodeFrom = new MultiPVNode(linkFrom, descFrom, nFrom, countFrom);
                this.addToSecondCrown(nodeFrom);
            }
            if (nTo >= 1000 && nTo <= 99999) {
                throw new LinkFailureException(Charte.getMessage("Graph_Error_ThirdCrown"));
            }
        }
        if (nTo == -1) {
            if (nFrom <= 9) {
                nTo = this.maxIdCrown1 * 10 + nFrom;
                ++this.maxIdCrown1;
                nodeTo = new MultiPVNode(linkTo, descTo, nTo, countTo);
                this.addToFirstCrown(nodeTo);
            }
            if (nFrom >= 10 && nFrom <= 999) {
                nTo = this.maxIdCrown2 * 1000 + nFrom;
                ++this.maxIdCrown2;
                nodeTo = new MultiPVNode(linkTo, descTo, nTo, countTo);
                this.addToSecondCrown(nodeTo);
            }
            if (nFrom >= 1000 && nFrom <= 99999) {
                throw new LinkFailureException(Charte.getMessage("Graph_Error_ThirdCrown"));
            }
        }
        if (nFrom != -1 && nTo != -1) {
            Graph.Link l;
            int i2;
            if (nFrom <= 9 && nTo >= 1000) {
                System.err.println(nodeTo.name);
                for (i2 = 0; i2 < this.links.size(); ++i2) {
                    l = (Graph.Link)this.links.elementAt(i2);
                    if (l.idFrom == nodeTo.id) {
                        l.idFrom = this.maxIdCrown1 * 10;
                    }
                    if (l.idTo != nodeTo.id) continue;
                    l.idTo = this.maxIdCrown1 * 10;
                }
                nodeTo.id = this.maxIdCrown1 * 10;
                ++this.maxIdCrown1;
                this.secondCrown.remove(nodeTo);
                this.addToFirstCrown(nodeTo);
            }
            if (nTo <= 9 && nFrom >= 1000) {
                System.err.println(nodeFrom.name);
                for (i2 = 0; i2 < this.links.size(); ++i2) {
                    l = (Graph.Link)this.links.elementAt(i2);
                    if (l.idFrom == nodeFrom.id) {
                        l.idFrom = this.maxIdCrown1 * 10;
                    }
                    if (l.idTo != nodeFrom.id) continue;
                    l.idTo = this.maxIdCrown1 * 10;
                }
                nodeFrom.id = this.maxIdCrown1 * 10;
                ++this.maxIdCrown1;
                this.secondCrown.remove(nodeFrom);
                this.addToFirstCrown(nodeFrom);
            }
        }
        this.addToLinks(new MultiPVLink(nodeFrom, nodeTo));
    }

    public MultiPVGraphNode getMultiPVActive() {
        return new MultiPVGraphNode((MultiPVNode)this.activeConcept);
    }

    public MultiPVGraphNode[] getMultiPVSortedFirstCrown() {
        Graph.Node[] n = new MultiPVNode[this.firstCrown.size()];
        this.firstCrown.toArray(n);
        MultiPVGraph.sortFirst(n);
        MultiPVGraphNode[] result = new MultiPVGraphNode[n.length];
        for (int i = 0; i < n.length; ++i) {
            HashSet<MultiPVLink> linkSet = new HashSet<MultiPVLink>();
            boolean ok = true;
            for (int j = 0; j < this.links.size(); ++j) {
                MultiPVLink link = (MultiPVLink)this.links.elementAt(j);
                if (link.getFrom() != n[i].getId() && link.getTo() != n[i].getId()) continue;
                if (link.getFrom() == 0 || link.getTo() == 0) {
                    if (!ok) continue;
                    ok = false;
                    linkSet.add(link);
                    continue;
                }
                linkSet.add(link);
            }
            result[i] = new MultiPVGraphNode((MultiPVNode)n[i], linkSet.size());
        }
        return result;
    }

    public MultiPVGraphNode[] getMultiPVSortedSecondCrown() {
        Graph.Node[] nc1 = new MultiPVNode[this.firstCrown.size()];
        MultiPVNode[] nc2 = new MultiPVNode[this.secondCrown.size()];
        this.firstCrown.toArray(nc1);
        this.secondCrown.toArray(nc2);
        MultiPVGraph.sortFirst(nc1);
        nc2 = MultiPVGraph.sortMultiPVSecond((MultiPVNode[])nc1, nc2);
        MultiPVGraphNode[] result = new MultiPVGraphNode[nc2.length];
        for (int i = 0; i < nc2.length; ++i) {
            HashSet<MultiPVLink> linkSet = new HashSet<MultiPVLink>();
            boolean ok = true;
            for (int j = 0; j < this.links.size(); ++j) {
                MultiPVLink link = (MultiPVLink)this.links.elementAt(j);
                if (link.getFrom() != nc2[i].getId() && link.getTo() != nc2[i].getId()) continue;
                if (link.getFrom() == 0 || link.getTo() == 0) {
                    if (!ok) continue;
                    ok = false;
                    linkSet.add(link);
                    continue;
                }
                linkSet.add(link);
            }
            result[i] = new MultiPVGraphNode(nc2[i], linkSet.size());
        }
        return result;
    }

    public MultiPVGraphLink[] getMultiPVLinks() {
        MultiPVLink[] l = new MultiPVLink[this.links.size()];
        this.links.toArray(l);
        MultiPVGraphLink[] result = new MultiPVGraphLink[this.links.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MultiPVGraphLink(l[i]);
        }
        return result;
    }

    protected static MultiPVNode[] sortMultiPVSecond(MultiPVNode[] sortedFirstNodes, MultiPVNode[] secondNodes) {
        Vector<MultiPVNode> result = new Vector<MultiPVNode>();
        for (int i = 0; i < sortedFirstNodes.length; ++i) {
            int idToFind = sortedFirstNodes[i].getId();
            for (int j = 0; j < secondNodes.length; ++j) {
                int idFound = secondNodes[j].getId() % 1000;
                if (idFound != idToFind) continue;
                result.addElement(secondNodes[j]);
            }
        }
        MultiPVNode[] nres = new MultiPVNode[result.size()];
        result.toArray(nres);
        return nres;
    }

    protected class MultiPVNode
    extends Graph.Node {
        protected ListeSynonymes liste;

        public MultiPVNode(ListeSynonymes name, String description, int id) {
            this(name, description, id, 0);
        }

        public MultiPVNode(ListeSynonymes name, String description, int id, int relations) {
            super(name.toString(), description, id, relations);
            this.liste = name;
        }

        public ListeSynonymes getListe() {
            return this.liste;
        }
    }

    protected class MultiPVLink
    extends Graph.Link {
        public MultiPVLink(MultiPVNode from, MultiPVNode to) {
            super(from, to, "");
        }
    }

    class MultiPVGraphLink
    extends Graph.GraphLink {
        protected MultiPVGraphLink(MultiPVLink link) {
            super(link);
        }
    }

    class MultiPVGraphNode
    extends Graph.GraphNode {
        protected ListeSynonymes liste;

        protected MultiPVGraphNode(MultiPVNode node) {
            this(node, 0);
        }

        protected MultiPVGraphNode(MultiPVNode node, int drawnRelations) {
            super(node, drawnRelations);
            this.liste = node.getListe();
        }

        public ListeSynonymes getListe() {
            return this.liste;
        }
    }
}

