/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.Charte;
import ihm.townto.GraphPanel;
import ihm.townto.LinkFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class GraphLayout
implements LayoutManager {
    private int tooNear1 = 10 * Charte.getFont().getSize();
    private int tooFar1 = 2 * this.tooNear1;
    private int tooNear2 = 3 * Charte.getFont().getSize();
    private int tooFar2 = 3 * this.tooNear2;
    private int tooNear3;
    private int tooFar3 = this.tooNear3 = 3 * Charte.getFont().getSize();
    private static int FONT_SIZE = Charte.getFont().getSize();
    private int n_font = FONT_SIZE;
    private boolean defined = false;
    private long start = 0L;
    private boolean activated = true;

    public void setActive(boolean active) {
        this.activated = active;
        if (active) {
            this.start = System.currentTimeMillis();
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int x = 0;
        int y = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            int nx = parent.getComponent(i).getX() + parent.getComponent(i).getWidth();
            int ny = parent.getComponent(i).getY() + parent.getComponent(i).getHeight();
            if (nx > x) {
                x = nx;
            }
            if (ny <= y) continue;
            y = ny;
        }
        return new Dimension(x, y);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public void invalidate() {
        this.defined = false;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (parent instanceof GraphPanel) {
            if (this.activated) {
                if (!this.defined) {
                    this.computeLocations((GraphPanel)parent);
                    this.defined = true;
                } else {
                    this.quake((GraphPanel)parent);
                }
            } else {
                this.redraw((GraphPanel)parent);
            }
        }
    }

    protected void computeLocations(GraphPanel component) {
        int i;
        this.start = System.currentTimeMillis();
        if (component.getSecondCrown().length == 0) {
            this.tooNear1 = 50 + 20 * component.getActiveNode().getLineCount();
            this.tooFar1 = 10 * component.getFirstCrown().length + 20 * component.getActiveNode().getLineCount();
        } else {
            this.tooNear1 = 150;
            this.tooFar1 = 200;
        }
        int W = component.getWidth();
        int H = component.getHeight();
        int w = component.getActiveNode().getWidth();
        int h = component.getActiveNode().getHeight();
        int dw = w / 2;
        int r3 = this.tooNear3;
        int r2 = this.tooNear2;
        int r1 = this.tooNear1;
        int x0 = (W - w) / 2 + dw;
        int y0 = (H - h) / 2;
        component.getActiveNode().setLocation(x0, y0);
        component.getActiveNode().setSize(component.getActiveNode().getPreferredSize());
        component.getActiveNode().setFontSize((int)((double)this.n_font * 1.2));
        component.getActiveNode().setBold();
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            GraphPanel.Node cmp = component.getFirstCrown()[i];
            GraphPanel.NumberNode num = component.getNumberNode(cmp);
            GraphPanel.Node[] cmp2 = component.getSecondCrown(cmp);
            double a = Math.PI * 2 / (double)component.getFirstCrown().length;
            int dwi = component.getActiveNode().getWidth() - cmp.getWidth();
            int dhe = component.getActiveNode().getHeight() - cmp.getHeight();
            cmp.setLocation((int)((double)(x0 + dwi / 2) + (double)r1 * Math.cos((double)i * a)), (int)((double)(y0 + dhe / 2) + (double)r1 * Math.sin((double)i * a)));
            cmp.setSize(cmp.getPreferredSize());
            cmp.setFontSize(this.n_font);
            if (num != null) {
                num.setLocation((int)((double)(x0 + dwi / 2) + (double)r2 * Math.cos((double)i * a)), (int)((double)(y0 + dhe / 2) + (double)r2 * Math.sin((double)i * a)));
                num.setSize(num.getPreferredSize());
            }
            for (int j = 0; j < cmp2.length; ++j) {
                double a2 = a / (double)cmp2.length;
                cmp2[j].setLocation((int)((double)cmp.getX() + (double)r2 * Math.cos((double)i * a + (double)j * a2)), (int)((double)cmp.getY() + (double)r2 * Math.sin((double)i * a + (double)j * a2)));
                cmp2[j].setSize(cmp2[j].getPreferredSize());
                cmp2[j].setFontSize(this.n_font * 3 / 4);
                GraphPanel.NumberNode num2 = component.getNumberNode(cmp2[j]);
                if (num2 == null) continue;
                num2.setLocation((int)((double)cmp2[j].getX() + (double)r3 * Math.cos((double)i * a + (double)j * a2)), (int)((double)cmp2[j].getY() + (double)r3 * Math.sin((double)i * a + (double)j * a2)));
                num2.setSize(num.getPreferredSize());
            }
            component.resizeLinks();
        }
        for (i = 0; i < component.getArrows().length; ++i) {
            int x1 = component.getFirstNode((int)i).getLocation().x;
            int y1 = component.getFirstNode((int)i).getLocation().y;
            int w1 = component.getFirstNode((int)i).getSize().width;
            int h1 = component.getFirstNode((int)i).getSize().height;
            int x2 = component.getSecondNode((int)i).getLocation().x;
            int y2 = component.getSecondNode((int)i).getLocation().y;
            int w2 = component.getSecondNode((int)i).getSize().width;
            int h2 = component.getSecondNode((int)i).getSize().height;
            int x = x1 + w1 / 2 < x2 + w2 / 2 ? x1 + w1 / 2 : x2 + w2 / 2;
            int y = y1 + h1 / 2 < y2 + h2 / 2 ? y1 + h1 / 2 : y2 + h2 / 2;
            int w0 = x1 + w1 / 2 > x2 + w2 / 2 ? x1 + w1 / 2 - x : x2 + w2 / 2 - x;
            int h0 = y1 + h1 / 2 > y2 + h2 / 2 ? y1 + h1 / 2 - y : y2 + h2 / 2 - y;
            component.getArrows()[i].setLocation(x + w0 / 2 - 5, y + h0 / 2 - 5);
            component.getArrows()[i].setSize(10, 10);
            component.getArrows()[i].setArrow(LinkFactory.createArrow(x1 + w1 / 2, y1 + h1 / 2, x2 + w2 / 2, y2 + h2 / 2));
        }
        if (component.getSecondCrown().length == 0) {
            for (i = 0; i < 2 * component.getFirstCrown().length; ++i) {
                this.quake(component);
            }
        }
    }

    protected void quake(GraphPanel component) {
        int j;
        int i;
        int i2;
        int j2;
        int i3;
        int k;
        Dimension d;
        int j3;
        int i4;
        if (System.currentTimeMillis() - this.start > 3000L) {
            return;
        }
        component.getActiveNode().setSize(component.getActiveNode().getPreferredSize());
        for (i4 = 0; i4 < component.getFirstCrown().length; ++i4) {
            component.getFirstCrown()[i4].setSize(component.getFirstCrown()[i4].getPreferredSize());
        }
        for (i4 = 0; i4 < component.getSecondCrown().length; ++i4) {
            component.getSecondCrown()[i4].setSize(component.getSecondCrown()[i4].getPreferredSize());
        }
        int[] trX0 = new int[1];
        int[] trY0 = new int[1];
        int[] trX1 = new int[component.getFirstCrown().length];
        int[] trY1 = new int[component.getFirstCrown().length];
        int[] trX2 = new int[component.getSecondCrown().length];
        int[] trY2 = new int[component.getSecondCrown().length];
        trX0[0] = 0;
        trY0[0] = 0;
        for (j3 = 0; j3 < component.getFirstCrown().length; ++j3) {
            d = this.getTranslation(component.getActiveNode(), component.getFirstCrown()[j3], component.isLinked(component.getActiveNode(), component.getFirstCrown()[j3]), 0, 1);
            int n = j3;
            trX1[n] = trX1[n] - d.width;
            int n2 = j3;
            trY1[n2] = trY1[n2] - d.height;
            for (k = 0; k < component.getSecondCrown().length; ++k) {
                if (!component.isInCrownOf(component.getFirstCrown()[j3], component.getSecondCrown()[k])) continue;
                int n3 = k;
                trX2[n3] = trX2[n3] - d.width;
                int n4 = k;
                trY2[n4] = trY2[n4] - d.height;
            }
        }
        j3 = 0;
        while (j3 < component.getSecondCrown().length) {
            d = this.getTranslation(component.getActiveNode(), component.getSecondCrown()[j3], component.isLinked(component.getActiveNode(), component.getSecondCrown()[j3]), 0, 2);
            int n = j3;
            trX2[n] = trX2[n] - d.width;
            int n5 = j3++;
            trY2[n5] = trY2[n5] - d.height;
        }
        for (i3 = 0; i3 < component.getFirstCrown().length; ++i3) {
            d = this.getTranslation(component.getFirstCrown()[i3], component.getActiveNode(), component.isLinked(component.getFirstCrown()[i3], component.getActiveNode()), 1, 0);
            int n = i3;
            trX1[n] = trX1[n] + d.width;
            int n6 = i3;
            trY1[n6] = trY1[n6] + d.height;
            for (k = 0; k < component.getSecondCrown().length; ++k) {
                if (!component.isInCrownOf(component.getFirstCrown()[i3], component.getSecondCrown()[k])) continue;
                int n7 = k;
                trX2[n7] = trX2[n7] + d.width;
                int n8 = k;
                trY2[n8] = trY2[n8] + d.height;
            }
            for (j2 = 0; j2 < component.getFirstCrown().length; ++j2) {
                int k2;
                d = this.getTranslation(component.getFirstCrown()[i3], component.getFirstCrown()[j2], component.isLinked(component.getFirstCrown()[i3], component.getFirstCrown()[j2]), 1, 1);
                int n9 = i3;
                trX1[n9] = trX1[n9] + d.width;
                int n10 = i3;
                trY1[n10] = trY1[n10] + d.height;
                for (k2 = 0; k2 < component.getSecondCrown().length; ++k2) {
                    if (!component.isInCrownOf(component.getFirstCrown()[i3], component.getSecondCrown()[k2])) continue;
                    int n11 = k2;
                    trX2[n11] = trX2[n11] + d.width;
                    int n12 = k2;
                    trY2[n12] = trY2[n12] + d.height;
                }
                int n13 = j2;
                trX1[n13] = trX1[n13] - d.width;
                int n14 = j2;
                trY1[n14] = trY1[n14] - d.height;
                for (k2 = 0; k2 < component.getSecondCrown().length; ++k2) {
                    if (!component.isInCrownOf(component.getFirstCrown()[j2], component.getSecondCrown()[k2])) continue;
                    int n15 = k2;
                    trX2[n15] = trX2[n15] - d.width;
                    int n16 = k2;
                    trY2[n16] = trY2[n16] - d.height;
                }
            }
            j2 = 0;
            while (j2 < component.getSecondCrown().length) {
                d = this.getTranslation(component.getFirstCrown()[i3], component.getSecondCrown()[j2], component.isLinked(component.getFirstCrown()[i3], component.getSecondCrown()[j2]), 1, 2);
                int n17 = j2;
                trX2[n17] = trX2[n17] - d.width;
                int n18 = j2++;
                trY2[n18] = trY2[n18] - d.height;
            }
        }
        for (i3 = 0; i3 < component.getSecondCrown().length; ++i3) {
            d = this.getTranslation(component.getSecondCrown()[i3], component.getActiveNode(), component.isLinked(component.getSecondCrown()[i3], component.getActiveNode()), 2, 0);
            int n = i3;
            trX2[n] = trX2[n] + d.width;
            int n19 = i3;
            trY2[n19] = trY2[n19] + d.height;
            for (j2 = 0; j2 < component.getFirstCrown().length; ++j2) {
                d = this.getTranslation(component.getSecondCrown()[i3], component.getFirstCrown()[j2], component.isLinked(component.getSecondCrown()[i3], component.getFirstCrown()[j2]), 2, 1);
                int n20 = i3;
                trX2[n20] = trX2[n20] + d.width;
                int n21 = i3;
                trY2[n21] = trY2[n21] + d.height;
            }
            j2 = 0;
            while (j2 < component.getSecondCrown().length) {
                d = this.getTranslation(component.getSecondCrown()[i3], component.getSecondCrown()[j2], component.isLinked(component.getSecondCrown()[i3], component.getSecondCrown()[j2]), 2, 2);
                int n22 = i3;
                trX2[n22] = trX2[n22] + d.width;
                int n23 = i3;
                trY2[n23] = trY2[n23] + d.height;
                int n24 = j2;
                trX2[n24] = trX2[n24] - d.width;
                int n25 = j2++;
                trY2[n25] = trY2[n25] - d.height;
            }
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        component.getActiveNode().setLocation(component.getActiveNode().getLocation().x + trX0[0], component.getActiveNode().getLocation().y + trY0[0]);
        if (component.getActiveNode().getLocation().x < minX) {
            minX = component.getActiveNode().getLocation().x;
        }
        if (component.getActiveNode().getLocation().y < minY) {
            minY = component.getActiveNode().getLocation().y;
        }
        for (i2 = 0; i2 < trX1.length; ++i2) {
            component.getFirstCrown()[i2].setLocation(component.getFirstCrown()[i2].getLocation().x + trX1[i2], component.getFirstCrown()[i2].getLocation().y + trY1[i2]);
            if (component.getFirstCrown()[i2].getLocation().x < minX) {
                minX = component.getFirstCrown()[i2].getLocation().x;
            }
            if (component.getFirstCrown()[i2].getLocation().y >= minY) continue;
            minY = component.getFirstCrown()[i2].getLocation().y;
        }
        for (i2 = 0; i2 < trX2.length; ++i2) {
            component.getSecondCrown()[i2].setLocation(component.getSecondCrown()[i2].getLocation().x + trX2[i2], component.getSecondCrown()[i2].getLocation().y + trY2[i2]);
            if (component.getSecondCrown()[i2].getLocation().x < minX) {
                minX = component.getSecondCrown()[i2].getLocation().x;
            }
            if (component.getSecondCrown()[i2].getLocation().y >= minY) continue;
            minY = component.getSecondCrown()[i2].getLocation().y;
        }
        for (i2 = 0; i2 < component.getNumberNodes().length; ++i2) {
            if (component.getNumberNodes()[i2].getX() < minX) {
                minX = component.getNumberNodes()[i2].getX();
            }
            if (component.getNumberNodes()[i2].getY() >= minY) continue;
            minY = component.getNumberNodes()[i2].getY();
        }
        int xx = minX < 10 ? (int)Math.floor((double)minX / 10.0) : (int)Math.ceil((double)minX / 10.0);
        int yy = minY < 10 ? (int)Math.floor((double)minY / 10.0) : (int)Math.ceil((double)minY / 10.0);
        component.getActiveNode().setLocation(component.getActiveNode().getLocation().x - xx, component.getActiveNode().getLocation().y - yy);
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            component.getFirstCrown()[i].setLocation(component.getFirstCrown()[i].getLocation().x - xx, component.getFirstCrown()[i].getLocation().y - yy);
        }
        for (i = 0; i < component.getSecondCrown().length; ++i) {
            component.getSecondCrown()[i].setLocation(component.getSecondCrown()[i].getLocation().x - xx, component.getSecondCrown()[i].getLocation().y - yy);
        }
        for (i = 0; i < component.getNumberNodes().length; ++i) {
            component.getNumberNodes()[i].setLocation(component.getNumberNodes()[i].getLocation().x - xx, component.getNumberNodes()[i].getLocation().y - yy);
        }
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            for (j = 0; j < component.getNumberNodes().length; ++j) {
                if (!component.getNumberNodes()[j].equals(component.getNumberNode(component.getFirstCrown()[i]))) continue;
                int dx = component.getFirstCrown()[i].getX() + component.getFirstCrown()[i].getWidth() / 2 - component.getActiveNode().getX() - component.getActiveNode().getWidth() / 2;
                int dy = component.getFirstCrown()[i].getY() + component.getFirstCrown()[i].getHeight() / 2 - component.getActiveNode().getY() - component.getActiveNode().getHeight() / 2;
                int dw = (component.getNumberNodes()[j].getWidth() - component.getFirstCrown()[i].getWidth()) / 2;
                int dh = (component.getNumberNodes()[j].getHeight() - component.getFirstCrown()[i].getHeight()) / 2;
                component.getNumberNodes()[j].setLocation(component.getFirstCrown()[i].getX() + dx / 2 - dw, component.getFirstCrown()[i].getY() + dy / 2 - dh);
            }
        }
        for (i = 0; i < component.getSecondCrown().length; ++i) {
            for (j = 0; j < component.getNumberNodes().length; ++j) {
                int dy;
                int dx;
                if (!component.getNumberNodes()[j].equals(component.getNumberNode(component.getSecondCrown()[i]))) continue;
                Component c = null;
                for (int k3 = 0; k3 < component.getFirstCrown().length; ++k3) {
                    if (!component.isInCrownOf(component.getFirstCrown()[k3], component.getSecondCrown()[i])) continue;
                    c = component.getFirstCrown()[k3];
                }
                if (c != null) {
                    dx = component.getSecondCrown()[i].getX() - c.getX();
                    dy = component.getSecondCrown()[i].getY() - c.getY();
                    component.getNumberNodes()[j].setLocation(component.getSecondCrown()[i].getX() + dx / 2, component.getSecondCrown()[i].getY() + dy / 2);
                    continue;
                }
                dx = component.getSecondCrown()[i].getX() - component.getActiveNode().getX();
                dy = component.getSecondCrown()[i].getY() - component.getActiveNode().getY();
                component.getNumberNodes()[j].setLocation(component.getSecondCrown()[i].getX() + dx / 2, component.getSecondCrown()[i].getY() + dy / 2);
            }
        }
        component.resizeLinks();
        for (i = 0; i < component.getArrows().length; ++i) {
            int x1 = component.getFirstNode((int)i).getLocation().x;
            int y1 = component.getFirstNode((int)i).getLocation().y;
            int w1 = component.getFirstNode((int)i).getSize().width;
            int h1 = component.getFirstNode((int)i).getSize().height;
            int x2 = component.getSecondNode((int)i).getLocation().x;
            int y2 = component.getSecondNode((int)i).getLocation().y;
            int w2 = component.getSecondNode((int)i).getSize().width;
            int h2 = component.getSecondNode((int)i).getSize().height;
            int x = x1 + w1 / 2 < x2 + w2 / 2 ? x1 + w1 / 2 : x2 + w2 / 2;
            int y = y1 + h1 / 2 < y2 + h2 / 2 ? y1 + h1 / 2 : y2 + h2 / 2;
            int w0 = x1 + w1 / 2 > x2 + w2 / 2 ? x1 + w1 / 2 - x : x2 + w2 / 2 - x;
            int h0 = y1 + h1 / 2 > y2 + h2 / 2 ? y1 + h1 / 2 - y : y2 + h2 / 2 - y;
            component.getArrows()[i].setLocation(x + w0 / 2 - 5, y + h0 / 2 - 5);
            component.getArrows()[i].setSize(10, 10);
            component.getArrows()[i].setArrow(LinkFactory.createArrow(x1 + w1 / 2, y1 + h1 / 2, x2 + w2 / 2, y2 + h2 / 2));
        }
    }

    protected void redraw(GraphPanel component) {
        int j;
        int i;
        component.getActiveNode().setSize(component.getActiveNode().getPreferredSize());
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            component.getFirstCrown()[i].setSize(component.getFirstCrown()[i].getPreferredSize());
        }
        for (i = 0; i < component.getSecondCrown().length; ++i) {
            component.getSecondCrown()[i].setSize(component.getSecondCrown()[i].getPreferredSize());
        }
        component.getActiveNode().setLocation(component.getActiveNode().getLocation().x, component.getActiveNode().getLocation().y);
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            component.getFirstCrown()[i].setLocation(component.getFirstCrown()[i].getLocation().x, component.getFirstCrown()[i].getLocation().y);
        }
        for (i = 0; i < component.getSecondCrown().length; ++i) {
            component.getSecondCrown()[i].setLocation(component.getSecondCrown()[i].getLocation().x, component.getSecondCrown()[i].getLocation().y);
        }
        for (i = 0; i < component.getFirstCrown().length; ++i) {
            for (j = 0; j < component.getNumberNodes().length; ++j) {
                if (!component.getNumberNodes()[j].equals(component.getNumberNode(component.getFirstCrown()[i]))) continue;
                int dx = component.getFirstCrown()[i].getX() + component.getFirstCrown()[i].getWidth() / 2 - component.getActiveNode().getX() - component.getActiveNode().getWidth() / 2;
                int dy = component.getFirstCrown()[i].getY() + component.getFirstCrown()[i].getHeight() / 2 - component.getActiveNode().getY() - component.getActiveNode().getHeight() / 2;
                int dw = (component.getNumberNodes()[j].getWidth() - component.getFirstCrown()[i].getWidth()) / 2;
                int dh = (component.getNumberNodes()[j].getHeight() - component.getFirstCrown()[i].getHeight()) / 2;
                component.getNumberNodes()[j].setLocation(component.getFirstCrown()[i].getX() + dx / 2 - dw, component.getFirstCrown()[i].getY() + dy / 2 - dh);
            }
        }
        for (i = 0; i < component.getSecondCrown().length; ++i) {
            for (j = 0; j < component.getNumberNodes().length; ++j) {
                int dy;
                int dx;
                if (!component.getNumberNodes()[j].equals(component.getNumberNode(component.getSecondCrown()[i]))) continue;
                Component c = null;
                for (int k = 0; k < component.getFirstCrown().length; ++k) {
                    if (!component.isInCrownOf(component.getFirstCrown()[k], component.getSecondCrown()[i])) continue;
                    c = component.getFirstCrown()[k];
                }
                if (c != null) {
                    dx = component.getSecondCrown()[i].getX() - c.getX();
                    dy = component.getSecondCrown()[i].getY() - c.getY();
                    component.getNumberNodes()[j].setLocation(component.getSecondCrown()[i].getX() + dx / 2, component.getSecondCrown()[i].getY() + dy / 2);
                    continue;
                }
                dx = component.getSecondCrown()[i].getX() - component.getActiveNode().getX();
                dy = component.getSecondCrown()[i].getY() - component.getActiveNode().getY();
                component.getNumberNodes()[j].setLocation(component.getSecondCrown()[i].getX() + dx / 2, component.getSecondCrown()[i].getY() + dy / 2);
            }
        }
        component.resizeLinks();
        for (i = 0; i < component.getArrows().length; ++i) {
            int x1 = component.getFirstNode((int)i).getLocation().x;
            int y1 = component.getFirstNode((int)i).getLocation().y;
            int w1 = component.getFirstNode((int)i).getSize().width;
            int h1 = component.getFirstNode((int)i).getSize().height;
            int x2 = component.getSecondNode((int)i).getLocation().x;
            int y2 = component.getSecondNode((int)i).getLocation().y;
            int w2 = component.getSecondNode((int)i).getSize().width;
            int h2 = component.getSecondNode((int)i).getSize().height;
            int x = x1 + w1 / 2 < x2 + w2 / 2 ? x1 + w1 / 2 : x2 + w2 / 2;
            int y = y1 + h1 / 2 < y2 + h2 / 2 ? y1 + h1 / 2 : y2 + h2 / 2;
            int w0 = x1 + w1 / 2 > x2 + w2 / 2 ? x1 + w1 / 2 - x : x2 + w2 / 2 - x;
            int h0 = y1 + h1 / 2 > y2 + h2 / 2 ? y1 + h1 / 2 - y : y2 + h2 / 2 - y;
            component.getArrows()[i].setLocation(x + w0 / 2 - 5, y + h0 / 2 - 5);
            component.getArrows()[i].setSize(10, 10);
            component.getArrows()[i].setArrow(LinkFactory.createArrow(x1 + w1 / 2, y1 + h1 / 2, x2 + w2 / 2, y2 + h2 / 2));
        }
    }

    private Dimension getTranslation(JComponent c1, JComponent c2, boolean linked, int crown1, int crown2) {
        double dy;
        int x0 = c1.getX() + c1.getWidth() / 2;
        int x1 = c2.getX() + c2.getWidth() / 2;
        int y0 = c1.getY() + c1.getHeight() / 2;
        int y1 = c2.getY() + c2.getHeight() / 2;
        int w0 = c1.getWidth();
        int h0 = c1.getHeight();
        double dx = Math.max(Math.abs(x1 - x0), w0) - w0;
        if (dx + (dy = (double)(Math.max(Math.abs(y1 - y0), h0) - h0)) == 0.0) {
            if (Math.random() < 0.5) {
                dx += 1.0;
            } else {
                dy += 1.0;
            }
        }
        int px = x0 >= x1 ? 1 : -1;
        int py = y0 >= y1 ? 1 : -1;
        double d = Math.sqrt(dx * dx + dy * dy);
        int tooFar = Integer.MAX_VALUE;
        int tooNear = 0;
        block0 : switch (crown1) {
            case 1: {
                switch (crown2) {
                    case 0: {
                        tooNear = this.tooNear1;
                        tooFar = this.tooFar1;
                        break;
                    }
                    case 1: {
                        tooNear = this.tooNear1;
                        tooFar = this.tooFar1;
                    }
                }
                break;
            }
            case 2: {
                switch (crown2) {
                    case 0: {
                        tooNear = this.tooNear2;
                        tooFar = this.tooFar2;
                        break block0;
                    }
                    case 1: {
                        tooNear = this.tooNear2;
                        tooFar = this.tooFar2;
                        break block0;
                    }
                    case 2: {
                        tooNear = this.tooNear2;
                        tooFar = this.tooFar2;
                    }
                }
            }
        }
        double eloignement = Math.max((double)tooNear - d, 0.0);
        double rapprochement = 0.0;
        if (linked) {
            rapprochement = Math.max(d - (double)tooFar, 0.0);
        }
        int tx = (int)((double)px * (eloignement / 5.0 - rapprochement / 10.0) * Math.abs(dx / (dx + dy)));
        int ty = (int)((double)py * (eloignement / 5.0 - rapprochement / 10.0) * Math.abs(dy / (dx + dy)));
        if (Math.abs(tx) < 5) {
            tx = 0;
        }
        if (Math.abs(ty) < 5) {
            ty = 0;
        }
        return new Dimension(tx, ty);
    }
}

