/*
 * Decompiled with CFR 0.152.
 */
package ihm.townto;

import ihm.Charte;
import ihm.townto.LinkFailureException;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;

public class Graph {
    protected Node activeConcept;
    protected Vector firstCrown;
    protected Vector secondCrown;
    protected Vector links;
    protected int maxIdCrown1 = 1;
    protected int maxIdCrown2 = 1;
    protected static final int MAX_NODES_1 = 30;
    protected static final int MAX_NODES_2 = 30;
    protected int maxParCour1 = 10;
    protected boolean suppr = false;

    public Graph() {
        this.setActive("", "");
        this.suppr = false;
    }

    public static int getMaxNumberofNodes() {
        return 61;
    }

    public int getNumberOfNodes() {
        return 1 + this.firstCrown.size() + this.secondCrown.size();
    }

    public boolean isExhaustive() {
        return !this.suppr;
    }

    public void setActive(String concept, String description) {
        this.activeConcept = new Node(concept, description, 0);
        this.firstCrown = new Vector();
        this.secondCrown = new Vector();
        this.links = new Vector();
        this.maxIdCrown1 = 1;
        this.maxIdCrown2 = 1;
    }

    public String getActiveConcept() {
        return this.activeConcept.getName();
    }

    public void addLink(String linkFrom, String descFrom, String linkTo, String descTo, String linkName) throws LinkFailureException {
        this.addLink(linkFrom, descFrom, 0, linkTo, descTo, 0, linkName);
    }

    public void addLink(String linkFrom, String descFrom, int countFrom, String linkTo, String descTo, int countTo, String linkName) throws LinkFailureException {
        Node s;
        int i;
        Node nodeFrom = new Node("", "", -1);
        Node nodeTo = new Node("", "", -1);
        if (linkFrom.equalsIgnoreCase(this.activeConcept.getName())) {
            nodeFrom = this.activeConcept;
        }
        if (linkTo.equalsIgnoreCase(this.activeConcept.getName())) {
            nodeTo = this.activeConcept;
        }
        for (i = 0; i < this.firstCrown.size(); ++i) {
            s = (Node)this.firstCrown.elementAt(i);
            if (linkFrom.equalsIgnoreCase(s.getName())) {
                nodeFrom = s;
            }
            if (!linkTo.equalsIgnoreCase(s.getName())) continue;
            nodeTo = s;
        }
        for (i = 0; i < this.secondCrown.size(); ++i) {
            s = (Node)this.secondCrown.elementAt(i);
            if (linkFrom.equalsIgnoreCase(s.getName())) {
                nodeFrom = s;
            }
            if (!linkTo.equalsIgnoreCase(s.getName())) continue;
            nodeTo = s;
        }
        if (nodeFrom.getId() == -1 && nodeTo.getId() == -1) {
            throw new LinkFailureException(Charte.getMessage("Graph_Error_NoConcept") + " " + linkFrom + " " + Charte.getMessage("Graph_Error_NoConcept2") + " " + linkTo + ".");
        }
        if (nodeFrom.getId() == nodeTo.getId()) {
            throw new LinkFailureException(Charte.getMessage("Graph_Error_SameConcept") + " " + linkFrom + " " + Charte.getMessage("Graph_Error_SameConcept2") + " " + linkTo + ".");
        }
        int nFrom = nodeFrom.getId();
        int nTo = nodeTo.getId();
        if (nFrom == -1) {
            if (nTo <= 9) {
                nFrom = this.maxIdCrown1 * 10 + nTo;
                ++this.maxIdCrown1;
                nodeFrom = new Node(linkFrom, descFrom, nFrom, countFrom);
                this.addToFirstCrown(nodeFrom);
            }
            if (nTo >= 10 && nTo <= 999) {
                nFrom = this.maxIdCrown2 * 1000 + nTo;
                ++this.maxIdCrown2;
                nodeFrom = new Node(linkFrom, descFrom, nFrom, countFrom);
                this.addToSecondCrown(nodeFrom);
            }
            if (nTo >= 1000 && nTo <= 99999) {
                ++nodeFrom.relations;
                throw new LinkFailureException(Charte.getMessage("Graph_Error_ThirdCrown"));
            }
        }
        if (nTo == -1) {
            if (nFrom <= 9) {
                nTo = this.maxIdCrown1 * 10 + nFrom;
                ++this.maxIdCrown1;
                nodeTo = new Node(linkTo, descTo, nTo, countTo);
                this.addToFirstCrown(nodeTo);
            }
            if (nFrom >= 10 && nFrom <= 999) {
                nTo = this.maxIdCrown2 * 1000 + nFrom;
                ++this.maxIdCrown2;
                nodeTo = new Node(linkTo, descTo, nTo, countTo);
                this.addToSecondCrown(nodeTo);
            }
            if (nFrom >= 1000 && nFrom <= 99999) {
                ++nodeTo.relations;
                throw new LinkFailureException(Charte.getMessage("Graph_Error_ThirdCrown"));
            }
        }
        this.addToLinks(new Link(nodeFrom, nodeTo, linkName));
    }

    GraphNode getActive() {
        return new GraphNode(this.activeConcept);
    }

    GraphNode[] getSortedFirstCrown() {
        Node[] n = new Node[this.firstCrown.size()];
        this.firstCrown.toArray(n);
        Graph.sortFirst(n);
        GraphNode[] result = new GraphNode[n.length];
        for (int i = 0; i < n.length; ++i) {
            HashSet<Link> linkSet = new HashSet<Link>();
            boolean ok = true;
            for (int j = 0; j < this.links.size(); ++j) {
                Link link = (Link)this.links.elementAt(j);
                if (link.getFrom() != n[i].getId() && link.getTo() != n[i].getId()) continue;
                if (link.getFrom() == 0 || link.getTo() == 0) {
                    if (!ok) continue;
                    ok = false;
                    linkSet.add(link);
                    continue;
                }
                linkSet.add(link);
            }
            result[i] = new GraphNode(n[i], linkSet.size());
        }
        return result;
    }

    GraphNode[] getSortedSecondCrown() {
        Node[] nc1 = new Node[this.firstCrown.size()];
        Node[] nc2 = new Node[this.secondCrown.size()];
        this.firstCrown.toArray(nc1);
        this.secondCrown.toArray(nc2);
        Graph.sortFirst(nc1);
        nc2 = Graph.sortSecond(nc1, nc2);
        GraphNode[] result = new GraphNode[nc2.length];
        for (int i = 0; i < nc2.length; ++i) {
            HashSet<Link> linkSet = new HashSet<Link>();
            boolean ok = true;
            for (int j = 0; j < this.links.size(); ++j) {
                Link link = (Link)this.links.elementAt(j);
                if (link.getFrom() != nc2[i].getId() && link.getTo() != nc2[i].getId()) continue;
                if (link.getFrom() == 0 || link.getTo() == 0) {
                    if (!ok) continue;
                    ok = false;
                    linkSet.add(link);
                    continue;
                }
                linkSet.add(link);
            }
            result[i] = new GraphNode(nc2[i], linkSet.size());
        }
        return result;
    }

    GraphLink[] getLinks() {
        Link[] l = new Link[this.links.size()];
        this.links.toArray(l);
        GraphLink[] result = new GraphLink[this.links.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new GraphLink(l[i]);
        }
        return result;
    }

    protected static void sortFirst(Node[] firstNodes) {
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Node)o1).getName().compareToIgnoreCase(((Node)o2).getName());
            }
        };
        Arrays.sort(firstNodes, cmp);
    }

    protected static Node[] sortSecond(Node[] sortedFirstNodes, Node[] secondNodes) {
        Vector<Node> result = new Vector<Node>();
        for (int i = 0; i < sortedFirstNodes.length; ++i) {
            int idToFind = sortedFirstNodes[i].getId();
            for (int j = 0; j < secondNodes.length; ++j) {
                int idFound = secondNodes[j].getId() % 1000;
                if (idFound != idToFind) continue;
                result.addElement(secondNodes[j]);
            }
        }
        Node[] nres = new Node[result.size()];
        result.toArray(nres);
        return nres;
    }

    protected void addToFirstCrown(Node node) {
        this.firstCrown.addElement(node);
        if (this.firstCrown.size() > 30) {
            this.maxParCour1 = 0;
            this.clearSecondCrown();
        }
    }

    protected void clearSecondCrown() {
        for (int i = 0; i < this.firstCrown.size(); ++i) {
            int baseId = ((Node)this.firstCrown.elementAt(i)).getId();
            int nb = 0;
            for (int j = 0; j < this.secondCrown.size(); ++j) {
                int nodeId = ((Node)this.secondCrown.elementAt(j)).getId();
                boolean removed = false;
                for (int k = 0; k < this.links.size(); ++k) {
                    Link link = (Link)this.links.elementAt(k);
                    if ((link.getFrom() != nodeId || link.getTo() != baseId) && (link.getTo() != nodeId || link.getFrom() != baseId)) continue;
                    if (nb >= this.maxParCour1) {
                        this.secondCrown.remove(j);
                        removed = true;
                        this.suppr = true;
                        this.links.remove(k);
                        --k;
                        continue;
                    }
                    ++nb;
                }
                if (!removed) continue;
                --j;
            }
        }
    }

    protected void addToSecondCrown(Node node) {
        if (this.maxParCour1 > 0) {
            boolean hasEnoughPlace;
            this.secondCrown.addElement(node);
            this.clearSecondCrown();
            boolean bl = hasEnoughPlace = this.secondCrown.size() < 30 && this.firstCrown.size() <= 30;
            if (!hasEnoughPlace) {
                --this.maxParCour1;
                this.clearSecondCrown();
            }
        }
    }

    protected void addToLinks(Link link) {
        boolean areIn;
        int i;
        int id1 = link.getFrom();
        int id2 = link.getTo();
        boolean b1 = false;
        boolean b2 = false;
        if (id1 == this.activeConcept.getId()) {
            b1 = true;
        }
        if (id2 == this.activeConcept.getId()) {
            b2 = true;
        }
        for (i = 0; i < this.firstCrown.size(); ++i) {
            if (id1 == ((Node)this.firstCrown.elementAt(i)).getId()) {
                b1 = true;
            }
            if (id2 != ((Node)this.firstCrown.elementAt(i)).getId()) continue;
            b2 = true;
        }
        for (i = 0; i < this.secondCrown.size(); ++i) {
            if (id1 == ((Node)this.secondCrown.elementAt(i)).getId()) {
                b1 = true;
            }
            if (id2 != ((Node)this.secondCrown.elementAt(i)).getId()) continue;
            b2 = true;
        }
        boolean bl = areIn = b1 && b2;
        if (areIn) {
            this.links.addElement(link);
        }
    }

    protected class Node {
        protected String name;
        protected String description;
        protected int id;
        protected int relations;

        protected Node(String name, String description, int id) {
            this(name, description, id, 0);
        }

        protected Node(String name, String description, int id, int relations) {
            this.name = name;
            this.description = description;
            this.id = id;
            this.relations = relations;
        }

        protected String getName() {
            return this.name;
        }

        protected String getDescription() {
            return this.description;
        }

        protected int getId() {
            return this.id;
        }

        protected int getRelationsCount() {
            return this.relations;
        }
    }

    protected class Link {
        protected int idFrom;
        protected int idTo;
        protected String linkName;

        protected Link(Node from, Node to, String name) {
            this.idFrom = from.getId();
            this.idTo = to.getId();
            this.linkName = name;
        }

        protected int getFrom() {
            return this.idFrom;
        }

        protected int getTo() {
            return this.idTo;
        }

        protected String getName() {
            return this.linkName;
        }
    }

    class GraphLink {
        protected int concept1;
        protected int concept2;
        protected String linkText;
        protected Color color;

        protected GraphLink(Link link) {
            this.concept1 = link.getFrom();
            this.concept2 = link.getTo();
            this.linkText = link.getName();
            this.color = Charte.getForeground();
        }

        public int getIdConcept1() {
            return this.concept1;
        }

        public int getIdConcept2() {
            return this.concept2;
        }

        public String getText() {
            return this.linkText;
        }

        public Color getColor() {
            return this.color;
        }
    }

    class GraphNode {
        protected String name;
        protected String description;
        protected int id;
        protected int relations;
        public static final int MIN_ACTIVE = 0;
        public static final int MAX_ACTIVE = 9;
        public static final int MIN_CROWN1 = 10;
        public static final int MAX_CROWN1 = 999;
        public static final int MIN_CROWN2 = 1000;
        public static final int MAX_CROWN2 = 99999;

        protected GraphNode(Node node) {
            this(node, 0);
        }

        protected GraphNode(Node node, int drawnRelations) {
            this.name = node.getName();
            this.description = node.getDescription();
            this.id = node.getId();
            this.relations = node.getRelationsCount() - drawnRelations;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public int getRelationsCount() {
            return this.relations;
        }
    }
}

