/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Association;
import data.Confrontation;
import data.Graphe;
import data.Lien;
import data.Noeud;
import ihm.Charte;
import ihm.Legende;
import ihm.townto.EventHandler;
import ihm.townto.EventListener;
import ihm.townto.Graph;
import ihm.townto.GraphPanel;
import ihm.townto.LinkFailureException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelVisualisation
extends JTabbedPane
implements EventListener {
    private final Confrontation conf;
    private final GraphPanel[] gPanel;

    public PanelVisualisation(Confrontation confrontation) {
        super(1, 0);
        int i;
        Charte.formate(this);
        this.conf = confrontation;
        this.gPanel = new GraphPanel[this.conf.getNombreDeGraphes()];
        EventHandler.register(this);
        Legende legende = new Legende(confrontation.getAllNomsGraphes());
        for (i = 0; i < confrontation.getNombreDeGraphes(); ++i) {
            JSplitPane pVisuGraphe = new JSplitPane(1);
            Charte.formate(pVisuGraphe);
            pVisuGraphe.setContinuousLayout(true);
            Noeud[] noeuds = confrontation.getGrapheAt(i).getAllNoeuds();
            final JList<Noeud> lNoeuds = new JList<Noeud>(noeuds);
            Charte.formate(lNoeuds);
            lNoeuds.setDragEnabled(true);
            lNoeuds.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel res = new JLabel(((Noeud)value).getLabel());
                    Charte.formate(res);
                    if (isSelected) {
                        res.setOpaque(true);
                        res.setBackground(new Color(0, 0, 0, 64));
                    }
                    return res;
                }
            });
            JScrollPane jspNoeuds = new JScrollPane(lNoeuds);
            Charte.formate(jspNoeuds);
            Charte.formate(jspNoeuds.getViewport());
            Charte.formate(jspNoeuds.getHorizontalScrollBar());
            Charte.formate(jspNoeuds.getVerticalScrollBar());
            pVisuGraphe.setLeftComponent(jspNoeuds);
            final int j = i;
            Graph graph = this.remplissageGraphe(confrontation, j, confrontation.getGrapheAt(j).getAllNoeuds()[0]);
            if (!graph.isExhaustive() && this.hasFocus()) {
                JOptionPane.showMessageDialog(this, Charte.getMessage("PanelConf_GrapheTropGros"), Charte.getMessage("PanelConf_GrapheTropGrosT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
            }
            this.gPanel[j] = new GraphPanel(graph, i);
            JScrollPane spGraphe = new JScrollPane(this.gPanel[j]){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension((int)((double)this.getSize().width * 0.8), this.getSize().height);
                }
            };
            Charte.formate(spGraphe);
            Charte.formate(spGraphe.getViewport());
            Charte.formate(spGraphe.getHorizontalScrollBar());
            Charte.formate(spGraphe.getVerticalScrollBar());
            lNoeuds.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    PanelVisualisation.this.gPanel[j].setGraph(PanelVisualisation.this.remplissageGraphe(PanelVisualisation.this.conf, j, (Noeud)lNoeuds.getSelectedValue()));
                }
            });
            pVisuGraphe.setRightComponent(spGraphe);
            this.addTab(confrontation.getGrapheAt(i).getNom(), legende.getIconeIndicateur(i), pVisuGraphe);
            pVisuGraphe.setDividerSize(5);
            pVisuGraphe.setDividerLocation(0.2);
        }
        for (i = 0; i < this.getTabCount(); ++i) {
            this.setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        this.setOpaque(false);
    }

    @Override
    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode / 1000 == 1) {
            int cnf = eventCode - 1000;
            this.gPanel[cnf].setGraph(this.remplissageGraphe(this.conf, cnf, this.conf.getGrapheAt(cnf).trouveNoeud(eventContent)));
        }
    }

    private Graph remplissageGraphe(Confrontation cnf, int grp, Noeud cnt) {
        Graphe g = cnf.getGrapheAt(grp);
        Graph res = new Graph();
        res.setActive(cnt.getLabel(), cnt.getDescription());
        Association[] cour1 = g.getAssociationsContenant(cnt);
        for (int i = 0; i < cour1.length; ++i) {
            try {
                Association[] cour2;
                Noeud o = cour1[i].getOrigine();
                Noeud d = cour1[i].getDestination();
                Lien l = cour1[i].getLien();
                if (o.getLabel().equals(cnt.getLabel())) {
                    cour2 = g.getAssociationsContenant(d);
                    res.addLink(cnt.getLabel(), cnt.getDescription(), 0, d.getLabel(), d.getDescription(), cour2.length, l.getLabel() + " (" + l.getType().getNom() + ")");
                    continue;
                }
                if (!d.getLabel().equals(cnt.getLabel())) continue;
                cour2 = g.getAssociationsContenant(o);
                res.addLink(o.getLabel(), o.getDescription(), cour2.length, cnt.getLabel(), cnt.getDescription(), 0, l.getLabel() + " (" + l.getType().getNom() + ")");
                continue;
            }
            catch (LinkFailureException lfe) {
                // empty catch block
            }
        }
        return res;
    }
}

