/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Confrontation;
import ihm.Charte;
import ihm.FenetrePrincipale;
import ihm.townto.EventHandler;
import ihm.townto.EventListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;

public class PanelNotes
extends JTabbedPane
implements EventListener {
    private Confrontation confrontation;
    private FenetrePrincipale fenetre;
    private JPanel pCaptures;

    public PanelNotes(Confrontation confrontation, FenetrePrincipale fenetre) {
        Charte.formate(this);
        this.confrontation = confrontation;
        this.fenetre = fenetre;
        EventHandler.register(this);
        this.pCaptures = new ListeImages();
        Charte.formate(this.pCaptures);
        this.pCaptures.setLayout(new BoxLayout(this.pCaptures, 1));
        JScrollPane spCaptures = new JScrollPane(this.pCaptures);
        Charte.formate(spCaptures);
        Charte.formate(spCaptures.getViewport());
        Charte.formate(spCaptures.getHorizontalScrollBar());
        Charte.formate(spCaptures.getVerticalScrollBar());
        this.calculePCaptures();
        this.add(Charte.getMessage("PanelNotes_TabC"), spCaptures);
    }

    private void calculePCaptures() {
        this.pCaptures.removeAll();
        FileFilter filtre = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("png");
            }
        };
        File f0 = this.fenetre.getDossier();
        if (f0 != null && f0.exists() && f0.isDirectory()) {
            File[] f = f0.listFiles(filtre);
            ImageIcon[] img = new ImageIcon[f.length];
            for (int i = 0; i < img.length; ++i) {
                img[i] = new ImageIcon(f[i].getPath());
                JLabel l = new JLabel(img[i]);
                l.setHorizontalAlignment(0);
                Charte.formate(l);
                l.setBorder(Charte.getBorder());
                l.setToolTipText(f[i].getName());
                JPanel pp = new JPanel(new GridLayout(1, 1));
                Charte.formate(pp);
                pp.add(l);
                this.pCaptures.add(pp);
            }
        }
    }

    @Override
    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode == 5001) {
            this.calculePCaptures();
        }
    }

    private class ListeImages
    extends JPanel
    implements Scrollable {
        private ListeImages() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

