/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Confrontation;
import data.ListeSynonymes;
import data.MotHomonyme;
import data.TexteCommun;
import ihm.Charte;
import ihm.DialogueAnnotation;
import ihm.Legende;
import ihm.townto.EventHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;

public class PanelHomonymes
extends JTabbedPane {
    private Legende legende;
    private Confrontation confrontation;
    private PanelHomonymes parent;
    private JSplitPane pNoeuds;
    private JSplitPane pTypesLiens;
    private JSplitPane pProprietes;
    private boolean helpPNoeuds = false;
    private boolean helpPTypesLiens = false;
    private boolean helpPProprietes = false;
    private JList lNPolys;
    private JList lNTermes2;
    private JScrollPane jspNPolys;
    private JScrollPane jspNTermes2;
    private DropTarget dtN;
    private DropTarget dtN2;
    private JList lTPolys;
    private JList lTTermes2;
    private JScrollPane jspTPolys;
    private JScrollPane jspTTermes2;
    private DropTarget dtT;
    private DropTarget dtT2;
    private JList lPPolys;
    private JList lPTermes2;
    private JScrollPane jspPPolys;
    private JScrollPane jspPTermes2;
    private DropTarget dtP;
    private DropTarget dtP2;

    public PanelHomonymes(Confrontation confrontation) {
        super(1, 0);
        Charte.formate(this);
        this.parent = this;
        this.confrontation = confrontation;
        this.legende = new Legende(confrontation.getAllNomsGraphes());
        this.calculePNoeuds();
        this.calculePTypesLiens();
        this.calculePProprietes();
        this.add(Charte.getMessage("PanelHomo_TabT"), this.pNoeuds);
        this.add(Charte.getMessage("PanelHomo_TabTR"), this.pTypesLiens);
        this.add(Charte.getMessage("PanelHomo_TabP"), this.pProprietes);
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setBackgroundAt(i, new Color(0, 0, 0, 64));
        }
        this.setOpaque(false);
        this.pNoeuds.setDividerSize(5);
        this.pNoeuds.setDividerLocation(0.5);
        this.pTypesLiens.setDividerSize(5);
        this.pTypesLiens.setDividerLocation(0.5);
        this.pProprietes.setDividerSize(5);
        this.pProprietes.setDividerLocation(0.5);
    }

    private void calculePNoeuds() {
        this.pNoeuds = new JSplitPane(0);
        Charte.formate(this.pNoeuds);
        this.pNoeuds.setContinuousLayout(true);
        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(2);
        labTermes2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelHomonymes.this.helpPNoeuds) {
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    PanelHomonymes.this.helpPNoeuds = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrT"));
                    PanelHomonymes.this.helpPNoeuds = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());
        this.jspNTermes2 = new JScrollPane();
        Charte.formate(this.jspNTermes2);
        Charte.formate(this.jspNTermes2.getViewport());
        Charte.formate(this.jspNTermes2.getHorizontalScrollBar());
        Charte.formate(this.jspNTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add((Component)labTermes2, "North");
        pTermes2.add((Component)this.jspNTermes2, "Center");
        this.pNoeuds.setTopComponent(pTermes2);
        JLabel labPoly = new JLabel(Charte.getMessage("PanelHomo_TxtList"), 0);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add((Component)labPoly, "Center");
        Charte.formate(pPoly);
        this.jspNPolys = new JScrollPane();
        Charte.formate(this.jspNPolys);
        Charte.formate(this.jspNPolys.getViewport());
        Charte.formate(this.jspNPolys.getHorizontalScrollBar());
        Charte.formate(this.jspNPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add((Component)pPoly, "North");
        pPolys.add((Component)this.jspNPolys, "Center");
        this.pNoeuds.setBottomComponent(pPolys);
        this.refaisListesN();
    }

    private void calculePTypesLiens() {
        this.pTypesLiens = new JSplitPane(0);
        Charte.formate(this.pTypesLiens);
        this.pTypesLiens.setContinuousLayout(true);
        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(2);
        labTermes2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelHomonymes.this.helpPTypesLiens) {
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    PanelHomonymes.this.helpPTypesLiens = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrTR"));
                    PanelHomonymes.this.helpPTypesLiens = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());
        this.jspTTermes2 = new JScrollPane();
        Charte.formate(this.jspTTermes2);
        Charte.formate(this.jspTTermes2.getViewport());
        Charte.formate(this.jspTTermes2.getHorizontalScrollBar());
        Charte.formate(this.jspTTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add((Component)labTermes2, "North");
        pTermes2.add((Component)this.jspTTermes2, "Center");
        this.pTypesLiens.setTopComponent(pTermes2);
        JLabel labPoly = new JLabel(Charte.getMessage("PanelHomo_TxtList"), 0);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add((Component)labPoly, "Center");
        Charte.formate(pPoly);
        this.jspTPolys = new JScrollPane();
        Charte.formate(this.jspTPolys);
        Charte.formate(this.jspTPolys.getViewport());
        Charte.formate(this.jspTPolys.getHorizontalScrollBar());
        Charte.formate(this.jspTPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add((Component)pPoly, "North");
        pPolys.add((Component)this.jspTPolys, "Center");
        this.pTypesLiens.setBottomComponent(pPolys);
        this.refaisListesT();
    }

    private void calculePProprietes() {
        this.pProprietes = new JSplitPane(0);
        Charte.formate(this.pProprietes);
        this.pProprietes.setContinuousLayout(true);
        final JButton labTermes2 = new JButton(Charte.getMessage("Panel_InstrB"), Charte.getSmiley("dat/img/_study.gif"));
        Charte.formate(labTermes2);
        labTermes2.setHorizontalAlignment(2);
        labTermes2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PanelHomonymes.this.helpPProprietes) {
                    labTermes2.setText(Charte.getMessage("Panel_InstrB"));
                    PanelHomonymes.this.helpPProprietes = false;
                } else {
                    labTermes2.setText(Charte.getMessage("PanelHomo_InstrP"));
                    PanelHomonymes.this.helpPProprietes = true;
                }
            }
        });
        labTermes2.setBorder(Charte.getBorder());
        this.jspPTermes2 = new JScrollPane();
        Charte.formate(this.jspPTermes2);
        Charte.formate(this.jspPTermes2.getViewport());
        Charte.formate(this.jspPTermes2.getHorizontalScrollBar());
        Charte.formate(this.jspPTermes2.getVerticalScrollBar());
        JPanel pTermes2 = new JPanel(new BorderLayout());
        Charte.formate(pTermes2);
        pTermes2.setBorder(Charte.getBorder());
        pTermes2.add((Component)labTermes2, "North");
        pTermes2.add((Component)this.jspPTermes2, "Center");
        this.pProprietes.setTopComponent(pTermes2);
        JLabel labPoly = new JLabel(Charte.getMessage("PanelHomo_TxtList"), 0);
        Charte.formate(labPoly);
        labPoly.setBorder(Charte.getBorder());
        JPanel pPoly = new JPanel(new BorderLayout());
        pPoly.add((Component)labPoly, "Center");
        Charte.formate(pPoly);
        this.jspPPolys = new JScrollPane();
        Charte.formate(this.jspPPolys);
        Charte.formate(this.jspPPolys.getViewport());
        Charte.formate(this.jspPPolys.getHorizontalScrollBar());
        Charte.formate(this.jspPPolys.getVerticalScrollBar());
        JPanel pPolys = new JPanel(new BorderLayout());
        Charte.formate(pPolys);
        pPolys.setBorder(Charte.getBorder());
        pPolys.add((Component)pPoly, "North");
        pPolys.add((Component)this.jspPPolys, "Center");
        this.pProprietes.setBottomComponent(pPolys);
        this.refaisListesP();
    }

    private void refaisListesN() {
        this.lNPolys = new JList<MotHomonyme>(this.confrontation.getListeMotsPolysemiques(this.confrontation.getComparateurHomonymes()));
        Charte.formate(this.lNPolys);
        this.lNPolys.setDragEnabled(true);
        this.lNPolys.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(0));
                Charte.formate(r);
                for (int i = 0; i < m.getMots().length; ++i) {
                    JLabel res = PanelHomonymes.this.legende.getClasseur(m.getMots()[i].getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if (i >= m.getMots().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    r.add(lab3);
                }
                JLabel l = new JLabel("{" + m.getLien() + "}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>" + m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        this.lNTermes2 = new JList<TexteCommun>(this.confrontation.getListeMotsNonPolysemiques(this.confrontation.getComparateurAlphabetique()));
        Charte.formate(this.lNTermes2);
        this.lNTermes2.setDragEnabled(true);
        this.lNTermes2.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelHomonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspNPolys.setViewportView(this.lNPolys);
        this.jspNTermes2.setViewportView(this.lNTermes2);
        this.dtN = new DropTarget(this.lNPolys, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; ++i) {
                            ListeSynonymes[] l = PanelHomonymes.this.confrontation.getListesSynonymesNoeuds(PanelHomonymes.this.confrontation.trouveTermeNoeud(res[i]));
                            boolean faire = false;
                            MotHomonyme h = PanelHomonymes.this.confrontation.trouveMotPolysemique(res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_DejaFait"), Charte.getMessage("PanelHomo_DejaFaitT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
                            } else {
                                faire = true;
                            }
                            if (!faire) continue;
                            DialogueAnnotation d = new DialogueAnnotation((Component)PanelHomonymes.this.parent, PanelHomonymes.this.confrontation.trouveTermeNoeud(res[i]), Charte.getMessage("PanelHomo_Justification") + " \"" + res[i] + "\" : ", PanelHomonymes.this.confrontation.getRaisonsEloigner());
                            d.setVisible(true);
                            if (d.isAnnule() || d.getRepartition().length <= 1) continue;
                            TexteCommun t = PanelHomonymes.this.confrontation.trouveTermeNoeud(res[i]);
                            PanelHomonymes.this.confrontation.addMotPolysemique(d.getRepartition(), d.getChoix(), d.getCommentaires());
                            if (l.length <= 0) continue;
                            for (int j = 0; j < l.length; ++j) {
                                MotHomonyme mh = PanelHomonymes.this.confrontation.trouveMotPolysemique(d.getRepartition()[0].getTexte());
                                DialogueAnnotation d2 = new DialogueAnnotation((Component)PanelHomonymes.this.parent, l[j], mh.getMots(), Charte.getMessage("PanelHomo_Repercut") + " ");
                                d2.setVisible(true);
                                l[j].replace(t, d2.getTexteCommunChoisi());
                            }
                        }
                        EventHandler.notifyEvent(5000, "");
                        PanelHomonymes.this.refaisListesN();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtN2 = new DropTarget(this.lNTermes2, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if (res.length > 0) {
                        int i;
                        for (i = 0; i < res.length; ++i) {
                            int l = PanelHomonymes.this.confrontation.getListesSynonymesNoeuds(PanelHomonymes.this.confrontation.trouveMotPolysemique(res[i].split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Retouche"), Charte.getMessage("PanelHomo_RetoucheT"), 0, 1, Charte.getSmiley("dat/img/_cligne.gif"));
                                if (choix == 0) {
                                    faire = true;
                                    continue;
                                }
                                JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Annuler"), Charte.getMessage("PanelHomo_AnnulerT"), -1, 1, Charte.getSmiley("dat/img/_mouais.gif"));
                                faire = false;
                                continue;
                            }
                            if (l != 0 || demande) continue;
                            faire = true;
                        }
                        for (i = 0; i < res.length; ++i) {
                            if (!faire) continue;
                            String mot = res[i].split("\\-")[0].trim();
                            PanelHomonymes.this.confrontation.removeMotPolysemique(mot);
                        }
                        EventHandler.notifyEvent(5000, "");
                        PanelHomonymes.this.refaisListesN();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void refaisListesT() {
        this.lTPolys = new JList<MotHomonyme>(this.confrontation.getListeTypesLiensPolysemiques(this.confrontation.getComparateurHomonymes()));
        Charte.formate(this.lTPolys);
        this.lTPolys.setDragEnabled(true);
        this.lTPolys.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(0));
                Charte.formate(r);
                for (int i = 0; i < m.getMots().length; ++i) {
                    JLabel res = PanelHomonymes.this.legende.getClasseur(m.getMots()[i].getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if (i >= m.getMots().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    r.add(lab3);
                }
                JLabel l = new JLabel("{" + m.getLien() + "}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>" + m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        this.lTTermes2 = new JList<TexteCommun>(this.confrontation.getListeTypesLiensNonPolysemiques(this.confrontation.getComparateurAlphabetique()));
        Charte.formate(this.lTTermes2);
        this.lTTermes2.setDragEnabled(true);
        this.lTTermes2.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelHomonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspTPolys.setViewportView(this.lTPolys);
        this.jspTTermes2.setViewportView(this.lTTermes2);
        this.dtT = new DropTarget(this.lTPolys, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; ++i) {
                            ListeSynonymes[] l = PanelHomonymes.this.confrontation.getListesSynonymesTypesLiens(PanelHomonymes.this.confrontation.trouveTermeTypeLien(res[i]));
                            boolean faire = false;
                            MotHomonyme h = PanelHomonymes.this.confrontation.trouveTypeLienPolysemique(res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_DejaFait"), Charte.getMessage("PanelHomo_DejaFaitT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
                            } else {
                                faire = true;
                            }
                            if (!faire) continue;
                            DialogueAnnotation d = new DialogueAnnotation((Component)PanelHomonymes.this.parent, PanelHomonymes.this.confrontation.trouveTermeTypeLien(res[i]), Charte.getMessage("PanelHomo_Justification") + " \"" + res[i] + "\" : ", PanelHomonymes.this.confrontation.getRaisonsEloigner());
                            d.setVisible(true);
                            if (d.isAnnule() || d.getRepartition().length <= 1) continue;
                            TexteCommun t = PanelHomonymes.this.confrontation.trouveTermeTypeLien(res[i]);
                            PanelHomonymes.this.confrontation.addTypeLienPolysemique(d.getRepartition(), d.getChoix(), d.getCommentaires());
                            if (l.length <= 0) continue;
                            for (int j = 0; j < l.length; ++j) {
                                MotHomonyme mh = PanelHomonymes.this.confrontation.trouveTypeLienPolysemique(d.getRepartition()[0].getTexte());
                                DialogueAnnotation d2 = new DialogueAnnotation((Component)PanelHomonymes.this.parent, l[j], mh.getMots(), Charte.getMessage("PanelHomo_Repercut") + " ");
                                d2.setVisible(true);
                                l[j].replace(t, d2.getTexteCommunChoisi());
                            }
                        }
                        EventHandler.notifyEvent(5000, "");
                        PanelHomonymes.this.refaisListesT();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtT2 = new DropTarget(this.lTTermes2, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if (res.length > 0) {
                        int i;
                        for (i = 0; i < res.length; ++i) {
                            int l = PanelHomonymes.this.confrontation.getListesSynonymesTypesLiens(PanelHomonymes.this.confrontation.trouveTypeLienPolysemique(res[i].split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Retouche"), Charte.getMessage("PanelHomo_RetoucheT"), 0, 1, Charte.getSmiley("dat/img/_cligne.gif"));
                                if (choix == 0) {
                                    faire = true;
                                    continue;
                                }
                                JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Annuler"), Charte.getMessage("PanelHomo_AnnulerT"), -1, 1, Charte.getSmiley("dat/img/_mouais.gif"));
                                faire = false;
                                continue;
                            }
                            if (l != 0 || demande) continue;
                            faire = true;
                        }
                        for (i = 0; i < res.length; ++i) {
                            if (!faire) continue;
                            String mot = res[i].split("\\-")[0].trim();
                            PanelHomonymes.this.confrontation.removeTypeLienPolysemique(mot);
                            EventHandler.notifyEvent(5000, "");
                            PanelHomonymes.this.refaisListesT();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }

    private void refaisListesP() {
        this.lPPolys = new JList<MotHomonyme>(this.confrontation.getListeProprietesPolysemiques(this.confrontation.getComparateurHomonymes()));
        Charte.formate(this.lPPolys);
        this.lPPolys.setDragEnabled(true);
        this.lPPolys.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                MotHomonyme m = (MotHomonyme)value;
                JPanel r = new JPanel(new FlowLayout(0));
                Charte.formate(r);
                for (int i = 0; i < m.getMots().length; ++i) {
                    JLabel res = PanelHomonymes.this.legende.getClasseur(m.getMots()[i].getConcernes());
                    Charte.formate(res);
                    JLabel res2 = new JLabel(m.getMots()[i].getTexte());
                    Charte.formate(res2);
                    r.add(res);
                    r.add(res2);
                    if (i >= m.getMots().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    r.add(lab3);
                }
                JLabel l = new JLabel("{" + m.getLien() + "}");
                Charte.formate(l);
                r.add(l);
                r.setToolTipText("<html>" + m.getCommentaire().replaceAll("\\n", "<br>"));
                if (isSelected) {
                    r.setOpaque(true);
                    r.setBackground(new Color(0, 0, 0, 64));
                }
                return r;
            }
        });
        this.lPTermes2 = new JList<TexteCommun>(this.confrontation.getListeProprietesNonPolysemiques(this.confrontation.getComparateurAlphabetique()));
        Charte.formate(this.lPTermes2);
        this.lPTermes2.setDragEnabled(true);
        this.lPTermes2.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = PanelHomonymes.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.jspPPolys.setViewportView(this.lPPolys);
        this.jspPTermes2.setViewportView(this.lPTermes2);
        this.dtP = new DropTarget(this.lPPolys, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    if (res.length > 0) {
                        for (int i = 0; i < res.length; ++i) {
                            ListeSynonymes[] l = PanelHomonymes.this.confrontation.getListesSynonymesProprietes(PanelHomonymes.this.confrontation.trouveTermePropriete(res[i]));
                            boolean faire = false;
                            MotHomonyme h = PanelHomonymes.this.confrontation.trouveProprietePolysemique(res[i].split(" \\- ")[0]);
                            if (h != null) {
                                JOptionPane.showMessageDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_DejaFait"), Charte.getMessage("PanelHomo_DejaFaitT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
                            } else {
                                faire = true;
                            }
                            if (!faire) continue;
                            DialogueAnnotation d = new DialogueAnnotation((Component)PanelHomonymes.this.parent, PanelHomonymes.this.confrontation.trouveTermePropriete(res[i]), Charte.getMessage("PanelHomo_Justification") + " \"" + res[i] + "\" : ", PanelHomonymes.this.confrontation.getRaisonsEloigner());
                            d.setVisible(true);
                            if (d.isAnnule() || d.getRepartition().length <= 1) continue;
                            TexteCommun t = PanelHomonymes.this.confrontation.trouveTermePropriete(res[i]);
                            PanelHomonymes.this.confrontation.addProprietePolysemique(d.getRepartition(), d.getChoix(), d.getCommentaires());
                            if (l.length <= 0) continue;
                            for (int j = 0; j < l.length; ++j) {
                                MotHomonyme mh = PanelHomonymes.this.confrontation.trouveProprietePolysemique(d.getRepartition()[0].getTexte());
                                DialogueAnnotation d2 = new DialogueAnnotation((Component)PanelHomonymes.this.parent, l[j], mh.getMots(), Charte.getMessage("PanelHomo_Repercut") + " ");
                                d2.setVisible(true);
                                l[j].replace(t, d2.getTexteCommunChoisi());
                            }
                        }
                        EventHandler.notifyEvent(5000, "");
                        PanelHomonymes.this.refaisListesP();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.dtP2 = new DropTarget(this.lPTermes2, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String[] res = ((String)dtde.getTransferable().getTransferData(new DataFlavor(String.class, null))).split("\n");
                    boolean faire = false;
                    boolean demande = false;
                    if (res.length > 0) {
                        int i;
                        for (i = 0; i < res.length; ++i) {
                            int l = PanelHomonymes.this.confrontation.getListesSynonymesProprietes(PanelHomonymes.this.confrontation.trouveProprietePolysemique(res[i].split("\\-")[0].trim())).length;
                            if (l > 0 && !demande) {
                                demande = true;
                                int choix = JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Retouche"), Charte.getMessage("PanelHomo_RetoucheT"), 0, 1, Charte.getSmiley("dat/img/_cligne.gif"));
                                if (choix == 0) {
                                    faire = true;
                                    continue;
                                }
                                JOptionPane.showConfirmDialog(PanelHomonymes.this.parent, Charte.getMessage("PanelHomo_Annuler"), Charte.getMessage("PanelHomo_AnnulerT"), -1, 1, Charte.getSmiley("dat/img/_mouais.gif"));
                                faire = false;
                                continue;
                            }
                            if (l != 0 || demande) continue;
                            faire = true;
                        }
                        for (i = 0; i < res.length; ++i) {
                            if (!faire) continue;
                            String mot = res[i].split("\\-")[0].trim();
                            PanelHomonymes.this.confrontation.removeProprietePolysemique(mot);
                            EventHandler.notifyEvent(5000, "");
                            PanelHomonymes.this.refaisListesP();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        System.gc();
    }
}

