/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Confrontation;
import data.LienEntreListes;
import data.ListeSynonymes;
import ihm.Charte;
import ihm.FenetrePrincipale;
import ihm.Legende;
import ihm.townto.EventHandler;
import ihm.townto.EventListener;
import ihm.townto.LinkFailureException;
import ihm.townto.MultiPVGraph;
import ihm.townto.MultiPVGraphPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelConfrontation
extends JPanel
implements EventListener {
    private Legende legende;
    private Confrontation confrontation;
    private MultiPVGraphPanel graphe;
    private JList lLiens = new JList();
    private JScrollPane spLiens;

    public PanelConfrontation(FenetrePrincipale container, Confrontation confrontation) {
        this.setLayout(new BorderLayout());
        Charte.formate(this);
        this.legende = new Legende(confrontation.getAllNomsGraphes());
        this.confrontation = confrontation;
        EventHandler.register(this);
        JSplitPane pVisuGraphe = new JSplitPane(1);
        Charte.formate(pVisuGraphe);
        pVisuGraphe.setContinuousLayout(true);
        this.spLiens = new JScrollPane();
        Charte.formate(this.spLiens);
        Charte.formate(this.spLiens.getViewport());
        Charte.formate(this.spLiens.getHorizontalScrollBar());
        Charte.formate(this.spLiens.getVerticalScrollBar());
        pVisuGraphe.setLeftComponent(this.spLiens);
        MultiPVGraph g = new MultiPVGraph();
        if (confrontation.getListeCompleteNoeudsLies().length > 0) {
            g = this.remplissageGraphe(confrontation.getListeCompleteNoeudsLies()[0]);
        }
        if (!g.isExhaustive() && this.hasFocus()) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("PanelConf_GrapheTropGros"), Charte.getMessage("PanelConf_GrapheTropGrosT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
        }
        this.graphe = new MultiPVGraphPanel(confrontation.getNombreDeGraphes(), g, 0);
        JScrollPane spGraphe = new JScrollPane(this.graphe){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getSize().width * 0.8), this.getSize().height);
            }
        };
        Charte.formate(spGraphe);
        Charte.formate(spGraphe.getViewport());
        Charte.formate(spGraphe.getHorizontalScrollBar());
        Charte.formate(spGraphe.getVerticalScrollBar());
        pVisuGraphe.setRightComponent(spGraphe);
        pVisuGraphe.setDividerSize(5);
        pVisuGraphe.setDividerLocation(0.2);
        this.add((Component)this.legende.getLegendeTextuelle(), "North");
        this.add((Component)pVisuGraphe, "Center");
        this.refaisListe();
    }

    private void refaisListe() {
        Object value = this.lLiens.getSelectedValue();
        if (this.confrontation.getListeCompleteNoeudsLies().length > 0) {
            this.lLiens = new JList<ListeSynonymes>(this.confrontation.getListeCompleteNoeudsLies());
        } else {
            ListeSynonymes[] x = new ListeSynonymes[]{new ListeSynonymes("", "")};
            this.lLiens = new JList<ListeSynonymes>(x);
        }
        Charte.formate(this.lLiens);
        this.lLiens.setSelectionMode(0);
        this.lLiens.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel res = new JPanel(new FlowLayout(0));
                ListeSynonymes l = (ListeSynonymes)value;
                for (int i = 0; i < l.getListe().length; ++i) {
                    JLabel lab = PanelConfrontation.this.legende.getClasseur(l.getListe()[i].getConcernes());
                    Charte.formate(lab);
                    JLabel lab2 = new JLabel(l.getListe()[i].getTexte());
                    Charte.formate(lab2);
                    res.add(lab);
                    res.add(lab2);
                    if (i >= l.getListe().length - 1) continue;
                    JLabel lab3 = new JLabel(";");
                    Charte.formate(lab3);
                    res.add(lab3);
                }
                JLabel res4 = new JLabel("{" + l.getLien() + "}");
                Charte.formate(res4);
                res.add(res4);
                Charte.formate(res);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                }
                return res;
            }
        });
        this.lLiens.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                PanelConfrontation.this.changeGraphe();
            }
        });
        this.spLiens.setViewportView(this.lLiens);
        this.lLiens.setSelectedValue(value, true);
        Object value2 = this.lLiens.getSelectedValue();
        if (value2 == null) {
            this.lLiens.setSelectedIndex(0);
        }
    }

    private void changeGraphe() {
        MultiPVGraph g = new MultiPVGraph();
        g = this.remplissageGraphe((ListeSynonymes)this.lLiens.getSelectedValue());
        if (!g.isExhaustive() && this.hasFocus()) {
            JOptionPane.showMessageDialog(this, Charte.getMessage("PanelConf_GrapheTropGros"), Charte.getMessage("PanelConf_GrapheTropGrosT"), 1, Charte.getSmiley("dat/img/_mouais.gif"));
        }
        this.graphe.setGraph(g);
    }

    private MultiPVGraph remplissageGraphe(ListeSynonymes liste) {
        MultiPVGraph resultat = new MultiPVGraph();
        resultat.setActive(liste, liste.getLien());
        boolean[] b = new boolean[this.confrontation.getNombreDeGraphes()];
        for (int i = 0; i < liste.getListe().length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                b[j] = b[j] || liste.getListe()[i].getConcernes()[j];
            }
        }
        LienEntreListes[] liens = this.confrontation.getListesLiees(liste);
        Vector<LienEntreListes> l = new Vector<LienEntreListes>();
        for (int i = 0; i < liens.length; ++i) {
            if (l.contains(liens[i])) continue;
            l.addElement(liens[i]);
            try {
                resultat.addLink(liens[i].getOrigine(), "", liens[i].getDestination(), "");
            }
            catch (LinkFailureException lfe) {
                lfe.printStackTrace();
            }
            LienEntreListes[] liens2 = liste.equals(liens[i].getOrigine()) ? this.confrontation.getListesLiees(liens[i].getDestination()) : this.confrontation.getListesLiees(liens[i].getOrigine());
            Vector<LienEntreListes> l2 = new Vector<LienEntreListes>();
            for (int j = 0; j < liens2.length; ++j) {
                if (l2.contains(liens2[j])) continue;
                l2.addElement(liens2[j]);
                if (!liens2[j].getOrigine().intersects(b) || !liens2[j].getDestination().intersects(b)) continue;
                try {
                    resultat.addLink(liens2[j].getOrigine(), "", liens2[j].getDestination(), "");
                    continue;
                }
                catch (LinkFailureException lfe) {
                    lfe.printStackTrace();
                }
            }
        }
        return resultat;
    }

    @Override
    public void notifyEvent(int eventCode, String eventContent) {
        if (eventCode == 5000) {
            this.refaisListe();
        }
    }
}

