/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import data.Confrontation;
import data.ListeSynonymes;
import data.TexteCommun;
import ihm.Charte;
import ihm.Legende;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class DialogueAnnotation
extends JDialog {
    private JComboBox cReponses;
    private JTextArea tComm;
    private JTextField tPrecis;
    private boolean canceled = false;
    private JPanel pMain;
    private JList lRepartition;
    private JPanel pRepartition;
    private Legende legende;
    private Vector repartition;

    public DialogueAnnotation(Component parentComponent, ListeSynonymes liste, TexteCommun[] repartition, String desc) {
        super(JOptionPane.getFrameForComponent(parentComponent), true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setUndecorated(true);
        this.pMain = new JPanel(new BorderLayout());
        this.pMain.setBorder(Charte.getBorder());
        JPanel pMain2 = new JPanel(new BorderLayout());
        JPanel pNord = new JPanel(new BorderLayout());
        JLabel lQuestion = new JLabel(desc, 0);
        pNord.add((Component)lQuestion, "North");
        JPanel pSujet = new JPanel(new FlowLayout());
        this.legende = new Legende(liste.getListe()[0].getConcernes().length);
        for (int i = 0; i < liste.getListe().length; ++i) {
            JLabel l1 = this.legende.getClasseur(liste.getListe()[i].getConcernes());
            JLabel l2 = new JLabel(liste.getListe()[i].getTexte());
            Charte.formate(l2);
            pSujet.add(l1);
            pSujet.add(l2);
        }
        pSujet.add(new JLabel("{" + liste.getLien() + "}"));
        pNord.add((Component)pSujet, "South");
        pMain2.add((Component)pNord, "North");
        JPanel pCenter = new JPanel(new BorderLayout());
        this.cReponses = new JComboBox<TexteCommun>(repartition);
        this.cReponses.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = DialogueAnnotation.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                Charte.formate(p);
                return p;
            }
        });
        pCenter.add((Component)this.cReponses, "North");
        JLabel lComm = new JLabel(Charte.getMessage("Anno_Comment"), 0);
        pCenter.add((Component)lComm, "Center");
        this.tComm = new JTextArea(liste.getCommentaire(), 10, 20);
        this.tComm.setLineWrap(true);
        this.tComm.setWrapStyleWord(true);
        this.tComm.setAutoscrolls(false);
        JScrollPane spComm = new JScrollPane(this.tComm);
        Charte.formate(spComm);
        Charte.formate(spComm.getViewport());
        Charte.formate(spComm.getHorizontalScrollBar());
        Charte.formate(spComm.getVerticalScrollBar());
        pCenter.add((Component)spComm, "Center");
        pMain2.add((Component)pCenter, "Center");
        JPanel pBoutons = new JPanel(new FlowLayout());
        JButton bOK = new JButton(Charte.OK);
        pBoutons.add(bOK);
        bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogueAnnotation.this.canceled = false;
                DialogueAnnotation.this.setVisible(false);
            }
        });
        this.pMain.add((Component)pMain2, "Center");
        this.pMain.add((Component)pBoutons, "South");
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pack();
        int x = parentComponent.getX() + (parentComponent.getWidth() - this.getWidth()) / 2;
        int y = parentComponent.getY() + (parentComponent.getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
        bOK.requestFocus();
    }

    public DialogueAnnotation(Component parentComponent, TexteCommun mot, String desc, String[] choix) {
        this(parentComponent, desc, choix);
        this.legende = new Legende(mot.getConcernes().length);
        JPanel pMain3 = new JPanel(new BorderLayout());
        this.pRepartition = new JPanel(new BorderLayout());
        this.repartition = new Vector();
        for (int i = 0; i < mot.getConcernes().length; ++i) {
            if (!mot.getConcernes()[i]) continue;
            TexteCommun t = new TexteCommun(mot.getTexte(), mot.getConcernes().length);
            t.addConcerne(i, true);
            this.repartition.addElement(t);
        }
        this.remplisListe();
        pMain3.add((Component)this.pRepartition, "Center");
        JButton bFus = new JButton(Charte.getMessage("Anno_Fusion"));
        bFus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogueAnnotation.this.fusion();
            }
        });
        JButton bDiv = new JButton(Charte.getMessage("Anno_Separer"));
        bDiv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogueAnnotation.this.division();
            }
        });
        JPanel pB = new JPanel(new FlowLayout());
        pB.add(bFus);
        pB.add(bDiv);
        pMain3.add((Component)pB, "South");
        this.pMain.add((Component)pMain3, "North");
        this.pack();
        int x = parentComponent.getX() + (parentComponent.getWidth() - this.getWidth()) / 2;
        int y = parentComponent.getY() + (parentComponent.getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    public DialogueAnnotation(Component parentComponent, String desc, String[] choix) {
        super(JOptionPane.getFrameForComponent(parentComponent), true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setUndecorated(true);
        this.pMain = new JPanel(new BorderLayout());
        this.pMain.setBorder(Charte.getBorder());
        JPanel pMain2 = new JPanel(new BorderLayout());
        JPanel pNord = new JPanel(new BorderLayout());
        JLabel lQuestion = new JLabel(desc, 0);
        pNord.add((Component)lQuestion, "North");
        this.cReponses = new JComboBox<String>(choix);
        pNord.add((Component)this.cReponses, "Center");
        JPanel pPrecis = new JPanel(new BorderLayout());
        JLabel lPrecis = new JLabel(Charte.getMessage("Anno_AutreRaison") + " ");
        this.tPrecis = new JTextField(20);
        pPrecis.add((Component)lPrecis, "West");
        pPrecis.add((Component)this.tPrecis, "East");
        pNord.add((Component)pPrecis, "South");
        pMain2.add((Component)pNord, "North");
        JPanel pCenter = new JPanel(new BorderLayout());
        JLabel lComm = new JLabel(Charte.getMessage("Anno_Comment"), 0);
        pCenter.add((Component)lComm, "North");
        this.tComm = new JTextArea(10, 20);
        this.tComm.setLineWrap(true);
        this.tComm.setWrapStyleWord(true);
        this.tComm.setAutoscrolls(false);
        JScrollPane spComm = new JScrollPane(this.tComm);
        Charte.formate(spComm);
        Charte.formate(spComm.getViewport());
        Charte.formate(spComm.getHorizontalScrollBar());
        Charte.formate(spComm.getVerticalScrollBar());
        pCenter.add((Component)spComm, "Center");
        pMain2.add((Component)pCenter, "Center");
        JPanel pBoutons = new JPanel(new FlowLayout());
        JButton bOK = new JButton(Charte.OK);
        pBoutons.add(bOK);
        bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogueAnnotation.this.canceled = false;
                DialogueAnnotation.this.setVisible(false);
            }
        });
        JButton bCancel = new JButton(Charte.CANCEL);
        pBoutons.add(bCancel);
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DialogueAnnotation.this.canceled = true;
                DialogueAnnotation.this.setVisible(false);
            }
        });
        this.pMain.add((Component)pMain2, "Center");
        this.pMain.add((Component)pBoutons, "South");
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pack();
        int x = parentComponent.getX() + (parentComponent.getWidth() - this.getWidth()) / 2;
        int y = parentComponent.getY() + (parentComponent.getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
        bOK.requestFocus();
    }

    public String getChoix() {
        String resultat = "";
        resultat = this.cReponses.getSelectedItem().toString().equals(Confrontation.RAISON_A_PRECISER) ? this.tPrecis.getText() : this.cReponses.getSelectedItem().toString();
        return resultat;
    }

    public TexteCommun getTexteCommunChoisi() {
        return (TexteCommun)this.cReponses.getSelectedItem();
    }

    public String getCommentaires() {
        return this.tComm.getText();
    }

    public TexteCommun[] getRepartition() {
        TexteCommun[] t = new TexteCommun[this.repartition.size()];
        this.repartition.toArray(t);
        return t;
    }

    public boolean isAnnule() {
        return this.canceled;
    }

    private void remplisListe() {
        this.pRepartition.removeAll();
        TexteCommun[] t = new TexteCommun[this.repartition.size()];
        this.repartition.toArray(t);
        this.lRepartition = new JList<TexteCommun>(t);
        this.lRepartition.setSelectionMode(2);
        this.lRepartition.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel res = DialogueAnnotation.this.legende.getClasseur(((TexteCommun)value).getConcernes());
                Charte.formate(res);
                JLabel res2 = new JLabel(((TexteCommun)value).getTexte());
                Charte.formate(res2);
                if (isSelected) {
                    res.setOpaque(true);
                    res.setBackground(new Color(0, 0, 0, 64));
                    res2.setOpaque(true);
                    res2.setBackground(new Color(0, 0, 0, 64));
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)res, "West");
                p.add((Component)res2, "Center");
                p.setOpaque(false);
                return p;
            }
        });
        this.pRepartition.add((Component)this.lRepartition, "Center");
        this.pack();
    }

    private void fusion() {
        int i;
        TexteCommun[] liste = new TexteCommun[this.lRepartition.getSelectedIndices().length];
        for (int i2 = 0; i2 < liste.length; ++i2) {
            liste[i2] = (TexteCommun)this.lRepartition.getModel().getElementAt(this.lRepartition.getSelectedIndices()[i2]);
        }
        TexteCommun res = new TexteCommun(liste[0].getTexte(), liste[0].getConcernes().length);
        for (i = 0; i < liste.length; ++i) {
            for (int j = 0; j < liste[0].getConcernes().length; ++j) {
                if (!liste[i].getConcernes()[j]) continue;
                res.addConcerne(j, true);
            }
        }
        for (i = 0; i < this.repartition.size(); ++i) {
            for (int k = 0; k < liste.length; ++k) {
                boolean[] b0 = liste[k].getConcernes();
                boolean[] b1 = ((TexteCommun)this.repartition.elementAt(i)).getConcernes();
                boolean bon = true;
                for (int j = 0; j < b0.length; ++j) {
                    if (b0[j] == b1[j]) continue;
                    bon = false;
                }
                if (!bon) continue;
                this.repartition.removeElementAt(i);
            }
        }
        this.repartition.add(res);
        this.remplisListe();
    }

    private void division() {
        int i;
        TexteCommun liste = (TexteCommun)this.lRepartition.getSelectedValue();
        for (i = 0; i < this.repartition.size(); ++i) {
            boolean[] b0 = liste.getConcernes();
            boolean[] b1 = ((TexteCommun)this.repartition.elementAt(i)).getConcernes();
            boolean bon = true;
            for (int j = 0; j < b0.length; ++j) {
                if (b0[j] == b1[j]) continue;
                bon = false;
            }
            if (!bon) continue;
            this.repartition.removeElementAt(i);
            break;
        }
        for (i = 0; i < liste.getConcernes().length; ++i) {
            if (!liste.getConcernes()[i]) continue;
            TexteCommun t = new TexteCommun(liste.getTexte(), liste.getConcernes().length);
            t.addConcerne(i, true);
            this.repartition.addElement(t);
        }
        this.remplisListe();
    }
}

