/*
 * Decompiled with CFR 0.152.
 */
package data;

public class TexteCommun {
    private String texte = "";
    private boolean[] concerne;

    public TexteCommun(String texte, int nbPdV) {
        this.texte = texte;
        this.concerne = new boolean[nbPdV];
        for (int i = 0; i < this.concerne.length; ++i) {
            this.concerne[i] = false;
        }
    }

    public TexteCommun(String texte, boolean[] concerne) {
        this.texte = texte;
        this.concerne = concerne;
    }

    public TexteCommun(String sauvegarde) {
        String[] s = sauvegarde.split("\\$");
        this.texte = s[0];
        this.concerne = new boolean[s[1].length()];
        for (int i = 0; i < s[1].length(); ++i) {
            this.concerne[i] = s[1].charAt(i) == '1';
        }
    }

    public String getSauvegarde() {
        String con = "";
        for (int i = 0; i < this.concerne.length; ++i) {
            con = this.concerne[i] ? con + "1" : con + "0";
        }
        return this.texte + "$" + con;
    }

    public void addConcerne(int index, boolean oui) {
        this.concerne[index] = oui;
    }

    public String getTexte() {
        return this.texte;
    }

    public String toString() {
        return this.texte;
    }

    public boolean equals(Object o) {
        return this.texte.equalsIgnoreCase(((TexteCommun)o).texte);
    }

    public boolean hasPVCommun(TexteCommun t) {
        boolean result = false;
        for (int i = 0; i < this.concerne.length; ++i) {
            if (!this.concerne[i] || !t.concerne[i]) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean[] getConcernes() {
        return this.concerne;
    }
}

