/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.TexteCommun;
import ihm.Charte;
import java.util.HashSet;
import java.util.Vector;

public class ListeSynonymes {
    private HashSet synos;
    private String lien = "";
    private String comm = "";

    public ListeSynonymes(String lien, String comm) {
        this.synos = new HashSet();
        this.lien = lien;
        this.comm = comm;
    }

    public ListeSynonymes(TexteCommun[] liste) {
        this.synos = new HashSet();
        for (int i = 0; i < liste.length; ++i) {
            this.synos.add(liste[i]);
        }
    }

    public ListeSynonymes(String sauvegarde) {
        String[] s = sauvegarde.split("::");
        this.lien = s[0];
        this.comm = s[1];
        this.synos = new HashSet();
        for (int i = 2; i < s.length; ++i) {
            TexteCommun t = new TexteCommun(s[i]);
            this.synos.add(t);
        }
    }

    public String getSauvegarde() {
        TexteCommun[] syn = new TexteCommun[this.synos.size()];
        this.synos.toArray(syn);
        String s = "";
        s = s + this.lien + "::" + this.comm + "::";
        for (int i = 0; i < syn.length; ++i) {
            s = s + syn[i].getSauvegarde();
            if (i >= syn.length - 1) continue;
            s = s + "::";
        }
        return s;
    }

    public void add(TexteCommun syno) {
        this.synos.add(syno);
    }

    public void remove(TexteCommun syno) {
        this.synos.remove(syno);
    }

    public void replace(TexteCommun orig, TexteCommun repl) {
        this.remove(orig);
        this.add(repl);
    }

    public boolean contains(TexteCommun syno) {
        boolean res = false;
        Vector v = new Vector(this.synos);
        for (int i = 0; i < v.size(); ++i) {
            if (!((TexteCommun)v.elementAt(i)).equals(syno)) continue;
            res = true;
            break;
        }
        return res;
    }

    public void termeFusionne(TexteCommun ini, TexteCommun nouv) {
        Vector v = new Vector(this.synos);
        for (int i = 0; i < this.synos.size(); ++i) {
            TexteCommun t = (TexteCommun)v.elementAt(i);
            if (!t.getTexte().equalsIgnoreCase(ini.getTexte())) continue;
            this.synos.remove(t);
            this.synos.add(nouv);
        }
    }

    public boolean intersects(ListeSynonymes liste) {
        HashSet test = (HashSet)this.synos.clone();
        test.removeAll(liste.synos);
        HashSet test2 = (HashSet)liste.synos.clone();
        test2.removeAll(this.synos);
        return (test.size() == 0 || test2.size() == 0) && this.lien.equals(liste.lien);
    }

    public boolean intersects(boolean[] b) {
        boolean res = false;
        for (int i = 0; i < this.getListe().length; ++i) {
            if (!this.getListe()[i].hasPVCommun(new TexteCommun("", b))) continue;
            res = true;
        }
        return res;
    }

    public void mergeWith(ListeSynonymes liste) {
        this.synos.addAll(liste.synos);
        if (!liste.getLien().equals(this.lien)) {
            this.lien = Charte.getMessage("ListeSyno_Justification");
        }
    }

    public TexteCommun[] getListe() {
        TexteCommun[] res = new TexteCommun[this.synos.size()];
        this.synos.toArray(res);
        return res;
    }

    public String getLien() {
        return this.lien;
    }

    public String getCommentaire() {
        return this.comm;
    }

    private boolean listeEgale(ListeSynonymes l) {
        Vector v = new Vector(this.synos);
        Vector v2 = new Vector(l.synos);
        return v.containsAll(v2) && v2.containsAll(v);
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof ListeSynonymes) {
            ListeSynonymes l = (ListeSynonymes)o;
            return this.listeEgale(l) && (this.lien.equals(l.getLien()) || this.lien.equals("") || l.getLien().equals(""));
        }
        return res;
    }

    public String toString() {
        String res = "";
        for (int i = 0; i < this.getListe().length; ++i) {
            res = res + this.getListe()[i].toString();
            if (i >= this.getListe().length - 1) continue;
            res = res + ";";
        }
        if (!this.lien.equals("")) {
            res = res + "{" + this.lien + "}";
        }
        return res;
    }
}

